/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.rest;

import com.google.common.base.Strings;
import io.ballerina.messaging.broker.common.ValidationException;
import io.ballerina.messaging.broker.common.data.types.FieldTable;
import io.ballerina.messaging.broker.common.data.types.FieldValue;
import io.ballerina.messaging.broker.core.Binding;
import io.ballerina.messaging.broker.core.BindingSet;
import io.ballerina.messaging.broker.core.BrokerException;
import io.ballerina.messaging.broker.core.BrokerFactory;
import io.ballerina.messaging.broker.core.rest.model.BindingCreateRequest;
import io.ballerina.messaging.broker.core.rest.model.BindingCreateResponse;
import io.ballerina.messaging.broker.core.rest.model.BindingSetInfo;
import io.ballerina.messaging.broker.core.rest.model.BindingSetInfoBindings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.security.auth.Subject;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.core.Response;

public class BindingsApiDelegate {
    private final BrokerFactory brokerFactory;

    public BindingsApiDelegate(BrokerFactory brokerFactory) {
        this.brokerFactory = brokerFactory;
    }

    public Response createBinding(String queueName, BindingCreateRequest requestBody, Subject subject) {
        FieldTable fieldTable = new FieldTable();
        String filter = requestBody.getFilterExpression();
        if (Objects.nonNull(filter)) {
            fieldTable.add(Binding.JMS_SELECTOR_ARGUMENT, FieldValue.parseLongString((String)filter));
        }
        if (Objects.isNull(requestBody.getBindingPattern()) || Objects.isNull(requestBody.getExchangeName())) {
            throw new BadRequestException("Exchange name and the binding pattern should be set");
        }
        try {
            this.brokerFactory.getBroker(subject).bind(queueName, requestBody.getExchangeName(), requestBody.getBindingPattern(), fieldTable);
            BindingCreateResponse responsePayload = new BindingCreateResponse().message("Binding created.");
            return Response.created((URI)this.generateLocationHeader(queueName, requestBody)).entity((Object)responsePayload).build();
        }
        catch (BrokerException e) {
            throw new InternalServerErrorException(e.getMessage(), (Throwable)e);
        }
        catch (ValidationException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
        catch (UnsupportedEncodingException | URISyntaxException e) {
            throw new InternalServerErrorException("Error occurred while creating location header for the created binding.", (Throwable)e);
        }
    }

    private URI generateLocationHeader(String queueName, BindingCreateRequest requestBody) throws URISyntaxException, UnsupportedEncodingException {
        StringBuilder locationBuilder = new StringBuilder();
        locationBuilder.append("/broker/v1.0").append("/").append(queueName).append("/bindings/").append(requestBody.getBindingPattern());
        if (!Strings.isNullOrEmpty((String)requestBody.getFilterExpression())) {
            locationBuilder.append("?filterExpression=").append(URLEncoder.encode(requestBody.getFilterExpression(), StandardCharsets.UTF_8.toString()));
        }
        return new URI(locationBuilder.toString());
    }

    public Response getAllBindingsForExchange(String exchangeName, Subject subject) {
        try {
            Map<String, BindingSet> bindingSets = this.brokerFactory.getBroker(subject).getAllBindingsForExchange(exchangeName);
            ArrayList<BindingSetInfo> responsePayload = new ArrayList<BindingSetInfo>();
            for (Map.Entry<String, BindingSet> entry : bindingSets.entrySet()) {
                BindingSetInfo responseBindingSet = new BindingSetInfo().bindingPattern(entry.getKey());
                BindingSet bindingSet = entry.getValue();
                ArrayList<BindingSetInfoBindings> responseBindingList = new ArrayList<BindingSetInfoBindings>();
                this.addUnfilteredBindings(bindingSet, responseBindingList);
                this.addFilteredBindings(bindingSet, responseBindingList);
                responseBindingSet.bindings(responseBindingList);
                responsePayload.add(responseBindingSet);
            }
            return Response.ok().entity(responsePayload).build();
        }
        catch (ValidationException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
    }

    private void addUnfilteredBindings(BindingSet bindingSet, ArrayList<BindingSetInfoBindings> responseBindingList) {
        for (Binding binding : bindingSet.getUnfilteredBindings()) {
            BindingSetInfoBindings responseBinding = new BindingSetInfoBindings().queueName(binding.getQueue().getName());
            responseBindingList.add(responseBinding);
        }
    }

    private void addFilteredBindings(BindingSet bindingSet, ArrayList<BindingSetInfoBindings> responseBindingList) {
        for (Binding binding : bindingSet.getFilteredBindings()) {
            String filter = binding.getArgument(Binding.JMS_SELECTOR_ARGUMENT).getValue().toString();
            BindingSetInfoBindings bindingInfo = new BindingSetInfoBindings().queueName(binding.getQueue().getName()).filterExpression(filter);
            responseBindingList.add(bindingInfo);
        }
    }

    public Response deleteBinding(String queueName, String bindingPattern, String filterExpression, Subject subject) {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build();
    }

    public Response getBinding(String queueName, String bindingPattern, String filterExpression, Subject subject) {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build();
    }
}

