/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.rest;

import io.ballerina.messaging.broker.common.ResourceNotFoundException;
import io.ballerina.messaging.broker.core.BrokerAuthException;
import io.ballerina.messaging.broker.core.BrokerAuthNotFoundException;
import io.ballerina.messaging.broker.core.BrokerException;
import io.ballerina.messaging.broker.core.BrokerFactory;
import io.ballerina.messaging.broker.core.Consumer;
import io.ballerina.messaging.broker.core.QueueHandler;
import io.ballerina.messaging.broker.core.rest.model.ConsumerMetadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.security.auth.Subject;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;

public class ConsumersApiDelegate {
    private final BrokerFactory brokerFactory;

    public ConsumersApiDelegate(BrokerFactory brokerFactory) {
        this.brokerFactory = brokerFactory;
    }

    public Response getConsumer(String queueName, Integer consumerId, Subject subject) {
        QueueHandler queue;
        try {
            queue = this.brokerFactory.getBroker(subject).getQueue(queueName);
        }
        catch (BrokerAuthException e) {
            throw new NotAuthorizedException(e.getMessage(), (Object)e, new Object[0]);
        }
        catch (ResourceNotFoundException | BrokerAuthNotFoundException e) {
            throw new NotFoundException("Unknown queue name " + queueName);
        }
        catch (BrokerException e) {
            throw new InternalServerErrorException(e.getMessage(), (Throwable)e);
        }
        Consumer matchingConsumer = null;
        for (Consumer consumer : queue.getConsumers()) {
            if (consumer.getId() != consumerId.intValue()) continue;
            matchingConsumer = consumer;
            break;
        }
        if (Objects.nonNull(matchingConsumer)) {
            return Response.ok().entity((Object)this.toConsumerMetadata(matchingConsumer)).build();
        }
        throw new NotFoundException("Consumer with id " + consumerId + " for queue " + queueName + " not found.");
    }

    public Response getAllConsumers(String queueName, Subject subject) {
        QueueHandler queueHandler;
        try {
            queueHandler = this.brokerFactory.getBroker(subject).getQueue(queueName);
        }
        catch (BrokerAuthException e) {
            throw new NotAuthorizedException(e.getMessage(), (Object)e, new Object[0]);
        }
        catch (ResourceNotFoundException | BrokerAuthNotFoundException e) {
            throw new NotFoundException("Queue " + queueName + " doesn't exist.", e);
        }
        catch (BrokerException e) {
            throw new InternalServerErrorException(e.getMessage(), (Throwable)e);
        }
        if (Objects.isNull(queueHandler)) {
            throw new NotFoundException("Unknown queue Name " + queueName);
        }
        Collection<Consumer> consumers = queueHandler.getConsumers();
        ArrayList<ConsumerMetadata> consumerMetadataList = new ArrayList<ConsumerMetadata>(consumers.size());
        for (Consumer consumer : consumers) {
            consumerMetadataList.add(this.toConsumerMetadata(consumer));
        }
        return Response.ok().entity(consumerMetadataList).build();
    }

    private ConsumerMetadata toConsumerMetadata(Consumer consumer) {
        return new ConsumerMetadata().id(consumer.getId()).isExclusive(consumer.isExclusive()).flowEnabled(consumer.isReady()).transportProperties(consumer.getTransportProperties());
    }

    public Response deleteConsumer(String queueName, Integer consumerId, Subject subject) {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build();
    }
}

