/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.rest;

import io.ballerina.messaging.broker.auth.AuthNotFoundException;
import io.ballerina.messaging.broker.auth.AuthServerException;
import io.ballerina.messaging.broker.auth.authorization.Authorizer;
import io.ballerina.messaging.broker.auth.authorization.authorizer.rdbms.resource.AuthResource;
import io.ballerina.messaging.broker.auth.authorization.enums.ResourceType;
import io.ballerina.messaging.broker.common.ResourceNotFoundException;
import io.ballerina.messaging.broker.common.ValidationException;
import io.ballerina.messaging.broker.core.BrokerAuthException;
import io.ballerina.messaging.broker.core.BrokerAuthNotFoundException;
import io.ballerina.messaging.broker.core.BrokerException;
import io.ballerina.messaging.broker.core.BrokerFactory;
import io.ballerina.messaging.broker.core.Exchange;
import io.ballerina.messaging.broker.core.rest.model.ActionUserGroupsMapping;
import io.ballerina.messaging.broker.core.rest.model.ExchangeCreateRequest;
import io.ballerina.messaging.broker.core.rest.model.ExchangeCreateResponse;
import io.ballerina.messaging.broker.core.rest.model.ExchangeMetadata;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.security.auth.Subject;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExchangesApiDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExchangesApiDelegate.class);
    public static final String EXCHANGES_API_PATH = "/exchanges";
    private final BrokerFactory brokerFactory;
    private final Authorizer authorizer;

    public ExchangesApiDelegate(BrokerFactory brokerFactory, Authorizer authorizer) {
        this.brokerFactory = brokerFactory;
        this.authorizer = authorizer;
    }

    public Response createExchange(ExchangeCreateRequest requestBody, Subject subject) {
        try {
            this.brokerFactory.getBroker(subject).createExchange(requestBody.getName(), requestBody.getType(), requestBody.isDurable());
            return Response.created((URI)new URI("/broker/v1.0/exchanges/" + requestBody.getName())).entity((Object)new ExchangeCreateResponse().message("Exchange created.")).build();
        }
        catch (ValidationException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            String message = "Invalid URI syntax for the location header.";
            LOGGER.error(message, (Throwable)e);
            throw new InternalServerErrorException(e.getMessage(), (Throwable)e);
        }
        catch (BrokerAuthException e) {
            throw new NotAuthorizedException(e.getMessage(), (Object)e, new Object[0]);
        }
        catch (BrokerException e) {
            String message = "Error occurred while creating exchange.";
            LOGGER.error(message, (Throwable)e);
            throw new InternalServerErrorException(message, (Throwable)e);
        }
    }

    public Response deleteExchange(String exchangeName, boolean ifUnused, Subject subject) {
        try {
            boolean deleted = this.brokerFactory.getBroker(subject).deleteExchange(exchangeName, ifUnused);
            if (!deleted) {
                throw new NotFoundException("Exchange " + exchangeName + " not found.");
            }
            return Response.ok().build();
        }
        catch (BrokerAuthException e) {
            throw new NotAuthorizedException(e.getMessage(), (Object)e, new Object[0]);
        }
        catch (BrokerException e) {
            String message = "Error occurred while deleting exchange " + exchangeName + ".";
            LOGGER.error(message, (Throwable)e);
            throw new InternalServerErrorException(message, (Throwable)e);
        }
        catch (ValidationException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
        catch (ResourceNotFoundException e) {
            throw new NotFoundException("Exchange " + exchangeName + " doesn't exist.", (Throwable)e);
        }
    }

    public Response getAllExchanges(Subject subject) {
        ArrayList<ExchangeMetadata> exchangeMetadataList;
        try {
            Collection<Exchange> exchangeList = this.brokerFactory.getBroker(subject).getAllExchanges();
            exchangeMetadataList = new ArrayList<ExchangeMetadata>(exchangeList.size());
            for (Exchange exchange : exchangeList) {
                exchangeMetadataList.add(this.toExchangeMetadata(exchange));
            }
        }
        catch (BrokerAuthException e) {
            throw new NotAuthorizedException(e.getMessage(), (Object)e, new Object[0]);
        }
        catch (BrokerException e) {
            throw new InternalServerErrorException(e.getMessage(), (Throwable)e);
        }
        return Response.ok().entity(exchangeMetadataList).build();
    }

    public Response getExchange(String exchangeName, Subject subject) {
        ExchangeMetadata exchangeMetadata;
        try {
            Exchange exchange = this.brokerFactory.getBroker(subject).getExchange(exchangeName);
            if (Objects.isNull(exchange)) {
                throw new NotFoundException("Exchange '" + exchangeName + "' not found.");
            }
            exchangeMetadata = this.toExchangeMetadata(exchange);
        }
        catch (BrokerAuthException e) {
            throw new NotAuthorizedException(e.getMessage(), (Object)e, new Object[0]);
        }
        catch (BrokerAuthNotFoundException e) {
            throw new NotFoundException("Exchange " + exchangeName + " doesn't exist.", (Throwable)e);
        }
        catch (BrokerException e) {
            throw new InternalServerErrorException(e.getMessage(), (Throwable)e);
        }
        return Response.ok().entity((Object)exchangeMetadata).build();
    }

    private ExchangeMetadata toExchangeMetadata(Exchange exchange) throws BrokerException {
        ExchangeMetadata exchangeMetadata = new ExchangeMetadata().name(exchange.getName()).type(exchange.getType().toString()).durable(exchange.isDurable());
        try {
            AuthResource authResource = this.authorizer.getAuthResource(ResourceType.EXCHANGE.toString(), exchange.getName());
            if (Objects.nonNull(authResource)) {
                exchangeMetadata.owner(authResource.getOwner()).permissions(this.toActionUserGroupsMapping(authResource.getActionsUserGroupsMap()));
            }
        }
        catch (AuthNotFoundException | AuthServerException e) {
            throw new BrokerException("Error while querying auth resource", e);
        }
        return exchangeMetadata;
    }

    private ArrayList<ActionUserGroupsMapping> toActionUserGroupsMapping(Map<String, Set<String>> actionsUserGroupsMap) {
        ArrayList<ActionUserGroupsMapping> actionUserGroupsMappings = new ArrayList<ActionUserGroupsMapping>(actionsUserGroupsMap.size());
        actionsUserGroupsMap.forEach((action, userGroups) -> {
            ActionUserGroupsMapping actionUserGroupsMapping = new ActionUserGroupsMapping();
            actionUserGroupsMapping.setAction((String)action);
            actionUserGroupsMapping.setUserGroups(new ArrayList<String>((Collection<String>)userGroups));
            actionUserGroupsMappings.add(actionUserGroupsMapping);
        });
        return actionUserGroupsMappings;
    }
}

