/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.rest;

import io.ballerina.messaging.broker.auth.AuthNotFoundException;
import io.ballerina.messaging.broker.auth.AuthServerException;
import io.ballerina.messaging.broker.auth.authorization.Authorizer;
import io.ballerina.messaging.broker.auth.authorization.authorizer.rdbms.resource.AuthResource;
import io.ballerina.messaging.broker.auth.authorization.enums.ResourceType;
import io.ballerina.messaging.broker.common.ResourceNotFoundException;
import io.ballerina.messaging.broker.common.ValidationException;
import io.ballerina.messaging.broker.core.BrokerAuthException;
import io.ballerina.messaging.broker.core.BrokerAuthNotFoundException;
import io.ballerina.messaging.broker.core.BrokerException;
import io.ballerina.messaging.broker.core.BrokerFactory;
import io.ballerina.messaging.broker.core.QueueHandler;
import io.ballerina.messaging.broker.core.rest.model.ActionUserGroupsMapping;
import io.ballerina.messaging.broker.core.rest.model.MessageDeleteResponse;
import io.ballerina.messaging.broker.core.rest.model.QueueCreateRequest;
import io.ballerina.messaging.broker.core.rest.model.QueueCreateResponse;
import io.ballerina.messaging.broker.core.rest.model.QueueMetadata;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.security.auth.Subject;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueuesApiDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueuesApiDelegate.class);
    public static final String QUEUES_API_PATH = "/queues";
    private final BrokerFactory brokerFactory;
    private final Authorizer authorizer;

    public QueuesApiDelegate(BrokerFactory brokerFactory, Authorizer authorizer) {
        this.brokerFactory = brokerFactory;
        this.authorizer = authorizer;
    }

    public Response createQueue(QueueCreateRequest requestBody, Subject subject) {
        try {
            if (this.brokerFactory.getBroker(subject).createQueue(requestBody.getName(), false, requestBody.isDurable(), requestBody.isAutoDelete())) {
                QueueCreateResponse message = new QueueCreateResponse().message("Queue created.");
                return Response.created((URI)new URI("/broker/v1.0/queues/" + requestBody.getName())).entity((Object)message).build();
            }
            throw new BadRequestException("Queue already exists.");
        }
        catch (ValidationException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
        catch (BrokerAuthException e) {
            throw new NotAuthorizedException(e.getMessage(), (Object)e, new Object[0]);
        }
        catch (BrokerException | URISyntaxException e) {
            LOGGER.error("Error occurred while creating the queue.", (Throwable)e);
            throw new InternalServerErrorException(e.getMessage(), (Throwable)e);
        }
    }

    public Response deleteQueue(String queueName, Boolean ifUnused, Boolean ifEmpty, Subject subject) {
        if (Objects.isNull(ifUnused)) {
            ifUnused = true;
        }
        if (Objects.isNull(ifEmpty)) {
            ifEmpty = true;
        }
        try {
            int numberOfMessagesDeleted = this.brokerFactory.getBroker(subject).deleteQueue(queueName, ifUnused, ifEmpty);
            return Response.ok().entity((Object)new MessageDeleteResponse().numberOfMessagesDeleted(numberOfMessagesDeleted)).build();
        }
        catch (ValidationException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
        catch (BrokerAuthException e) {
            throw new NotAuthorizedException(e.getMessage(), (Object)e, new Object[0]);
        }
        catch (ResourceNotFoundException | BrokerAuthNotFoundException e) {
            throw new NotFoundException("Queue " + queueName + " doesn't exist.", e);
        }
        catch (BrokerException e) {
            throw new InternalServerErrorException(e.getMessage(), (Throwable)e);
        }
    }

    public Response getQueue(String queueName, Subject subject) {
        QueueMetadata queueMetadata;
        try {
            QueueHandler queueHandler = this.brokerFactory.getBroker(subject).getQueue(queueName);
            queueMetadata = this.toQueueMetadata(queueHandler);
        }
        catch (BrokerAuthException e) {
            throw new NotAuthorizedException(e.getMessage(), (Object)e, new Object[0]);
        }
        catch (ResourceNotFoundException | BrokerAuthNotFoundException e) {
            throw new NotFoundException("Queue " + queueName + " not found");
        }
        catch (BrokerException e) {
            throw new InternalServerErrorException(e.getMessage(), (Throwable)e);
        }
        return Response.ok().entity((Object)queueMetadata).build();
    }

    public Response getAllQueues(Boolean durable, Subject subject) {
        ArrayList<QueueMetadata> queueArray;
        boolean filterByDurability = Objects.nonNull(durable);
        try {
            Collection<QueueHandler> queueHandlers = this.brokerFactory.getBroker(subject).getAllQueues();
            queueArray = new ArrayList<QueueMetadata>(queueHandlers.size());
            for (QueueHandler handler : queueHandlers) {
                if (filterByDurability && durable.booleanValue() != handler.getUnmodifiableQueue().isDurable()) continue;
                queueArray.add(this.toQueueMetadata(handler));
            }
        }
        catch (BrokerAuthException e) {
            throw new NotAuthorizedException(e.getMessage(), (Object)e, new Object[0]);
        }
        catch (BrokerException e) {
            throw new InternalServerErrorException(e.getMessage(), (Throwable)e);
        }
        return Response.ok().entity(queueArray).build();
    }

    private QueueMetadata toQueueMetadata(QueueHandler queueHandler) throws BrokerException {
        QueueMetadata queueMetadata = new QueueMetadata();
        queueMetadata.name(queueHandler.getUnmodifiableQueue().getName()).durable(queueHandler.getUnmodifiableQueue().isDurable()).autoDelete(queueHandler.getUnmodifiableQueue().isAutoDelete()).capacity(queueHandler.getUnmodifiableQueue().capacity()).consumerCount(queueHandler.consumerCount()).size(queueHandler.size());
        try {
            AuthResource authResource = this.authorizer.getAuthResource(ResourceType.QUEUE.toString(), queueHandler.getUnmodifiableQueue().getName());
            if (Objects.nonNull(authResource)) {
                queueMetadata.owner(authResource.getOwner()).permissions(this.toActionUserGroupsMapping(authResource.getActionsUserGroupsMap()));
            }
        }
        catch (AuthNotFoundException | AuthServerException e) {
            throw new BrokerException("Error while querying auth resource", e);
        }
        return queueMetadata;
    }

    private ArrayList<ActionUserGroupsMapping> toActionUserGroupsMapping(Map<String, Set<String>> actionsUserGroupsMap) {
        ArrayList<ActionUserGroupsMapping> actionUserGroupsMappings = new ArrayList<ActionUserGroupsMapping>(actionsUserGroupsMap.size());
        actionsUserGroupsMap.forEach((action, userGroups) -> {
            ActionUserGroupsMapping actionUserGroupsMapping = new ActionUserGroupsMapping();
            actionUserGroupsMapping.setAction((String)action);
            actionUserGroupsMapping.setUserGroups(new ArrayList<String>((Collection<String>)userGroups));
            actionUserGroupsMappings.add(actionUserGroupsMapping);
        });
        return actionUserGroupsMappings;
    }

    public Response purgeQueue(String queueName, Subject subject) {
        try {
            int numberOfMessagesDeleted = this.brokerFactory.getBroker(subject).purgeQueue(queueName);
            return Response.ok().entity((Object)new MessageDeleteResponse().numberOfMessagesDeleted(numberOfMessagesDeleted)).build();
        }
        catch (ValidationException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
        catch (ResourceNotFoundException e) {
            throw new NotFoundException("Queue " + queueName + " doesn't exist.", (Throwable)e);
        }
    }
}

