/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.rest.api;

import io.ballerina.messaging.broker.auth.authorization.Authorizer;
import io.ballerina.messaging.broker.auth.authorization.enums.ResourceAction;
import io.ballerina.messaging.broker.auth.authorization.enums.ResourceType;
import io.ballerina.messaging.broker.core.BrokerFactory;
import io.ballerina.messaging.broker.core.rest.AuthGrantApiDelegate;
import io.ballerina.messaging.broker.core.rest.BindingsApiDelegate;
import io.ballerina.messaging.broker.core.rest.ConsumersApiDelegate;
import io.ballerina.messaging.broker.core.rest.QueuesApiDelegate;
import io.ballerina.messaging.broker.core.rest.model.BindingCreateRequest;
import io.ballerina.messaging.broker.core.rest.model.BindingCreateResponse;
import io.ballerina.messaging.broker.core.rest.model.BindingInfo;
import io.ballerina.messaging.broker.core.rest.model.ChangeOwnerRequest;
import io.ballerina.messaging.broker.core.rest.model.ConsumerMetadata;
import io.ballerina.messaging.broker.core.rest.model.Error;
import io.ballerina.messaging.broker.core.rest.model.MessageDeleteResponse;
import io.ballerina.messaging.broker.core.rest.model.QueueCreateRequest;
import io.ballerina.messaging.broker.core.rest.model.QueueCreateResponse;
import io.ballerina.messaging.broker.core.rest.model.QueueMetadata;
import io.ballerina.messaging.broker.core.rest.model.ResponseMessage;
import io.ballerina.messaging.broker.core.rest.model.UserGroupList;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.security.auth.Subject;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.wso2.msf4j.Request;

@Path(value="/broker/v1.0/queues")
@Api(description="the queues API")
@Produces(value={"application/json"})
public class QueuesApi {
    private final QueuesApiDelegate queuesApiDelegate;
    private final ConsumersApiDelegate consumersApiDelegate;
    private final BindingsApiDelegate bindingsApiDelegate;
    private final AuthGrantApiDelegate authGrantApiDelegate;

    public QueuesApi(BrokerFactory brokerFactory, Authorizer dacHandler) {
        this.queuesApiDelegate = new QueuesApiDelegate(brokerFactory, dacHandler);
        this.authGrantApiDelegate = new AuthGrantApiDelegate(dacHandler);
        this.consumersApiDelegate = new ConsumersApiDelegate(brokerFactory);
        this.bindingsApiDelegate = new BindingsApiDelegate(brokerFactory);
    }

    @POST
    @Path(value="/{name}/permissions/actions/{action}/groups")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add new user group(s) for a particular action on the queue.", notes="Grant queue permission for new user group(s).", response=ResponseMessage.class, authorizations={@Authorization(value="basicAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="User groups added.", response=ResponseMessage.class), @ApiResponse(code=400, message="Bad Request. Invalid request or validation error.", response=Error.class), @ApiResponse(code=401, message="Authentication Data is missing or invalid", response=Error.class), @ApiResponse(code=403, message="Requested action unauthorized.", response=Error.class), @ApiResponse(code=409, message="Duplicate resource", response=Error.class), @ApiResponse(code=415, message="Unsupported media type. The entity of the request was in a not supported format.", response=Error.class)})
    public Response addQueueActionUserGroups(@Context Request request, @PathParam(value="name") @ApiParam(value="Name of the queue.") String name, @PathParam(value="action") @ApiParam(value="Name of the action.") String action, @Valid UserGroupList body) {
        try {
            return this.authGrantApiDelegate.addUserGroupsToAction(ResourceType.QUEUE, name, ResourceAction.getResourceAction((String)action), body, (Subject)request.getSession().getAttribute("AuthenticationId"));
        }
        catch (Exception e) {
            throw new InternalServerErrorException(e.getMessage(), (Throwable)e);
        }
    }

    @PUT
    @Path(value="/{name}/permissions/owner/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Change the owner of the queue", notes="", response=ResponseMessage.class, authorizations={@Authorization(value="basicAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=204, message="Queue owner updated."), @ApiResponse(code=400, message="Bad Request. Invalid request or validation error.", response=Error.class), @ApiResponse(code=401, message="Authentication Data is missing or invalid", response=Error.class), @ApiResponse(code=403, message="Requested action unauthorized.", response=Error.class), @ApiResponse(code=409, message="Duplicate resource", response=Error.class), @ApiResponse(code=415, message="Unsupported media type. The entity of the request was in a not supported format.", response=Error.class)})
    public Response changeQueueOwner(@Context Request request, @PathParam(value="name") @ApiParam(value="Name of the queue") String name, @Valid ChangeOwnerRequest changeOwnerRequest) {
        return this.authGrantApiDelegate.changeOwner(ResourceType.QUEUE, name, changeOwnerRequest.getOwner(), (Subject)request.getSession().getAttribute("AuthenticationId"));
    }

    @POST
    @Path(value="/{name}/bindings")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a binding", notes="Create a binding for a queue", response=BindingCreateResponse.class, authorizations={@Authorization(value="basicAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=201, message="Binding created", response=BindingCreateResponse.class), @ApiResponse(code=400, message="Bad Request. Invalid request or validation error.", response=Error.class), @ApiResponse(code=401, message="Authentication information is missing or invalid", response=Error.class), @ApiResponse(code=404, message="Exchange not found", response=Error.class), @ApiResponse(code=415, message="Unsupported media type. The entity of the request was in a not supported format.", response=Error.class)})
    public Response createBinding(@Context Request request, @PathParam(value="name") @ApiParam(value="Name of the queue to bind to") String name, @Valid BindingCreateRequest body) {
        return this.bindingsApiDelegate.createBinding(name, body, (Subject)request.getSession().getAttribute("AuthenticationId"));
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Creates a queue", notes="", response=QueueCreateResponse.class, authorizations={@Authorization(value="basicAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=201, message="Queue created.", response=QueueCreateResponse.class), @ApiResponse(code=400, message="Bad Request. Invalid request or validation error.", response=Error.class), @ApiResponse(code=401, message="Authentication information is missing or invalid", response=Error.class), @ApiResponse(code=415, message="Unsupported media type. The entity of the request was in a not supported format.", response=Error.class)})
    public Response createQueue(@Context Request request, @Valid QueueCreateRequest body) {
        return this.queuesApiDelegate.createQueue(body, (Subject)request.getSession().getAttribute("AuthenticationId"));
    }

    @DELETE
    @Path(value="/{name}/bindings/{bindingPattern}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Unbind a queue", notes="Delete a specific binding", response=Void.class, authorizations={@Authorization(value="basicAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Binding deleted", response=Void.class), @ApiResponse(code=400, message="Bad request. Invalid request or validation error.", response=Error.class), @ApiResponse(code=401, message="Authentication information is missing or invalid", response=Error.class), @ApiResponse(code=404, message="Binding not found", response=Error.class)})
    public Response deleteBinding(@Context Request request, @PathParam(value="name") @ApiParam(value="Name of the queue") String name, @PathParam(value="bindingPattern") @ApiParam(value="Binding pattern for the bindings") String bindingPattern, @QueryParam(value="filterExpression") @ApiParam(value="JMS selector relater message filter pattern") String filterExpression) {
        return this.bindingsApiDelegate.deleteBinding(name, bindingPattern, filterExpression, (Subject)request.getSession().getAttribute("AuthenticationId"));
    }

    @DELETE
    @Path(value="/{name}/consumers/{consumerId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="delete a consumer", notes="Delete a specific consumer from a queue", response=Void.class, authorizations={@Authorization(value="basicAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Consumer deleted", response=Void.class), @ApiResponse(code=401, message="Authentication information is missing or invalid", response=Error.class), @ApiResponse(code=404, message="Queue/Consumer not found", response=Error.class)})
    public Response deleteConsumer(@Context Request request, @PathParam(value="name") @ApiParam(value="Name of the queue") String name, @PathParam(value="consumerId") @ApiParam(value="Unique consumer identifier") Integer consumerId) {
        return this.consumersApiDelegate.deleteConsumer(name, consumerId, (Subject)request.getSession().getAttribute("AuthenticationId"));
    }

    @DELETE
    @Path(value="/{name}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete the specified queue.", notes="Delete the specified queue if the queue exists in the broker and the query param properties ifUnused and ifEmpty are satisfied.", response=Void.class, authorizations={@Authorization(value="basicAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Queue deleted", response=MessageDeleteResponse.class), @ApiResponse(code=400, message="Bad request. Invalid request or validation error.", response=Error.class), @ApiResponse(code=401, message="Authentication information is missing or invalid", response=Error.class), @ApiResponse(code=404, message="Queue not found", response=Error.class)})
    public Response deleteQueue(@Context Request request, @PathParam(value="name") @ApiParam(value="Name of the queue") String name, @DefaultValue(value="true") @QueryParam(value="ifUnused") @ApiParam(value="If set to true, queue will be deleted only if the queue has no active consumers.") Boolean ifUnused, @DefaultValue(value="true") @QueryParam(value="ifEmpty") @ApiParam(value="If set to true, queue will be deleted only if the queue is empty.") Boolean ifEmpty) {
        return this.queuesApiDelegate.deleteQueue(name, ifUnused, ifEmpty, (Subject)request.getSession().getAttribute("AuthenticationId"));
    }

    @DELETE
    @Path(value="/{queueName}/permissions/actions/{action}/groups/{groupName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Remove permission to an action from a user group for a queue.", notes="Revoke permissions for a user group from invoking a particular action on a specific queue.", response=ResponseMessage.class, authorizations={@Authorization(value="basicAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="User group removed.", response=ResponseMessage.class), @ApiResponse(code=400, message="Bad Request. Invalid request or validation error.", response=Error.class), @ApiResponse(code=401, message="Authentication Data is missing or invalid", response=Error.class), @ApiResponse(code=403, message="Requested action unauthorized.", response=Error.class), @ApiResponse(code=409, message="Duplicate resource", response=Error.class), @ApiResponse(code=415, message="Unsupported media type. The entity of the request was in a not supported format.", response=Error.class)})
    public Response deleteUserGroup(@Context Request request, @PathParam(value="queueName") @ApiParam(value="Name of the queue.") String queueName, @PathParam(value="action") @ApiParam(value="Name of the action.") String action, @PathParam(value="groupName") @ApiParam(value="Name of the user group") String groupName) {
        try {
            return this.authGrantApiDelegate.removeUserGroup(ResourceType.QUEUE, queueName, ResourceAction.getResourceAction((String)action), groupName, (Subject)request.getSession().getAttribute("AuthenticationId"));
        }
        catch (Exception e) {
            throw new InternalServerErrorException(e.getMessage(), (Throwable)e);
        }
    }

    @GET
    @Path(value="/{name}/consumers")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all consumers of a queue", notes="Retrieves all the consumers for the queue", response=ConsumerMetadata.class, responseContainer="List", authorizations={@Authorization(value="basicAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Consumers of the queue", response=ConsumerMetadata.class, responseContainer="List"), @ApiResponse(code=401, message="Authentication information is missing or invalid", response=Error.class), @ApiResponse(code=404, message="Queue not found", response=Error.class)})
    public Response getAllConsumersForQueue(@Context Request request, @PathParam(value="name") @ApiParam(value="Name of the queue") String name) {
        return this.consumersApiDelegate.getAllConsumers(name, (Subject)request.getSession().getAttribute("AuthenticationId"));
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all queues", notes="Gets metadata of all the queues in the broker. This includes durable and non durable queues. ", response=QueueMetadata.class, responseContainer="List", authorizations={@Authorization(value="basicAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="List of queues", response=QueueMetadata.class, responseContainer="List"), @ApiResponse(code=401, message="Authentication information is missing or invalid", response=Error.class)})
    public Response getAllQueues(@Context Request request, @QueryParam(value="durable") @ApiParam(value="filter queues by durability") Boolean durable) {
        return this.queuesApiDelegate.getAllQueues(durable, (Subject)request.getSession().getAttribute("AuthenticationId"));
    }

    @GET
    @Path(value="/{name}/bindings/{bindingPattern}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve bindings for a queue with specific binding pattern", notes="", response=BindingInfo.class, authorizations={@Authorization(value="basicAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Binding info", response=BindingInfo.class), @ApiResponse(code=401, message="Authentication information is missing or invalid", response=Error.class), @ApiResponse(code=404, message="Exchange not found", response=Error.class)})
    public Response getBinding(@Context Request request, @PathParam(value="name") @ApiParam(value="Name of the queue") String name, @PathParam(value="bindingPattern") @ApiParam(value="Binding pattern for the bindings") String bindingPattern, @QueryParam(value="filterExpression") @ApiParam(value="JMS selector relater message filter pattern") String filterExpression) {
        return this.bindingsApiDelegate.getBinding(name, bindingPattern, filterExpression, (Subject)request.getSession().getAttribute("AuthenticationId"));
    }

    @GET
    @Path(value="/{name}/consumers/{consumerId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a specific consumer", notes="Retrieves a specific consumer for a given queue", response=ConsumerMetadata.class, authorizations={@Authorization(value="basicAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Consumers of the queue", response=ConsumerMetadata.class), @ApiResponse(code=401, message="Authentication information is missing or invalid", response=Error.class), @ApiResponse(code=404, message="Queue/Consumer not found", response=Error.class)})
    public Response getConsumer(@Context Request request, @PathParam(value="name") @ApiParam(value="Name of the queue") String name, @PathParam(value="consumerId") @ApiParam(value="Unique consumer identifier") Integer consumerId) {
        return this.consumersApiDelegate.getConsumer(name, consumerId, (Subject)request.getSession().getAttribute("AuthenticationId"));
    }

    @GET
    @Path(value="/{name}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a specific queue", notes="Gets metadata of the specified queue.", response=QueueMetadata.class, authorizations={@Authorization(value="basicAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Metadata of the queue", response=QueueMetadata.class), @ApiResponse(code=401, message="Authentication information is missing or invalid", response=Error.class), @ApiResponse(code=404, message="Queue not found", response=Error.class)})
    public Response getQueue(@Context Request request, @PathParam(value="name") @ApiParam(value="Name of the queue") String name) {
        return this.queuesApiDelegate.getQueue(name, (Subject)request.getSession().getAttribute("AuthenticationId"));
    }

    @DELETE
    @Path(value="/{name}/messages")
    @Produces(value={"application/json"})
    @ApiOperation(value="purge messages", notes="Purge all messages in the queue", response=Void.class, authorizations={@Authorization(value="basicAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Queue purged", response=MessageDeleteResponse.class), @ApiResponse(code=401, message="Authentication information is missing or invalid", response=Error.class), @ApiResponse(code=404, message="Queue/Consumer not found", response=Error.class)})
    public Response purgeMessages(@Context Request request, @PathParam(value="name") @ApiParam(value="Name of the queue") String name) {
        return this.queuesApiDelegate.purgeQueue(name, (Subject)request.getSession().getAttribute("AuthenticationId"));
    }
}

