/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.rest.api;

import io.ballerina.messaging.broker.core.rest.model.Error;
import io.ballerina.messaging.broker.core.rest.model.Scope;
import io.ballerina.messaging.broker.core.rest.model.ScopeUpdateRequest;
import io.ballerina.messaging.broker.core.rest.model.ScopeUpdateResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.wso2.msf4j.Request;

@Path(value="/broker/v1.0/scopes")
@Api(description="the scopes API")
@Produces(value={"application/json"})
public class ScopesApi {
    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all scopes", notes="Retrieves all the scopes", response=Scope.class, responseContainer="List", authorizations={@Authorization(value="basicAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="List of Scopes", response=Scope.class, responseContainer="List"), @ApiResponse(code=401, message="Authentication Data is missing or invalid", response=Error.class)})
    public Response getAllScopes(@Context Request request) {
        return Response.ok().entity((Object)"magic!").build();
    }

    @GET
    @Path(value="/{name}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a scope", notes="Retrieves scope for given scope name", response=Scope.class, authorizations={@Authorization(value="basicAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Scope", response=Scope.class), @ApiResponse(code=401, message="Authentication Data is missing or invalid", response=Error.class), @ApiResponse(code=404, message="Scope not found", response=Error.class)})
    public Response getScope(@Context Request request, @PathParam(value="name") @ApiParam(value="Name of the scope") String name) {
        return Response.ok().entity((Object)"magic!").build();
    }

    @PUT
    @Path(value="/{name}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update a scope", notes="Update given scope", response=ScopeUpdateResponse.class, authorizations={@Authorization(value="basicAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Scope updated", response=ScopeUpdateResponse.class), @ApiResponse(code=400, message="Bad Request. Invalid request or validation error.", response=Error.class), @ApiResponse(code=401, message="Authentication Data is missing or invalid", response=Error.class), @ApiResponse(code=404, message="Scope key not found", response=Error.class), @ApiResponse(code=415, message="Unsupported media type. The entity of the request was in a not supported format.", response=Error.class)})
    public Response updateScope(@Context Request request, @PathParam(value="name") @ApiParam(value="Name of the scope needs to update") String name, @Valid ScopeUpdateRequest body) {
        return Response.ok().entity((Object)"magic!").build();
    }
}

