/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.rest.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

public class ConsumerMetadata {
    @Valid
    private Integer id = null;
    @Valid
    private String consumerTag = null;
    @Valid
    private Boolean isExclusive = null;
    @Valid
    private Boolean flowEnabled = null;
    @Valid
    private Object transportProperties = null;

    public ConsumerMetadata id(Integer id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="unique id of the consumer")
    @JsonProperty(value="id")
    @NotNull
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public ConsumerMetadata consumerTag(String consumerTag) {
        this.consumerTag = consumerTag;
        return this;
    }

    @ApiModelProperty(required=true, value="identifier given by the channel")
    @JsonProperty(value="consumerTag")
    @NotNull
    public String getConsumerTag() {
        return this.consumerTag;
    }

    public void setConsumerTag(String consumerTag) {
        this.consumerTag = consumerTag;
    }

    public ConsumerMetadata isExclusive(Boolean isExclusive) {
        this.isExclusive = isExclusive;
        return this;
    }

    @ApiModelProperty(required=true, value="State whether only this consumer can consume from the queue.")
    @JsonProperty(value="isExclusive")
    @NotNull
    public Boolean isIsExclusive() {
        return this.isExclusive;
    }

    public void setIsExclusive(Boolean isExclusive) {
        this.isExclusive = isExclusive;
    }

    public ConsumerMetadata flowEnabled(Boolean flowEnabled) {
        this.flowEnabled = flowEnabled;
        return this;
    }

    @ApiModelProperty(required=true, value="State whether the consumers is actively consuming messages")
    @JsonProperty(value="flowEnabled")
    @NotNull
    public Boolean isFlowEnabled() {
        return this.flowEnabled;
    }

    public void setFlowEnabled(Boolean flowEnabled) {
        this.flowEnabled = flowEnabled;
    }

    public ConsumerMetadata transportProperties(Object transportProperties) {
        this.transportProperties = transportProperties;
        return this;
    }

    @ApiModelProperty(value="Properties inherited by the underlying transport.")
    @JsonProperty(value="transportProperties")
    public Object getTransportProperties() {
        return this.transportProperties;
    }

    public void setTransportProperties(Object transportProperties) {
        this.transportProperties = transportProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsumerMetadata consumerMetadata = (ConsumerMetadata)o;
        return Objects.equals(this.id, consumerMetadata.id) && Objects.equals(this.consumerTag, consumerMetadata.consumerTag) && Objects.equals(this.isExclusive, consumerMetadata.isExclusive) && Objects.equals(this.flowEnabled, consumerMetadata.flowEnabled) && Objects.equals(this.transportProperties, consumerMetadata.transportProperties);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.consumerTag, this.isExclusive, this.flowEnabled, this.transportProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConsumerMetadata {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    consumerTag: ").append(this.toIndentedString(this.consumerTag)).append("\n");
        sb.append("    isExclusive: ").append(this.toIndentedString(this.isExclusive)).append("\n");
        sb.append("    flowEnabled: ").append(this.toIndentedString(this.flowEnabled)).append("\n");
        sb.append("    transportProperties: ").append(this.toIndentedString(this.transportProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

