/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.rest.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

public class ExchangeCreateRequest {
    @Valid
    private String name = null;
    @Valid
    private String type = null;
    @Valid
    private Boolean durable = null;

    public ExchangeCreateRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the exchange. This should be a unique value")
    @JsonProperty(value="name")
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ExchangeCreateRequest type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="Type of exchange")
    @JsonProperty(value="type")
    @NotNull
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ExchangeCreateRequest durable(Boolean durable) {
        this.durable = durable;
        return this;
    }

    @ApiModelProperty(required=true, value="States whether the exchange is durable or not")
    @JsonProperty(value="durable")
    @NotNull
    public Boolean isDurable() {
        return this.durable;
    }

    public void setDurable(Boolean durable) {
        this.durable = durable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExchangeCreateRequest exchangeCreateRequest = (ExchangeCreateRequest)o;
        return Objects.equals(this.name, exchangeCreateRequest.name) && Objects.equals(this.type, exchangeCreateRequest.type) && Objects.equals(this.durable, exchangeCreateRequest.durable);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.durable);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExchangeCreateRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    durable: ").append(this.toIndentedString(this.durable)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

