/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.rest.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.ballerina.messaging.broker.core.rest.model.ActionUserGroupsMapping;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;

public class ExchangeMetadata {
    @Valid
    private String name = null;
    @Valid
    private String type = null;
    @Valid
    private Boolean durable = null;
    @Valid
    private String owner = null;
    @Valid
    private List<ActionUserGroupsMapping> permissions = new ArrayList<ActionUserGroupsMapping>();

    public ExchangeMetadata name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Name of the exchange")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ExchangeMetadata type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="Type of exchange.  for instance amq.direct, amq.topic")
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ExchangeMetadata durable(Boolean durable) {
        this.durable = durable;
        return this;
    }

    @ApiModelProperty(value="True if the exchange is durable and false otherwise")
    @JsonProperty(value="durable")
    public Boolean isDurable() {
        return this.durable;
    }

    public void setDurable(Boolean durable) {
        this.durable = durable;
    }

    public ExchangeMetadata owner(String owner) {
        this.owner = owner;
        return this;
    }

    @ApiModelProperty(value="Queue owner")
    @JsonProperty(value="owner")
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public ExchangeMetadata permissions(List<ActionUserGroupsMapping> permissions) {
        this.permissions = permissions;
        return this;
    }

    @ApiModelProperty(value="Queue action User groups permissions")
    @JsonProperty(value="permissions")
    public List<ActionUserGroupsMapping> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<ActionUserGroupsMapping> permissions) {
        this.permissions = permissions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExchangeMetadata exchangeMetadata = (ExchangeMetadata)o;
        return Objects.equals(this.name, exchangeMetadata.name) && Objects.equals(this.type, exchangeMetadata.type) && Objects.equals(this.durable, exchangeMetadata.durable) && Objects.equals(this.owner, exchangeMetadata.owner) && Objects.equals(this.permissions, exchangeMetadata.permissions);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.durable, this.owner, this.permissions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExchangeMetadata {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    durable: ").append(this.toIndentedString(this.durable)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

