/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.rest.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.ballerina.messaging.broker.core.rest.model.ActionUserGroupsMapping;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;

public class ExchangeUpdateRequest {
    @Valid
    private String owner = null;
    @Valid
    private List<ActionUserGroupsMapping> authorizedUserGroups = new ArrayList<ActionUserGroupsMapping>();

    public ExchangeUpdateRequest owner(String owner) {
        this.owner = owner;
        return this;
    }

    @ApiModelProperty(value="Owner of exchange")
    @JsonProperty(value="owner")
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public ExchangeUpdateRequest authorizedUserGroups(List<ActionUserGroupsMapping> authorizedUserGroups) {
        this.authorizedUserGroups = authorizedUserGroups;
        return this;
    }

    @ApiModelProperty(value="Exchange action User groups mappings")
    @JsonProperty(value="authorizedUserGroups")
    public List<ActionUserGroupsMapping> getAuthorizedUserGroups() {
        return this.authorizedUserGroups;
    }

    public void setAuthorizedUserGroups(List<ActionUserGroupsMapping> authorizedUserGroups) {
        this.authorizedUserGroups = authorizedUserGroups;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExchangeUpdateRequest exchangeUpdateRequest = (ExchangeUpdateRequest)o;
        return Objects.equals(this.owner, exchangeUpdateRequest.owner) && Objects.equals(this.authorizedUserGroups, exchangeUpdateRequest.authorizedUserGroups);
    }

    public int hashCode() {
        return Objects.hash(this.owner, this.authorizedUserGroups);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExchangeUpdateRequest {\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    authorizedUserGroups: ").append(this.toIndentedString(this.authorizedUserGroups)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

