/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.rest.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.ballerina.messaging.broker.core.rest.model.ActionUserGroupsMapping;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

public class QueueMetadata {
    @Valid
    private String name = null;
    @Valid
    private Integer consumerCount = null;
    @Valid
    private Boolean durable = null;
    @Valid
    private Integer capacity = null;
    @Valid
    private Integer size = null;
    @Valid
    private Boolean autoDelete = null;
    @Valid
    private String owner = null;
    @Valid
    private List<ActionUserGroupsMapping> permissions = new ArrayList<ActionUserGroupsMapping>();

    public QueueMetadata name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the queue. This is a unique value")
    @JsonProperty(value="name")
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public QueueMetadata consumerCount(Integer consumerCount) {
        this.consumerCount = consumerCount;
        return this;
    }

    @ApiModelProperty(required=true, value="number of active consumers assigned to the queue. Messages will be dispatched in a round robing manner to the consumers.")
    @JsonProperty(value="consumerCount")
    @NotNull
    public Integer getConsumerCount() {
        return this.consumerCount;
    }

    public void setConsumerCount(Integer consumerCount) {
        this.consumerCount = consumerCount;
    }

    public QueueMetadata durable(Boolean durable) {
        this.durable = durable;
        return this;
    }

    @ApiModelProperty(required=true, value="durability of the queue. True if the queue is durable and false otherwise. Durable queues will survive node failures.")
    @JsonProperty(value="durable")
    @NotNull
    public Boolean isDurable() {
        return this.durable;
    }

    public void setDurable(Boolean durable) {
        this.durable = durable;
    }

    public QueueMetadata capacity(Integer capacity) {
        this.capacity = capacity;
        return this;
    }

    @ApiModelProperty(required=true, value="Maximum number of messages the queue can hold. Durable queues are unbounded and will specify the integer max value (2,147,483,647) as the capacity.")
    @JsonProperty(value="capacity")
    @NotNull
    public Integer getCapacity() {
        return this.capacity;
    }

    public void setCapacity(Integer capacity) {
        this.capacity = capacity;
    }

    public QueueMetadata size(Integer size) {
        this.size = size;
        return this;
    }

    @ApiModelProperty(required=true, value="Number of messages in the queue.")
    @JsonProperty(value="size")
    @NotNull
    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public QueueMetadata autoDelete(Boolean autoDelete) {
        this.autoDelete = autoDelete;
        return this;
    }

    @ApiModelProperty(required=true, value="If set to true queue will get deleted once all the consumers of the queue get disconnected.")
    @JsonProperty(value="autoDelete")
    @NotNull
    public Boolean isAutoDelete() {
        return this.autoDelete;
    }

    public void setAutoDelete(Boolean autoDelete) {
        this.autoDelete = autoDelete;
    }

    public QueueMetadata owner(String owner) {
        this.owner = owner;
        return this;
    }

    @ApiModelProperty(value="Queue owner")
    @JsonProperty(value="owner")
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public QueueMetadata permissions(List<ActionUserGroupsMapping> permissions) {
        this.permissions = permissions;
        return this;
    }

    @ApiModelProperty(value="Queue action User groups permissions")
    @JsonProperty(value="permissions")
    public List<ActionUserGroupsMapping> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<ActionUserGroupsMapping> permissions) {
        this.permissions = permissions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueueMetadata queueMetadata = (QueueMetadata)o;
        return Objects.equals(this.name, queueMetadata.name) && Objects.equals(this.consumerCount, queueMetadata.consumerCount) && Objects.equals(this.durable, queueMetadata.durable) && Objects.equals(this.capacity, queueMetadata.capacity) && Objects.equals(this.size, queueMetadata.size) && Objects.equals(this.autoDelete, queueMetadata.autoDelete) && Objects.equals(this.owner, queueMetadata.owner) && Objects.equals(this.permissions, queueMetadata.permissions);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.consumerCount, this.durable, this.capacity, this.size, this.autoDelete, this.owner, this.permissions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QueueMetadata {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    consumerCount: ").append(this.toIndentedString(this.consumerCount)).append("\n");
        sb.append("    durable: ").append(this.toIndentedString(this.durable)).append("\n");
        sb.append("    capacity: ").append(this.toIndentedString(this.capacity)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    autoDelete: ").append(this.toIndentedString(this.autoDelete)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

