/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.selector;

import io.ballerina.messaging.broker.core.selector.Expression;
import java.math.BigDecimal;

public class ConstantExpression
implements Expression<Object> {
    private final Object value;

    public ConstantExpression(Object value) {
        this.value = value;
    }

    @Override
    public Object evaluate(Object object) {
        return this.value;
    }

    public static ConstantExpression createFromNumericInteger(String text) {
        Number value;
        if (text.endsWith("l") || text.endsWith("L")) {
            text = text.substring(0, text.length() - 1);
        }
        try {
            value = Long.valueOf(text);
        }
        catch (NumberFormatException e) {
            value = new BigDecimal(text);
        }
        if (value.intValue() < Integer.MAX_VALUE && value.intValue() > Integer.MIN_VALUE) {
            value = value.intValue();
        }
        return new ConstantExpression(value);
    }
}

