/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.selector;

import io.ballerina.messaging.broker.core.Metadata;
import io.ballerina.messaging.broker.core.selector.BooleanExpression;
import io.ballerina.messaging.broker.core.selector.Expression;

public class EqualityExpression
implements BooleanExpression {
    private final Expression<Metadata> left;
    private final Expression<Metadata> right;

    public EqualityExpression(Expression<Metadata> left, Expression<Metadata> right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public boolean evaluate(Metadata metadata) {
        Object leftValue = this.left.evaluate(metadata);
        Object rightValue = this.right.evaluate(metadata);
        if (leftValue == null || rightValue == null) {
            return false;
        }
        return rightValue == leftValue || leftValue.equals(rightValue);
    }
}

