/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.selector;

import io.ballerina.messaging.broker.common.data.types.FieldValue;
import io.ballerina.messaging.broker.common.data.types.LongInt;
import io.ballerina.messaging.broker.common.data.types.LongLongInt;
import io.ballerina.messaging.broker.common.data.types.ShortShortInt;
import io.ballerina.messaging.broker.common.data.types.ShortString;
import io.ballerina.messaging.broker.core.Metadata;
import io.ballerina.messaging.broker.core.selector.Expression;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsPropertyExpression
implements Expression<Metadata> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsPropertyExpression.class);
    private static final Map<String, Expression<Metadata>> JMS_PROPERTY_EXPRESSIONS = new HashMap<String, Expression<Metadata>>();
    private final String name;
    private final Expression<Metadata> jmsPropertyExpression;

    public JmsPropertyExpression(String name) {
        this.name = name;
        this.jmsPropertyExpression = JMS_PROPERTY_EXPRESSIONS.get(name);
    }

    static Object getValue(FieldValue value) {
        if (value != null) {
            switch (value.getType()) {
                case SHORT_SHORT_INT: {
                    return ((ShortShortInt)value.getValue()).getByte();
                }
                case SHORT_STRING: 
                case LONG_STRING: {
                    return value.getValue().toString();
                }
                case LONG_INT: {
                    return ((LongInt)value.getValue()).getInt();
                }
                case LONG_LONG_INT: {
                    return ((LongLongInt)value.getValue()).getLong();
                }
            }
            return null;
        }
        return null;
    }

    @Override
    public Object evaluate(Metadata metadata) {
        if (this.jmsPropertyExpression != null) {
            return this.jmsPropertyExpression.evaluate(metadata);
        }
        FieldValue header = metadata.getHeader(ShortString.parseString((String)this.name));
        if (header == null) {
            return null;
        }
        switch (header.getType()) {
            case SHORT_STRING: 
            case LONG_STRING: {
                return header.getValue().toString();
            }
            case LONG_INT: {
                return ((LongInt)header.getValue()).getInt();
            }
        }
        return null;
    }

    static {
        JMS_PROPERTY_EXPRESSIONS.put("JMSDestination", metadata -> null);
        JMS_PROPERTY_EXPRESSIONS.put("JMSCorrelationID", metadata -> JmsPropertyExpression.getValue(metadata.getProperty(Metadata.CORRELATION_ID)));
        JMS_PROPERTY_EXPRESSIONS.put("JMSMessageID", metadata -> JmsPropertyExpression.getValue(metadata.getProperty(Metadata.MESSAGE_ID)));
    }
}

