/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.store;

import io.ballerina.messaging.broker.core.BrokerException;
import io.ballerina.messaging.broker.core.DbBackedQueueHandlerFactory;
import io.ballerina.messaging.broker.core.ExchangeRegistry;
import io.ballerina.messaging.broker.core.QueueRegistry;
import io.ballerina.messaging.broker.core.configuration.BrokerCoreConfiguration;
import io.ballerina.messaging.broker.core.metrics.BrokerMetricManager;
import io.ballerina.messaging.broker.core.store.DbMessageStore;
import io.ballerina.messaging.broker.core.store.MessageStore;
import io.ballerina.messaging.broker.core.store.StoreFactory;
import io.ballerina.messaging.broker.core.store.dao.impl.DaoFactory;
import javax.sql.DataSource;

public class DbBackedStoreFactory
implements StoreFactory {
    private final DaoFactory daoFactory;
    private final BrokerMetricManager metricManager;
    private final BrokerCoreConfiguration configuration;
    private DbMessageStore dbMessageStore;

    public DbBackedStoreFactory(DataSource dataSource, BrokerMetricManager metricManager, BrokerCoreConfiguration configuration) {
        this.daoFactory = new DaoFactory(dataSource, metricManager, configuration);
        this.metricManager = metricManager;
        this.configuration = configuration;
        int disruptorBufferSize = configuration.getDisruptorBufferSize();
        int maxDbBatchSize = configuration.getMaxDbWriteBatchSize();
        this.dbMessageStore = new DbMessageStore(this.daoFactory.createMessageDao(), disruptorBufferSize, maxDbBatchSize);
    }

    @Override
    public ExchangeRegistry getExchangeRegistry() {
        return new ExchangeRegistry(this.daoFactory.createExchangeDao(), this.daoFactory.createBindingDao());
    }

    @Override
    public MessageStore getMessageStore() {
        return this.dbMessageStore;
    }

    @Override
    public QueueRegistry getQueueRegistry() throws BrokerException {
        return new QueueRegistry(this.daoFactory.createQueueDao(), new DbBackedQueueHandlerFactory(this.dbMessageStore, this.metricManager, this.configuration));
    }
}

