/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.store;

import io.ballerina.messaging.broker.core.BrokerException;
import io.ballerina.messaging.broker.core.ExchangeRegistry;
import io.ballerina.messaging.broker.core.MemBackedQueueHandlerFactory;
import io.ballerina.messaging.broker.core.QueueRegistry;
import io.ballerina.messaging.broker.core.configuration.BrokerCoreConfiguration;
import io.ballerina.messaging.broker.core.metrics.BrokerMetricManager;
import io.ballerina.messaging.broker.core.store.MessageStore;
import io.ballerina.messaging.broker.core.store.NullMessageStore;
import io.ballerina.messaging.broker.core.store.StoreFactory;
import io.ballerina.messaging.broker.core.store.dao.impl.NullBindingDao;
import io.ballerina.messaging.broker.core.store.dao.impl.NullExchangeDao;
import io.ballerina.messaging.broker.core.store.dao.impl.NullQueueDao;

public class MemBackedStoreFactory
implements StoreFactory {
    private final BrokerMetricManager metricManager;
    private final BrokerCoreConfiguration configuration;
    private NullMessageStore messageStore = new NullMessageStore();

    public MemBackedStoreFactory(BrokerMetricManager metricManager, BrokerCoreConfiguration configuration) {
        this.metricManager = metricManager;
        this.configuration = configuration;
    }

    @Override
    public ExchangeRegistry getExchangeRegistry() {
        return new ExchangeRegistry(new NullExchangeDao(), new NullBindingDao());
    }

    @Override
    public MessageStore getMessageStore() {
        return this.messageStore;
    }

    @Override
    public QueueRegistry getQueueRegistry() throws BrokerException {
        return new QueueRegistry(new NullQueueDao(), new MemBackedQueueHandlerFactory(this.metricManager, this.configuration));
    }
}

