/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.store;

import io.ballerina.messaging.broker.core.BrokerException;
import io.ballerina.messaging.broker.core.DetachableMessage;
import io.ballerina.messaging.broker.core.Message;
import io.ballerina.messaging.broker.core.queue.QueueBuffer;
import io.ballerina.messaging.broker.core.store.TransactionData;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.transaction.xa.Xid;

public abstract class MessageStore {
    private final Map<Long, Message> pendingMessages = new ConcurrentHashMap<Long, Message>();
    private final Map<Xid, TransactionData> transactionMap = new ConcurrentHashMap<Xid, TransactionData>();

    public void add(Message message) {
        this.pendingMessages.put(message.getInternalId(), message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Xid xid, Message message) throws BrokerException {
        TransactionData transactionData;
        TransactionData transactionData2 = transactionData = this.getTransactionData(xid);
        synchronized (transactionData2) {
            transactionData.addEnqueueMessage(message);
        }
    }

    public void attach(String queueName, long messageInternalId) throws BrokerException {
        Message message = this.pendingMessages.get(messageInternalId);
        if (message == null) {
            throw new BrokerException("Unknown message id " + messageInternalId + " cannot attach to queue " + queueName);
        }
        message.addAttachedDurableQueue(queueName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(Xid xid, String queueName, long messageInternalId) throws BrokerException {
        TransactionData transactionData;
        TransactionData transactionData2 = transactionData = this.getTransactionData(xid);
        synchronized (transactionData2) {
            transactionData.attach(queueName, messageInternalId);
        }
    }

    private TransactionData getTransactionData(Xid xid) throws BrokerException {
        TransactionData transactionData = this.transactionMap.get(xid);
        if (Objects.isNull(transactionData)) {
            throw new BrokerException("Unknown Xid " + xid + ". Create a branch with Xid before attaching to a queue");
        }
        return transactionData;
    }

    public synchronized void detach(String queueName, DetachableMessage message) {
        message.removeAttachedDurableQueue(queueName);
        if (!message.hasAttachedDurableQueues()) {
            this.deleteMessage(message.getInternalId());
        } else {
            this.detachFromQueue(queueName, message.getInternalId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void detach(Xid xid, String queueName, DetachableMessage message) throws BrokerException {
        TransactionData transactionData;
        TransactionData transactionData2 = transactionData = this.getTransactionData(xid);
        synchronized (transactionData2) {
            transactionData.prepareForDetach(queueName, message);
        }
    }

    public void flush(long internalMessageId) {
        Message message = this.pendingMessages.remove(internalMessageId);
        if (message != null) {
            if (message.hasAttachedDurableQueues()) {
                this.publishMessageToStore(message);
            } else {
                message.release();
            }
        }
    }

    public void prepare(Xid xid) throws BrokerException {
        this.prepare(xid, this.getTransactionData(xid));
    }

    public void flush(Xid xid, boolean onePhase) throws BrokerException {
        TransactionData transactionData = this.getTransactionData(xid);
        this.updateDeletableMessages(transactionData);
        if (onePhase) {
            this.commit(transactionData);
        } else {
            this.commit(xid, transactionData);
        }
        this.clear(xid);
    }

    private void updateDeletableMessages(TransactionData transactionData) {
        Map<String, List<DetachableMessage>> preparedDetachEventMap = transactionData.getPreparedDetachEventMap();
        for (Map.Entry<String, List<DetachableMessage>> entry : preparedDetachEventMap.entrySet()) {
            String queueName = entry.getKey();
            for (DetachableMessage message : entry.getValue()) {
                message.removeAttachedDurableQueue(queueName);
                if (message.hasAttachedDurableQueues()) continue;
                transactionData.addDeletableMessage(message.getInternalId());
            }
        }
    }

    public void remove(Xid xid) throws BrokerException {
        this.rollback(xid);
        this.clear(xid);
    }

    public void branch(Xid xid) {
        this.transactionMap.putIfAbsent(xid, new TransactionData());
    }

    public void clear(Xid xid) {
        TransactionData transactionData = this.transactionMap.remove(xid);
        if (Objects.nonNull(transactionData)) {
            transactionData.releaseEnqueueMessages();
            transactionData.clear();
        }
    }

    abstract void publishMessageToStore(Message var1);

    abstract void detachFromQueue(String var1, long var2);

    abstract void deleteMessage(long var1);

    abstract void commit(TransactionData var1) throws BrokerException;

    abstract void commit(Xid var1, TransactionData var2) throws BrokerException;

    public abstract void rollback(Xid var1) throws BrokerException;

    public abstract void fillMessageData(QueueBuffer var1, Message var2);

    public abstract Collection<Message> readAllMessagesForQueue(String var1) throws BrokerException;

    public abstract void prepare(Xid var1, TransactionData var2) throws BrokerException;

    public abstract void retrieveStoredXids(Consumer<Xid> var1) throws BrokerException;

    public abstract Collection<Message> recoverEnqueuedMessages(Xid var1) throws BrokerException;
}

