/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.store;

import io.ballerina.messaging.broker.core.DetachableMessage;
import io.ballerina.messaging.broker.core.Message;
import io.ballerina.messaging.broker.core.store.QueueDetachEventList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class TransactionData {
    private final Map<Long, Message> enqueueMessages = new HashMap<Long, Message>();
    private final Map<String, QueueDetachEventList> detachMessageMap = new HashMap<String, QueueDetachEventList>();
    private final Map<String, List<DetachableMessage>> preparedDetachEventMap;
    private final List<Long> deleteMessageIdList = new ArrayList<Long>();
    private int detachOperationsCount = 0;
    private int preparedDetachEventCount;

    TransactionData() {
        this.preparedDetachEventMap = new HashMap<String, List<DetachableMessage>>();
    }

    public void addEnqueueMessage(Message message) {
        this.enqueueMessages.put(message.getInternalId(), message);
    }

    public void attach(String queueName, long messageInternalId) {
        Message message = this.enqueueMessages.get(messageInternalId);
        message.addAttachedDurableQueue(queueName);
    }

    public void detach(String queueName, long internalMessageId) {
        QueueDetachEventList detachList = this.detachMessageMap.computeIfAbsent(queueName, k -> new QueueDetachEventList());
        detachList.add(internalMessageId);
        ++this.detachOperationsCount;
    }

    public void prepareForDetach(String queueName, DetachableMessage message) {
        List preparedDetachList = this.preparedDetachEventMap.computeIfAbsent(queueName, k -> new ArrayList());
        preparedDetachList.add(message);
        ++this.preparedDetachEventCount;
    }

    public void addDeletableMessage(long internalMessageId) {
        this.deleteMessageIdList.add(internalMessageId);
    }

    public Collection<Message> getEnqueueMessages() {
        return this.enqueueMessages.values();
    }

    public Map<String, QueueDetachEventList> getDetachMessageMap() {
        return this.detachMessageMap;
    }

    public Map<String, List<DetachableMessage>> getPreparedDetachEventMap() {
        return this.preparedDetachEventMap;
    }

    public Collection<Long> getDeletableMessage() {
        return this.deleteMessageIdList;
    }

    public void clear() {
        this.enqueueMessages.clear();
        this.deleteMessageIdList.clear();
        this.detachMessageMap.clear();
        this.preparedDetachEventMap.clear();
        this.detachOperationsCount = 0;
        this.preparedDetachEventCount = 0;
    }

    public void releaseEnqueueMessages() {
        for (Message message : this.enqueueMessages.values()) {
            message.release();
        }
        this.enqueueMessages.clear();
    }

    public boolean isEmpty() {
        return this.deleteMessageIdList.isEmpty() && this.enqueueMessages.isEmpty() && this.detachMessageMap.isEmpty() && this.preparedDetachEventMap.isEmpty();
    }

    public int size() {
        return this.detachOperationsCount + this.preparedDetachEventCount + this.enqueueMessages.size() + this.deleteMessageIdList.size();
    }
}

