/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.store.dao.impl;

import io.ballerina.messaging.broker.common.BaseDao;
import io.ballerina.messaging.broker.core.BrokerException;
import io.ballerina.messaging.broker.core.Exchange;
import io.ballerina.messaging.broker.core.store.dao.ExchangeDao;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;

class ExchangeDaoImpl
extends BaseDao
implements ExchangeDao {
    ExchangeDaoImpl(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    public void persist(Exchange exchange) throws BrokerException {
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = this.getConnection();
            statement = connection.prepareStatement("INSERT INTO MB_EXCHANGE (EXCHANGE_NAME, EXCHANGE_TYPE) VALUES(?, ?)");
            statement.setString(1, exchange.getName());
            statement.setString(2, exchange.getType().toString());
            statement.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            try {
                String message = "Error occurred while storing exchange " + exchange;
                this.rollback(connection, message);
                throw new BrokerException(message, e);
            }
            catch (Throwable throwable) {
                this.close(connection, statement);
                throw throwable;
            }
        }
        this.close(connection, statement);
    }

    @Override
    public void delete(Exchange exchange) throws BrokerException {
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = this.getConnection();
            statement = connection.prepareStatement("DELETE FROM MB_EXCHANGE WHERE EXCHANGE_NAME=? AND EXCHANGE_TYPE=?");
            statement.setString(1, exchange.getName());
            statement.setString(2, exchange.getType().toString());
            statement.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            try {
                String message = "Error occurred while deleting exchange " + exchange;
                this.rollback(connection, message);
                throw new BrokerException("Error occurred while deleting exchange " + exchange, e);
            }
            catch (Throwable throwable) {
                this.close(connection, statement);
                throw throwable;
            }
        }
        this.close(connection, statement);
    }

    @Override
    public void retrieveAll(ExchangeDao.ExchangeCollector exchangeCollector) throws BrokerException {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT EXCHANGE_NAME, EXCHANGE_TYPE FROM MB_EXCHANGE");
            while (resultSet.next()) {
                String name = resultSet.getString(1);
                String typeString = resultSet.getString(2);
                exchangeCollector.addExchange(name, typeString);
            }
        }
        catch (SQLException e) {
            try {
                String message = "Error occurred while retrieving exchanges";
                this.rollback(connection, message);
                throw new BrokerException(message, e);
            }
            catch (Throwable throwable) {
                this.close(connection, statement, resultSet);
                throw throwable;
            }
        }
        this.close(connection, statement, resultSet);
    }
}

