/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.store.dao.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.ballerina.messaging.broker.common.BaseDao;
import io.ballerina.messaging.broker.core.BrokerException;
import io.ballerina.messaging.broker.core.ChunkConverter;
import io.ballerina.messaging.broker.core.ContentChunk;
import io.ballerina.messaging.broker.core.Message;
import io.ballerina.messaging.broker.core.Metadata;
import io.ballerina.messaging.broker.core.metrics.BrokerMetricManager;
import io.ballerina.messaging.broker.core.store.QueueDetachEventList;
import io.netty.buffer.Unpooled;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.wso2.carbon.metrics.core.Timer;

class MessageCrudOperationsDao
extends BaseDao {
    private final BrokerMetricManager metricManager;
    private final ChunkConverter chunkConverter;
    private Map<Long, Message> storedMessageCache = new ConcurrentHashMap<Long, Message>();

    MessageCrudOperationsDao(DataSource dataSource, BrokerMetricManager metricManager, ChunkConverter chunkConverter) {
        super(dataSource);
        this.metricManager = metricManager;
        this.chunkConverter = chunkConverter;
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"}, justification="Return value of context.stop() is not required.")
    public void storeMessages(Connection connection, Collection<Message> messageList) throws SQLException {
        PreparedStatement metadataStmt = null;
        PreparedStatement contentStmt = null;
        PreparedStatement insertToQueueStmt = null;
        Timer.Context context = this.metricManager.startMessageWriteTimer();
        try {
            metadataStmt = connection.prepareStatement("INSERT INTO MB_METADATA (MESSAGE_ID, EXCHANGE_NAME, ROUTING_KEY, CONTENT_LENGTH, MESSAGE_METADATA) VALUES(?, ?, ?, ?, ?)");
            contentStmt = connection.prepareStatement("INSERT INTO MB_CONTENT (MESSAGE_ID, CONTENT_OFFSET, MESSAGE_CONTENT) VALUES(?, ?, ?)");
            insertToQueueStmt = connection.prepareStatement("INSERT INTO MB_QUEUE_MAPPING (MESSAGE_ID, QUEUE_NAME) VALUES(?,?)");
            for (Message message : messageList) {
                this.prepareMetadata(metadataStmt, message);
                this.prepareContent(contentStmt, message);
                this.prepareQueueAttachments(insertToQueueStmt, message);
            }
            metadataStmt.executeBatch();
            contentStmt.executeBatch();
            insertToQueueStmt.executeBatch();
        }
        catch (SQLException e) {
            throw new SQLException("Error persisting messages.", e);
        }
        finally {
            context.stop();
            this.close(metadataStmt);
            this.close(contentStmt);
            this.close(insertToQueueStmt);
        }
    }

    private void prepareQueueAttachments(PreparedStatement insertToQueueStmt, Message message) throws SQLException {
        long id = message.getInternalId();
        for (String queueName : message.getAttachedDurableQueues()) {
            insertToQueueStmt.setLong(1, id);
            insertToQueueStmt.setString(2, queueName);
            insertToQueueStmt.addBatch();
        }
    }

    private void prepareContent(PreparedStatement contentStmt, Message message) throws SQLException {
        List<ContentChunk> contentChunks = message.getContentChunks();
        long contentLength = message.getMetadata().getContentLength();
        List<ContentChunk> convertedChunks = this.chunkConverter.convert(contentChunks, contentLength);
        for (ContentChunk chunk : convertedChunks) {
            contentStmt.setLong(1, message.getInternalId());
            contentStmt.setLong(2, chunk.getOffset());
            contentStmt.setBytes(3, chunk.getBytes());
            contentStmt.addBatch();
        }
    }

    private void prepareMetadata(PreparedStatement metadataStmt, Message message) throws SQLException {
        Metadata metadata = message.getMetadata();
        metadataStmt.setLong(1, message.getInternalId());
        metadataStmt.setString(2, metadata.getExchangeName());
        metadataStmt.setString(3, metadata.getRoutingKey());
        metadataStmt.setLong(4, metadata.getContentLength());
        metadataStmt.setBytes(5, metadata.getPropertiesAsBytes());
        metadataStmt.addBatch();
    }

    public void detachFromQueue(Connection connection, Map<String, QueueDetachEventList> detachableMessageMap) throws BrokerException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement("DELETE FROM MB_QUEUE_MAPPING WHERE MESSAGE_ID=? AND QUEUE_NAME=?");
            for (Map.Entry<String, QueueDetachEventList> entry : detachableMessageMap.entrySet()) {
                String queueName = entry.getKey();
                QueueDetachEventList queueDetachEventList = entry.getValue();
                for (long internalMessageId : queueDetachEventList.getMessageIds()) {
                    statement.setLong(1, internalMessageId);
                    statement.setString(2, queueName);
                    statement.addBatch();
                }
            }
            statement.executeBatch();
        }
        catch (SQLException e) {
            throw new BrokerException("Error detaching messages from queues.", e);
        }
        finally {
            this.close(statement);
        }
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"}, justification="Return value of context.stop() is not required.")
    public void delete(Connection connection, Collection<Long> internalIdList) throws BrokerException {
        PreparedStatement statement = null;
        Timer.Context context = this.metricManager.startMessageDeleteTimer();
        try {
            statement = connection.prepareStatement("DELETE FROM MB_METADATA WHERE MESSAGE_ID=?");
            for (Long internalId : internalIdList) {
                statement.setLong(1, internalId);
                statement.addBatch();
            }
            statement.executeBatch();
            for (Long internalId : internalIdList) {
                this.storedMessageCache.remove(internalId);
            }
        }
        catch (SQLException e) {
            throw new BrokerException("Error occurred while deleting messages", e);
        }
        finally {
            context.stop();
            this.close(statement);
        }
    }

    public Collection<Message> readAll(Connection connection, String queueName) throws BrokerException {
        Collection<Message> messageId2;
        LinkedHashMap<Long, Message> messageList = new LinkedHashMap<Long, Message>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement("SELECT MB_QUEUE_MAPPING.MESSAGE_ID, QUEUE_NAME FROM (SELECT MESSAGE_ID FROM MB_QUEUE_MAPPING WHERE QUEUE_NAME=?) AS QUEUE_MESSAGES INNER JOIN MB_QUEUE_MAPPING ON QUEUE_MESSAGES.MESSAGE_ID=MB_QUEUE_MAPPING.MESSAGE_ID ORDER BY QUEUE_MESSAGES.MESSAGE_ID");
            statement.setString(1, queueName);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                long messageId2 = resultSet.getLong(1);
                Message cachedMessage = this.storedMessageCache.get(messageId2);
                if (Objects.nonNull(cachedMessage)) {
                    if (messageList.containsKey(messageId2)) continue;
                    messageList.put(messageId2, cachedMessage.bareShallowCopy());
                    continue;
                }
                Message message = messageList.computeIfAbsent(messageId2, k -> new Message((long)k, null));
                message.addAttachedDurableQueue(resultSet.getString(2));
            }
            this.storedMessageCache.putAll(messageList);
            messageId2 = messageList.values();
        }
        catch (SQLException e) {
            try {
                throw new BrokerException("Error occurred while reading messages", e);
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                this.close(statement);
                throw throwable;
            }
        }
        this.close(resultSet);
        this.close(statement);
        return messageId2;
    }

    public void read(Connection connection, Map<Long, List<Message>> messageMap) throws BrokerException {
        try (Timer.Context ignored = this.metricManager.startMessageReadTimer();){
            if (!messageMap.isEmpty()) {
                String idList = this.getSQLFormattedIdList(messageMap.size());
                this.populateMessageWithMetadata(connection, idList, messageMap.keySet(), messageMap);
                this.populateContent(connection, idList, messageMap);
            }
        }
        catch (SQLException e) {
            throw new BrokerException("Error occurred while reading messages", e);
        }
    }

    /*
     * Exception decompiling
     */
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"})
    private void populateMessageWithMetadata(Connection connection, String idListAsString, Collection<Long> idList, Map<Long, List<Message>> messageMap) throws SQLException, BrokerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"})
    private void populateContent(Connection connection, String idList, Map<Long, List<Message>> messageMap) throws SQLException {
        PreparedStatement selectContent = null;
        ResultSet contentResultSet = null;
        try {
            selectContent = connection.prepareStatement("SELECT MESSAGE_ID, CONTENT_OFFSET, MESSAGE_CONTENT FROM MB_CONTENT WHERE MESSAGE_ID IN(" + idList + ")");
            int i = 0;
            for (Long messageId : messageMap.keySet()) {
                selectContent.setLong(++i, messageId);
            }
            contentResultSet = selectContent.executeQuery();
            while (contentResultSet.next()) {
                long messageId = contentResultSet.getLong(1);
                int offset = contentResultSet.getInt(2);
                byte[] bytes = contentResultSet.getBytes(3);
                List<Message> messages = messageMap.get(messageId);
                for (Message message : messages) {
                    if (!Objects.nonNull(message)) continue;
                    message.addChunk(new ContentChunk(offset, Unpooled.wrappedBuffer((byte[])bytes)));
                }
            }
        }
        catch (Throwable throwable) {
            this.close(contentResultSet);
            this.close(selectContent);
            throw throwable;
        }
        this.close(contentResultSet);
        this.close(selectContent);
    }
}

