/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.task;

import io.ballerina.messaging.broker.core.task.Task;
import io.ballerina.messaging.broker.core.task.TaskExceptionHandler;
import io.ballerina.messaging.broker.core.task.TaskHolder;
import java.util.concurrent.Callable;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TaskProcessor
implements Callable<Boolean> {
    private static Logger log = LoggerFactory.getLogger(TaskProcessor.class);
    private DelayQueue<TaskHolder> taskHolderQueue;
    private AtomicBoolean isActive = new AtomicBoolean(false);
    private TaskExceptionHandler taskExceptionHandler;
    private final long idleWaitTimeMillis;

    TaskProcessor(DelayQueue<TaskHolder> taskQueue, TaskExceptionHandler exceptionHandler, long idleWaitTimeMillis) {
        this.taskExceptionHandler = exceptionHandler;
        this.taskHolderQueue = taskQueue;
        this.idleWaitTimeMillis = idleWaitTimeMillis;
    }

    void deactivate() {
        this.isActive.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() {
        if (this.isActive.compareAndSet(false, true)) {
            if (log.isDebugEnabled()) {
                log.debug("Task processor started");
            }
            while (this.isActive.get()) {
                TaskHolder taskHolder = null;
                long delay = 0L;
                try {
                    taskHolder = (TaskHolder)this.taskHolderQueue.take();
                    Task.TaskHint hint = taskHolder.executeTask();
                    if (hint != Task.TaskHint.IDLE) continue;
                    delay = this.idleWaitTimeMillis;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    if (!this.isActive.get()) continue;
                    this.taskExceptionHandler.handleException(e, "null");
                }
                catch (Throwable throwable) {
                    String id = null != taskHolder ? taskHolder.getId() : "null";
                    this.taskExceptionHandler.handleException(throwable, id);
                }
                finally {
                    if (null == taskHolder) continue;
                    if (taskHolder.isDisabled()) {
                        taskHolder.onRemoveTask();
                        continue;
                    }
                    taskHolder.setDelay(delay, TimeUnit.MILLISECONDS);
                    this.taskHolderQueue.put(taskHolder);
                }
            }
        } else {
            log.error("Task processor is already running ");
            throw new IllegalStateException("Task processor is already running");
        }
        log.info("Task processor stopped. Task queue size {}", (Object)this.taskHolderQueue.size());
        return true;
    }
}

