/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.transaction;

import io.ballerina.messaging.broker.common.ValidationException;
import io.ballerina.messaging.broker.core.Broker;
import io.ballerina.messaging.broker.core.BrokerException;
import io.ballerina.messaging.broker.core.DetachableMessage;
import io.ballerina.messaging.broker.core.Message;
import io.ballerina.messaging.broker.core.QueueHandler;
import io.ballerina.messaging.broker.core.store.MessageStore;
import io.ballerina.messaging.broker.core.transaction.EnqueueDequeueStrategy;
import io.ballerina.messaging.broker.core.util.MessageTracer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import javax.transaction.xa.Xid;

public class Branch
implements EnqueueDequeueStrategy {
    private State state;
    private Xid xid;
    private final MessageStore messageStore;
    private final Set<QueueHandler> affectedQueueHandlers;
    private final Broker broker;
    private final Map<Integer, SessionState> associatedSessions;
    private Future timeoutTaskFuture;

    Branch(Xid xid, MessageStore messageStore, Broker broker) {
        this.xid = xid;
        this.messageStore = messageStore;
        this.broker = broker;
        messageStore.branch(xid);
        this.affectedQueueHandlers = new HashSet<QueueHandler>();
        this.associatedSessions = new HashMap<Integer, SessionState>();
        this.state = State.ACTIVE;
        this.timeoutTaskFuture = null;
    }

    @Override
    public void enqueue(Message message) throws BrokerException {
        Set<QueueHandler> queueHandlers = this.broker.enqueue(this.xid, message);
        this.affectedQueueHandlers.addAll(queueHandlers);
    }

    @Override
    public void dequeue(String queueName, DetachableMessage detachableMessage) throws BrokerException {
        QueueHandler queueHandler = this.broker.dequeue(this.xid, queueName, detachableMessage);
        this.affectedQueueHandlers.add(queueHandler);
    }

    public void prepare() throws BrokerException {
        this.state = State.PRE_PREPARE;
        this.messageStore.prepare(this.xid);
        this.state = State.PREPARED;
        MessageTracer.trace(this.xid, "Transaction prepared.");
    }

    public void commit(boolean onePhase) throws BrokerException {
        if (this.state == State.PARTIAL_RESTORE) {
            this.affectedQueueHandlers.addAll(this.recoverEnqueuedMessages());
        }
        this.messageStore.flush(this.xid, onePhase);
        for (QueueHandler queueHandler : this.affectedQueueHandlers) {
            queueHandler.commit(this.xid);
        }
        MessageTracer.trace(this.xid, "Transaction commit event.");
    }

    public void rollback() {
        this.messageStore.clear(this.xid);
        this.rollbackQueueHandlers();
        MessageTracer.trace(this.xid, "Transaction rollback event.");
    }

    public void dtxRollback() throws BrokerException {
        this.messageStore.remove(this.xid);
        this.rollbackQueueHandlers();
        MessageTracer.trace(this.xid, "Transaction rollback event.");
    }

    private void rollbackQueueHandlers() {
        for (QueueHandler queueHandler : this.affectedQueueHandlers) {
            queueHandler.rollback(this.xid);
        }
    }

    public Xid getXid() {
        return this.xid;
    }

    public void setState(State state) {
        this.state = state;
    }

    public State getState() {
        return this.state;
    }

    public void associateSession(int sessionId) {
        this.associatedSessions.put(sessionId, SessionState.ACTIVE);
    }

    public void resumeSession(int sessionId) throws ValidationException {
        if (!this.associatedSessions.containsKey(sessionId) || this.associatedSessions.get(sessionId) != SessionState.SUSPENDED) {
            throw new ValidationException("Couldn't resume session for branch with xid " + this.xid + " and session id " + sessionId);
        }
        this.associatedSessions.put(sessionId, SessionState.ACTIVE);
    }

    public void disassociateSession(int sessionId) {
        this.associatedSessions.remove(sessionId);
    }

    public void suspendSession(int sessionId) {
        SessionState associatedState = this.associatedSessions.get(sessionId);
        if (Objects.nonNull((Object)associatedState) && associatedState == SessionState.ACTIVE) {
            this.associatedSessions.put(sessionId, SessionState.SUSPENDED);
        }
    }

    public boolean isAssociated(int sessionId) {
        return this.associatedSessions.containsKey(sessionId);
    }

    public boolean hasAssociatedActiveSessions() {
        if (this.hasAssociatedSessions()) {
            for (SessionState sessionState : this.associatedSessions.values()) {
                if (sessionState == SessionState.SUSPENDED) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasAssociatedSessions() {
        return !this.associatedSessions.isEmpty();
    }

    public void clearAssociations() {
        this.associatedSessions.clear();
    }

    public void setTimeoutTaskFuture(ScheduledFuture<?> future) {
        this.timeoutTaskFuture = future;
    }

    private Set<QueueHandler> recoverEnqueuedMessages() throws BrokerException {
        Collection<Message> messages = this.messageStore.recoverEnqueuedMessages(this.xid);
        return this.broker.restoreDtxPreparedMessages(this.xid, messages);
    }

    public boolean isExpired() {
        return Objects.nonNull(this.timeoutTaskFuture) && this.state == State.TIMED_OUT;
    }

    public Future getTimeoutTaskFuture() {
        return this.timeoutTaskFuture;
    }

    void markAsRecoveryBranch() {
        this.state = State.PARTIAL_RESTORE;
    }

    boolean isPrepared() {
        return this.state == State.PREPARED || this.state == State.PARTIAL_RESTORE;
    }

    boolean isRollbackOnly() {
        return this.state == State.ROLLBACK_ONLY;
    }

    private static enum SessionState {
        ACTIVE,
        SUSPENDED;

    }

    public static enum State {
        ACTIVE,
        ROLLBACK_ONLY,
        PRE_PREPARE,
        FORGOTTEN,
        TIMED_OUT,
        PREPARED,
        PARTIAL_RESTORE,
        HEUR_COM,
        HEUR_RB;

    }
}

