/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.transaction;

import io.ballerina.messaging.broker.core.Broker;
import io.ballerina.messaging.broker.core.BrokerException;
import io.ballerina.messaging.broker.core.DetachableMessage;
import io.ballerina.messaging.broker.core.Message;
import io.ballerina.messaging.broker.core.store.MessageStore;
import io.ballerina.messaging.broker.core.transaction.Branch;
import io.ballerina.messaging.broker.core.transaction.EnqueueDequeueStrategy;
import io.ballerina.messaging.broker.core.transaction.XidImpl;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import javax.transaction.xa.Xid;

public class BranchFactory {
    private final Broker broker;
    private final MessageStore messageStore;
    private final EnqueueDequeueStrategy enqueueDequeueStrategy;

    BranchFactory(Broker broker, MessageStore messageStore) {
        this.broker = broker;
        this.messageStore = messageStore;
        this.enqueueDequeueStrategy = new DirectEnqueueDequeueStrategy(broker);
    }

    public Branch createBranch() {
        XidImpl xid = new XidImpl(0, UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8), "".getBytes(StandardCharsets.UTF_8));
        return this.createBranch(xid);
    }

    public Branch createBranch(Xid xid) {
        return new Branch(xid, this.messageStore, this.broker);
    }

    public EnqueueDequeueStrategy getDirectEnqueueDequeueStrategy() {
        return this.enqueueDequeueStrategy;
    }

    private static class DirectEnqueueDequeueStrategy
    implements EnqueueDequeueStrategy {
        final Broker broker;

        private DirectEnqueueDequeueStrategy(Broker broker) {
            this.broker = broker;
        }

        @Override
        public void enqueue(Message message) throws BrokerException {
            this.broker.publish(message);
        }

        @Override
        public void dequeue(String queueName, DetachableMessage detachableMessage) throws BrokerException {
            this.broker.acknowledge(queueName, detachableMessage);
        }
    }
}

