/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.transaction;

import io.ballerina.messaging.broker.common.ValidationException;
import io.ballerina.messaging.broker.core.BrokerException;
import io.ballerina.messaging.broker.core.DetachableMessage;
import io.ballerina.messaging.broker.core.Message;
import io.ballerina.messaging.broker.core.transaction.Branch;
import io.ballerina.messaging.broker.core.transaction.BranchFactory;
import io.ballerina.messaging.broker.core.transaction.BrokerTransaction;
import io.ballerina.messaging.broker.core.transaction.EnqueueDequeueStrategy;
import io.ballerina.messaging.broker.core.transaction.Registry;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.transaction.xa.Xid;

public class DistributedTransaction
implements BrokerTransaction {
    public static final String UNKNOWN_XID_ERROR_MSG = "Branch not found with xid ";
    private final BranchFactory branchFactory;
    private final Registry transactionRegistry;
    private EnqueueDequeueStrategy enqueueDequeueStrategy;
    private boolean preConditionFailed;
    private StringBuilder errorMessageBuilder;

    DistributedTransaction(BranchFactory branchFactory, Registry transactionRegistry) {
        this.branchFactory = branchFactory;
        this.transactionRegistry = transactionRegistry;
        this.enqueueDequeueStrategy = branchFactory.getDirectEnqueueDequeueStrategy();
        this.preConditionFailed = false;
        this.errorMessageBuilder = new StringBuilder();
    }

    @Override
    public void dequeue(String queue, DetachableMessage detachableMessage) {
        try {
            this.enqueueDequeueStrategy.dequeue(queue, detachableMessage);
        }
        catch (BrokerException e) {
            this.preConditionFailed = true;
            this.errorMessageBuilder.append(e.getMessage()).append('\n');
        }
    }

    @Override
    public void enqueue(Message message) {
        try {
            this.enqueueDequeueStrategy.enqueue(message);
        }
        catch (BrokerException e) {
            this.preConditionFailed = true;
            this.errorMessageBuilder.append(e.getMessage()).append('\n');
        }
    }

    @Override
    public void commit() throws ValidationException {
        throw new ValidationException("tx.commit called on distributed-transactional channel");
    }

    @Override
    public void rollback() throws ValidationException {
        throw new ValidationException("tx.rollback called on distributed-transactional channel");
    }

    @Override
    public void addPostTransactionAction(BrokerTransaction.Action postTransactionAction) {
    }

    @Override
    public void onClose() {
    }

    @Override
    public void start(Xid xid, int sessionId, boolean join, boolean resume) throws ValidationException {
        if (join && resume) {
            throw new ValidationException("Cannot start a branch with both join and resume set " + xid);
        }
        Branch branch = this.transactionRegistry.getBranch(xid);
        if (join) {
            if (Objects.isNull(branch)) {
                throw new ValidationException(UNKNOWN_XID_ERROR_MSG + xid);
            }
            branch.associateSession(sessionId);
        } else if (resume) {
            if (Objects.isNull(branch)) {
                throw new ValidationException(UNKNOWN_XID_ERROR_MSG + xid);
            }
            branch.resumeSession(sessionId);
        } else {
            if (Objects.nonNull(branch)) {
                throw new ValidationException("Xid " + xid + " cannot be started as it is already known");
            }
            branch = this.branchFactory.createBranch(xid);
            this.transactionRegistry.register(branch);
            branch.associateSession(sessionId);
        }
        this.enqueueDequeueStrategy = branch;
    }

    @Override
    public void end(Xid xid, int sessionId, boolean fail, boolean suspend) throws ValidationException {
        Branch branch = this.transactionRegistry.getBranch(xid);
        if (Objects.isNull(branch)) {
            throw new ValidationException(UNKNOWN_XID_ERROR_MSG + xid);
        }
        if (suspend && fail) {
            branch.disassociateSession(sessionId);
            this.enqueueDequeueStrategy = this.branchFactory.getDirectEnqueueDequeueStrategy();
            throw new ValidationException("Cannot end a branch with both suspend and fail set " + xid);
        }
        if (!branch.isAssociated(sessionId)) {
            throw new ValidationException("Xid " + xid + " not associated with the current session");
        }
        if (suspend) {
            branch.suspendSession(sessionId);
        } else {
            if (fail) {
                branch.setState(Branch.State.ROLLBACK_ONLY);
            }
            branch.disassociateSession(sessionId);
        }
        this.enqueueDequeueStrategy = this.branchFactory.getDirectEnqueueDequeueStrategy();
    }

    @Override
    public void prepare(Xid xid) throws BrokerException, ValidationException {
        if (this.preConditionFailed) {
            throw new ValidationException("Pre conditions failed for commit. Errors " + this.errorMessageBuilder.toString());
        }
        this.transactionRegistry.prepare(xid);
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws ValidationException, BrokerException {
        this.transactionRegistry.commit(xid, onePhase);
        this.clearErrors();
    }

    private void clearErrors() {
        this.preConditionFailed = false;
        this.errorMessageBuilder.setLength(0);
    }

    @Override
    public void rollback(Xid xid) throws ValidationException, BrokerException {
        this.transactionRegistry.rollback(xid);
        this.clearErrors();
    }

    @Override
    public void forget(Xid xid) throws ValidationException {
        this.transactionRegistry.forget(xid);
    }

    @Override
    public void setTimeout(Xid xid, long timeout, TimeUnit timeUnit) throws ValidationException {
        this.transactionRegistry.setTimeout(xid, timeout, timeUnit);
    }

    @Override
    public boolean inTransactionBlock() {
        return this.enqueueDequeueStrategy instanceof Branch;
    }
}

