/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.transaction;

import io.ballerina.messaging.broker.auth.AuthException;
import io.ballerina.messaging.broker.auth.AuthNotFoundException;
import io.ballerina.messaging.broker.auth.authorization.AuthorizationHandler;
import io.ballerina.messaging.broker.auth.authorization.enums.ResourceAction;
import io.ballerina.messaging.broker.auth.authorization.enums.ResourceAuthScope;
import io.ballerina.messaging.broker.auth.authorization.enums.ResourceType;
import io.ballerina.messaging.broker.core.BrokerAuthException;
import io.ballerina.messaging.broker.core.BrokerAuthNotFoundException;
import io.ballerina.messaging.broker.core.BrokerException;
import io.ballerina.messaging.broker.core.Message;
import io.ballerina.messaging.broker.core.transaction.BrokerTransaction;
import io.ballerina.messaging.broker.core.transaction.ForwardingBrokerTransaction;
import javax.security.auth.Subject;

public class SecureBrokerTransaction
extends ForwardingBrokerTransaction {
    private final Subject subject;
    private final AuthorizationHandler authHandler;

    public SecureBrokerTransaction(BrokerTransaction brokerTransaction, Subject subject, AuthorizationHandler authHandler) {
        super(brokerTransaction);
        this.subject = subject;
        this.authHandler = authHandler;
    }

    @Override
    public void enqueue(Message message) throws BrokerException {
        try {
            this.authHandler.handle(ResourceAuthScope.EXCHANGES_PUBLISH, ResourceType.EXCHANGE, message.getMetadata().getExchangeName(), ResourceAction.PUBLISH, this.subject);
            super.enqueue(message);
        }
        catch (AuthException e) {
            throw new BrokerAuthException(e.getMessage(), e);
        }
        catch (AuthNotFoundException e) {
            throw new BrokerAuthNotFoundException(e.getMessage(), e);
        }
    }
}

