/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.mysql;

import java.util.Properties;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.mysql.Utils;
import org.ballerinalang.sql.datasource.SQLDatasource;
import org.ballerinalang.sql.utils.ClientUtils;

public class NativeImpl {
    public static Object createClient(ObjectValue client, MapValue<String, Object> clientConfig, MapValue<String, Object> globalPool) {
        MapValue<String, Object> connectionPool;
        Object connectTimeout;
        String url = "jdbc:mysql://" + clientConfig.getStringValue("host");
        Long portValue = clientConfig.getIntValue("port");
        if (portValue > 0L) {
            url = url + ":" + portValue.intValue();
        }
        String user = clientConfig.getStringValue("user");
        String password = clientConfig.getStringValue("password");
        String database = clientConfig.getStringValue("database");
        if (database != null && !database.isEmpty()) {
            url = url + "/" + database;
        }
        MapValue options = clientConfig.getMapValue("options");
        MapValue properties = null;
        Properties poolProperties = null;
        if (options != null && (connectTimeout = (properties = Utils.generateOptionsMap(options)).get((Object)"connectTimeout")) != null) {
            poolProperties = new Properties();
            poolProperties.setProperty("ConnectionTimeout", connectTimeout.toString());
        }
        if ((connectionPool = clientConfig.getMapValue("connectionPool")) == null) {
            connectionPool = globalPool;
        }
        String datasourceName = "com.mysql.cj.jdbc.MysqlDataSource";
        if (options != null && options.getBooleanValue("useXADatasource").booleanValue()) {
            datasourceName = "com.mysql.cj.jdbc.MysqlXADataSource";
        }
        SQLDatasource.SQLDatasourceParams sqlDatasourceParams = new SQLDatasource.SQLDatasourceParams().setUrl(url).setUser(user).setPassword(password).setDatasourceName(datasourceName).setOptions(properties).setConnectionPool(connectionPool).setPoolProperties(poolProperties);
        return ClientUtils.createClient((ObjectValue)client, (SQLDatasource.SQLDatasourceParams)sqlDatasourceParams);
    }

    public static Object close(ObjectValue client) {
        return ClientUtils.close((ObjectValue)client);
    }
}

