/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.mysql;

import org.ballerinalang.jvm.values.DecimalValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.MapValueImpl;

public class Utils {
    static MapValue generateOptionsMap(MapValue mysqlOptions) {
        if (mysqlOptions != null) {
            long socketTimeout;
            MapValueImpl options = new MapValueImpl();
            Utils.addSSLOptions(mysqlOptions.getMapValue("ssl"), (MapValue<String, Object>)options);
            long connectTimeout = Utils.getTimeout(mysqlOptions.get((Object)"connectTimeoutInSeconds"));
            if (connectTimeout > 0L) {
                options.put((Object)"connectTimeout", (Object)connectTimeout);
            }
            if ((socketTimeout = Utils.getTimeout(mysqlOptions.get((Object)"socketTimeoutInSeconds"))) > 0L) {
                options.put((Object)"socketTimeout", (Object)socketTimeout);
            }
            return options;
        }
        return null;
    }

    public static long getTimeout(Object secondsDecimal) {
        DecimalValue timeoutSec;
        if (secondsDecimal instanceof DecimalValue && (timeoutSec = (DecimalValue)secondsDecimal).floatValue() > 0.0) {
            return Double.valueOf(timeoutSec.floatValue() * 1000.0).longValue();
        }
        return -1L;
    }

    private static void addSSLOptions(MapValue sslConfig, MapValue<String, Object> options) {
        if (sslConfig == null) {
            options.put((Object)"sslMode", (Object)"DISABLED");
        } else {
            MapValue trustCertKeystore;
            String mode = sslConfig.getStringValue("mode");
            if (mode.equalsIgnoreCase("VERIFY_CERT")) {
                mode = "VERIFY_CA";
            }
            options.put((Object)"sslMode", (Object)mode);
            MapValue clientCertKeystore = sslConfig.getMapValue("clientCertKeystore");
            if (clientCertKeystore != null) {
                options.put((Object)"clientCertificateKeyStoreUrl", (Object)("file:" + clientCertKeystore.getStringValue("path")));
                options.put((Object)"clientCertificateKeyStorePassword", (Object)clientCertKeystore.getStringValue("password"));
                options.put((Object)"clientCertificateKeyStoreType", (Object)"PKCS12");
            }
            if ((trustCertKeystore = sslConfig.getMapValue("trustCertKeystore")) != null) {
                options.put((Object)"trustCertificateKeyStoreUrl", (Object)("file:" + trustCertKeystore.getStringValue("path")));
                options.put((Object)"trustCertificateKeyStorePassword", (Object)trustCertKeystore.getStringValue("password"));
                options.put((Object)"trustCertificateKeyStoreType", (Object)"PKCS12");
            }
        }
    }
}

