/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.openapi.cmd;

import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.ballerinalang.ballerina.openapi.convertor.service.OpenApiConverterUtils;
import org.ballerinalang.tool.BLauncherCmd;
import org.ballerinalang.tool.LauncherUtils;
import picocli.CommandLine;

@CommandLine.Command(name="gen-contract")
public class OpenApiGenContractCmd
implements BLauncherCmd {
    private static final String CMD_NAME = "openapi-gen-contract";
    private static final PrintStream outStream = System.err;
    @CommandLine.Parameters(index="0", split=":")
    private List<String> moduleArgs;
    @CommandLine.Parameters(index="1..*")
    private List<String> argList;
    @CommandLine.Option(names={"-i", "--ballerina-file"}, description={"The ballerina file which consists the service which needs to be exported."})
    private String balFile;
    @CommandLine.Option(names={"-o", "--contract-location"}, description={"The location which the exported OpenApi contract should be saved."})
    private String exportLocation = "";
    @CommandLine.Option(names={"-s", "--skip-bind"}, description={"This will skip binding the generated contract to the relevant ballerina file if specified."})
    private boolean skipBind;
    @CommandLine.Option(names={"-h", "--help"}, hidden=true)
    private boolean helpFlag;

    public void execute() {
        outStream.println("Note: This is an experimental tool, which only supports a limited set of functionality.");
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)this.getName());
            outStream.println(commandUsageInfo);
            return;
        }
        if (this.moduleArgs == null) {
            throw LauncherUtils.createLauncherException((String)"A service name is mandatory to generate an OpenApi contract. \nballerina openapi gen-contract [moduleName]:serviceName [-i: ballerinaFile]");
        }
        if (this.moduleArgs.size() == 1 && this.balFile == null) {
            throw LauncherUtils.createLauncherException((String)"Please specify a ballerina document path in order generate an OpenApi contract for the service \nballerina openapi gen-contract [moduleName]:serviceName [-i: ballerinaFile]");
        }
        if (this.moduleArgs.size() == 2) {
            String module = this.moduleArgs.get(0);
            String service = this.moduleArgs.get(1);
            this.genOASfromModule(module, service);
        }
        if (this.moduleArgs.size() == 1 && this.balFile != null) {
            String service = this.moduleArgs.get(0);
            Path servicePath = Paths.get(this.balFile, new String[0]);
            this.genOASfromFile(service, servicePath);
        }
    }

    private void genOASfromModule(String module, String serviceName) {
        Path outPutPath = Paths.get(this.exportLocation, new String[0]);
        if (!this.checkModuleExist(module)) {
            throw LauncherUtils.createLauncherException((String)"The module provided is not found in the current location.");
        }
        try {
            OpenApiConverterUtils.generateOAS3DefinitionFromModule((String)module, (String)serviceName, (Path)outPutPath);
        }
        catch (Exception e) {
            throw LauncherUtils.createLauncherException((String)("Error occurred when exporting openapi file. \n" + e.getMessage()));
        }
    }

    private void genOASfromFile(String serviceName, Path servicePath) {
        Path outPath = Paths.get(this.exportLocation, new String[0]);
        try {
            OpenApiConverterUtils.generateOAS3Definitions((Path)servicePath, (Path)outPath, (String)serviceName);
        }
        catch (Exception e) {
            throw LauncherUtils.createLauncherException((String)("Error occurred when exporting openapi file for service file at " + servicePath.toString() + ". " + e.getMessage() + "."));
        }
    }

    public String getName() {
        return CMD_NAME;
    }

    public void printLongDesc(StringBuilder out) {
    }

    public void printUsage(StringBuilder out) {
    }

    public void setParentCmdParser(CommandLine parentCmdParser) {
    }

    private boolean checkModuleExist(String moduleName) {
        Path userLocation = Paths.get(System.getProperty("user.dir"), new String[0]);
        Path moduleLocation = userLocation.resolve("src").resolve(moduleName);
        return Files.exists(moduleLocation, new LinkOption[0]);
    }
}

