/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.openapi.model;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.tags.Tag;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.openapi.exception.BallerinaOpenApiException;
import org.ballerinalang.openapi.model.BallerinaOpenApiObject;
import org.ballerinalang.openapi.model.BallerinaOperation;
import org.ballerinalang.openapi.model.BallerinaPath;
import org.ballerinalang.openapi.model.BallerinaSchema;
import org.ballerinalang.openapi.model.BallerinaServer;
import org.ballerinalang.openapi.utils.CodegenUtils;
import org.ballerinalang.openapi.utils.TypeExtractorUtil;

public class BallerinaOpenApi
implements BallerinaOpenApiObject<BallerinaOpenApi, OpenAPI> {
    private String srcPackage;
    private String modelPackage;
    private String openapi = "3.0.0";
    private String definitionPath = "";
    private Info info = null;
    private ExternalDocumentation externalDocs = null;
    private List<BallerinaServer> servers = null;
    private Set<Map.Entry<String, String>> security = null;
    private List<Tag> tags = null;
    private Set<Map.Entry<String, BallerinaPath>> paths = null;
    private Set<Map.Entry<String, BallerinaSchema>> schemas = null;
    private Components components = null;
    private Map<String, Object> extensions = null;
    private static String pathName;

    @Override
    public BallerinaOpenApi buildContext(OpenAPI openAPI) throws BallerinaOpenApiException {
        this.openapi = openAPI.getOpenapi();
        this.info = openAPI.getInfo();
        this.externalDocs = openAPI.getExternalDocs();
        this.tags = openAPI.getTags();
        this.components = openAPI.getComponents();
        this.extensions = openAPI.getExtensions();
        this.setPaths(openAPI);
        this.setSecurityRequirements(openAPI);
        this.setServers(openAPI);
        this.setSchemas(openAPI);
        return this;
    }

    @Override
    public BallerinaOpenApi buildContext(OpenAPI definition, OpenAPI openAPI) throws BallerinaOpenApiException {
        return this.buildContext(definition);
    }

    @Override
    public BallerinaOpenApi getDefaultValue() {
        return null;
    }

    private void setPaths(OpenAPI openAPI) throws BallerinaOpenApiException {
        if (openAPI.getPaths() == null) {
            return;
        }
        this.paths = new LinkedHashSet<Map.Entry<String, BallerinaPath>>();
        Paths pathList = openAPI.getPaths();
        for (Map.Entry path : pathList.entrySet()) {
            BallerinaOpenApi.setPathName((String)path.getKey());
            BallerinaPath balPath = new BallerinaPath().buildContext((PathItem)path.getValue(), openAPI);
            if (balPath.isNoOperationsForPath()) {
                balPath.setResourceName(TypeExtractorUtil.escapeIdentifier((String)path.getKey()));
            } else {
                balPath.getOperations().forEach(operation -> {
                    if (((BallerinaOperation)operation.getValue()).getOperationId() == null) {
                        String pathName = ((String)path.getKey()).substring(1);
                        String operationId = (String)operation.getKey() + StringUtils.capitalize((String)pathName);
                        ((BallerinaOperation)operation.getValue()).setOperationId(TypeExtractorUtil.escapeIdentifier(CodegenUtils.normalizeForBIdentifier(operationId)));
                    } else {
                        String opId = ((BallerinaOperation)operation.getValue()).getOperationId();
                        ((BallerinaOperation)operation.getValue()).setOperationId(TypeExtractorUtil.escapeIdentifier(opId));
                    }
                });
            }
            String resourcePath = this.hasPathParams((PathItem)path.getValue()) ? "string `" + ((String)path.getKey()).replace("{", "${") + "`" : "\"" + (String)path.getKey() + "\"";
            this.paths.add(new AbstractMap.SimpleEntry<String, BallerinaPath>(resourcePath, balPath));
        }
    }

    private boolean hasPathParams(PathItem path) {
        if (path.getParameters() != null && !path.getParameters().isEmpty()) {
            return path.getParameters().stream().anyMatch(parameter -> parameter.getIn() != null && parameter.getIn().equals("path"));
        }
        if (path.readOperations().isEmpty()) {
            return false;
        }
        return path.readOperations().stream().anyMatch(operation -> {
            if (operation.getParameters() != null && !operation.getParameters().isEmpty()) {
                return operation.getParameters().stream().anyMatch(parameter -> parameter.getIn() != null && parameter.getIn().equals("path"));
            }
            return false;
        });
    }

    private void setSchemas(OpenAPI openAPI) {
        this.schemas = new LinkedHashSet<Map.Entry<String, BallerinaSchema>>();
        if (openAPI.getComponents() == null || openAPI.getComponents().getSchemas() == null) {
            return;
        }
        Map schemaMap = openAPI.getComponents().getSchemas();
        for (Map.Entry entry : schemaMap.entrySet()) {
            try {
                BallerinaSchema schema = new BallerinaSchema().buildContext((Schema)entry.getValue(), openAPI);
                if (StringUtils.isEmpty((CharSequence)schema.getType())) {
                    schema.setType((String)entry.getKey());
                }
                this.schemas.add(new AbstractMap.SimpleEntry(entry.getKey(), schema));
            }
            catch (BallerinaOpenApiException ballerinaOpenApiException) {}
        }
    }

    private void setServers(OpenAPI openAPI) throws BallerinaOpenApiException {
        this.servers = new ArrayList<BallerinaServer>();
        List serverList = openAPI.getServers();
        if (serverList == null) {
            BallerinaServer server2 = new BallerinaServer().getDefaultValue();
            this.servers.add(server2);
            return;
        }
        serverList.forEach(server -> {
            try {
                BallerinaServer balServer = new BallerinaServer().buildContext((Server)server);
                this.servers.add(balServer);
            }
            catch (BallerinaOpenApiException e) {
                this.servers.add(new BallerinaServer().getDefaultValue());
            }
        });
    }

    private void setSecurityRequirements(OpenAPI openAPI) {
        this.security = new LinkedHashSet<Map.Entry<String, String>>();
        List requirements = openAPI.getSecurity();
        if (requirements == null || requirements.isEmpty()) {
            return;
        }
        requirements.forEach(r -> r.forEach((key, value) -> {
            AbstractMap.SimpleEntry<String, List> entry = new AbstractMap.SimpleEntry<String, List>((String)key, (List)value);
            this.security.add(entry);
        }));
    }

    public BallerinaOpenApi srcPackage(String srcPackage) {
        if (srcPackage != null) {
            this.srcPackage = srcPackage.replaceFirst("\\.", "/");
        }
        return this;
    }

    public BallerinaOpenApi modelPackage(String modelPackage) {
        if (modelPackage != null) {
            this.modelPackage = modelPackage.replaceFirst("\\.", "/");
        }
        return this;
    }

    public String getSrcPackage() {
        return this.srcPackage;
    }

    public String getModelPackage() {
        return this.modelPackage;
    }

    public String getOpenapi() {
        return this.openapi;
    }

    public Info getInfo() {
        return this.info;
    }

    public ExternalDocumentation getExternalDocs() {
        return this.externalDocs;
    }

    public List<BallerinaServer> getServers() {
        return this.servers;
    }

    public Set<Map.Entry<String, String>> getSecurity() {
        return this.security;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public Set<Map.Entry<String, BallerinaPath>> getPaths() {
        return this.paths;
    }

    public Components getComponents() {
        return this.components;
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public Set<Map.Entry<String, BallerinaSchema>> getSchemas() {
        return this.schemas;
    }

    public void setDefinitionPath(String definitionPath) {
        this.definitionPath = definitionPath;
    }

    public String getDefinitionPath() {
        return this.definitionPath;
    }

    public static void setPathName(String pathName) {
        BallerinaOpenApi.pathName = pathName;
    }

    public static String getPathName() {
        return pathName;
    }
}

