/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.openapi.model;

import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ballerinalang.openapi.exception.BallerinaOpenApiException;
import org.ballerinalang.openapi.model.BallerinaOpenApiObject;
import org.ballerinalang.openapi.model.BallerinaParameter;
import org.ballerinalang.openapi.model.BallerinaRequestBody;
import org.ballerinalang.openapi.utils.CodegenUtils;

public class BallerinaOperation
implements BallerinaOpenApiObject<BallerinaOperation, Operation> {
    private List<String> tags;
    private String summary;
    private String description;
    private ExternalDocumentation externalDocs;
    private String operationId;
    private List<BallerinaParameter> pathParameters;
    private List<BallerinaParameter> queryParameters;
    private BallerinaRequestBody requestBody;
    private Set<Map.Entry<String, ApiResponse>> responses;
    private Set<Map.Entry<String, Callback>> callbacks;
    private List<SecurityRequirement> security;
    private List<String> methods;
    private final List<String> allMethods = Arrays.asList("HEAD", "OPTIONS", "PATCH", "DELETE", "POST", "PUT", "GET");

    public BallerinaOperation() {
        this.responses = new LinkedHashSet<Map.Entry<String, ApiResponse>>();
        this.callbacks = new LinkedHashSet<Map.Entry<String, Callback>>();
    }

    @Override
    public BallerinaOperation buildContext(Operation operation, OpenAPI openAPI) throws BallerinaOpenApiException {
        if (operation == null) {
            return this.getDefaultValue();
        }
        this.operationId = CodegenUtils.normalizeForBIdentifier(operation.getOperationId());
        this.tags = operation.getTags();
        this.summary = operation.getSummary();
        this.description = operation.getDescription();
        this.externalDocs = operation.getExternalDocs();
        this.security = operation.getSecurity();
        this.pathParameters = new ArrayList<BallerinaParameter>();
        this.queryParameters = new ArrayList<BallerinaParameter>();
        this.methods = null;
        this.requestBody = new BallerinaRequestBody().buildContext(operation.getRequestBody(), openAPI);
        if (operation.getResponses() != null) {
            operation.getResponses().forEach((name, response) -> this.responses.add(new AbstractMap.SimpleEntry<String, ApiResponse>((String)name, (ApiResponse)response)));
        }
        if (operation.getCallbacks() != null) {
            operation.getCallbacks().forEach((name, callback) -> this.callbacks.add(new AbstractMap.SimpleEntry<String, Callback>((String)name, (Callback)callback)));
        }
        if (operation.getParameters() != null) {
            for (Parameter parameter : operation.getParameters()) {
                if (parameter.getIn().equals("path")) {
                    this.pathParameters.add(new BallerinaParameter().buildContext(parameter, openAPI));
                    continue;
                }
                if (!parameter.getIn().equals("query")) continue;
                this.queryParameters.add(new BallerinaParameter().buildContext(parameter, openAPI));
            }
        }
        return this;
    }

    @Override
    public BallerinaOperation buildContext(Operation operation) throws BallerinaOpenApiException {
        return this.buildContext(operation, (OpenAPI)null);
    }

    public BallerinaOperation buildXContext(Object xObj) {
        LinkedHashMap extension = (LinkedHashMap)xObj;
        Object operationId = extension.get("operationId");
        Object tags = extension.get("tags");
        Object summary = extension.get("summary");
        Object description = extension.get("description");
        Object xMethodsObj = extension.get("x-METHODS");
        this.queryParameters = new ArrayList<BallerinaParameter>();
        this.pathParameters = new ArrayList<BallerinaParameter>();
        if (operationId != null) {
            this.operationId = CodegenUtils.normalizeForBIdentifier(operationId.toString());
        }
        if (tags != null && tags instanceof ArrayList) {
            this.tags = (ArrayList)tags;
        }
        if (summary != null) {
            this.summary = summary.toString();
        }
        if (description != null) {
            this.description = description.toString();
        }
        if (xMethodsObj != null && xMethodsObj instanceof ArrayList) {
            this.methods = (ArrayList)xMethodsObj;
        }
        return this;
    }

    @Override
    public BallerinaOperation getDefaultValue() {
        return new BallerinaOperation();
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getDescription() {
        return this.description;
    }

    public ExternalDocumentation getExternalDocs() {
        return this.externalDocs;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public List<BallerinaParameter> getQueryParameters() {
        return this.queryParameters;
    }

    public List<BallerinaParameter> getPathParameters() {
        return this.pathParameters;
    }

    public BallerinaRequestBody getRequestBody() {
        return this.requestBody;
    }

    public Set<Map.Entry<String, ApiResponse>> getResponses() {
        return this.responses;
    }

    public Set<Map.Entry<String, Callback>> getCallbacks() {
        return this.callbacks;
    }

    public List<SecurityRequirement> getSecurity() {
        return this.security;
    }

    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public List<String> getMethods() {
        return this.methods;
    }

    public List<String> getAllMethods() {
        return this.allMethods;
    }
}

