/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.openapi.model;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import java.io.PrintStream;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.ballerinalang.openapi.exception.BallerinaOpenApiException;
import org.ballerinalang.openapi.model.BallerinaOpenApi;
import org.ballerinalang.openapi.model.BallerinaOpenApiObject;
import org.ballerinalang.openapi.model.BallerinaOperation;
import org.ballerinalang.openapi.model.OperationCategory;
import org.ballerinalang.openapi.utils.CodegenUtils;

public class BallerinaPath
implements BallerinaOpenApiObject<BallerinaPath, PathItem> {
    private String ref;
    private String summary;
    private String resourceName;
    private boolean noOperationsForPath;
    private boolean sameResourceOperationExists = false;
    private String description;
    private Set<Map.Entry<String, BallerinaOperation>> operations = new LinkedHashSet<Map.Entry<String, BallerinaOperation>>();
    private Set<Map.Entry<String, OperationCategory>> sameResourceOperations = new LinkedHashSet<Map.Entry<String, OperationCategory>>();
    private static final PrintStream outStream = System.err;

    @Override
    public BallerinaPath buildContext(PathItem item, OpenAPI openAPI) throws BallerinaOpenApiException {
        this.ref = item.get$ref();
        this.summary = item.getSummary();
        this.description = item.getDescription();
        HashMap<String, OperationCategory> categorizedOperations = new HashMap<String, OperationCategory>();
        Map operationMap = item.readOperationsMap();
        for (Map.Entry operationI : operationMap.entrySet()) {
            AbstractMap.SimpleEntry<String, BallerinaOperation> entry;
            String operationIId = ((Operation)operationI.getValue()).getOperationId();
            boolean idMatched = false;
            if (operationIId != null) {
                for (Map.Entry operationJ : operationMap.entrySet()) {
                    String operationJId = ((Operation)operationJ.getValue()).getOperationId();
                    if (operationIId.equals(operationJId) || !CodegenUtils.normalizeForBIdentifier(operationIId).equals(CodegenUtils.normalizeForBIdentifier(operationJId))) continue;
                    idMatched = true;
                }
            }
            if (((Operation)operationI.getValue()).getOperationId() == null) {
                String resName = CodegenUtils.generateOperationId(openAPI);
                String pathName = BallerinaOpenApi.getPathName();
                ((Operation)operationI.getValue()).setOperationId(resName);
                outStream.println("warning : `" + resName + "` is used as the resource name since the operation id is missing for " + pathName + " " + operationI.getKey());
            }
            BallerinaOperation operation = new BallerinaOperation().buildContext((Operation)operationI.getValue(), openAPI);
            if (idMatched) {
                entry = new AbstractMap.SimpleEntry<String, BallerinaOperation>(((PathItem.HttpMethod)operationI.getKey()).name(), operation);
                if (categorizedOperations.get(CodegenUtils.normalizeForBIdentifier(operationIId)) != null) {
                    ((OperationCategory)categorizedOperations.get(CodegenUtils.normalizeForBIdentifier(operationIId))).addOperation(entry);
                    ((OperationCategory)categorizedOperations.get(CodegenUtils.normalizeForBIdentifier(operationIId))).addMethod(((PathItem.HttpMethod)operationI.getKey()).name());
                    continue;
                }
                categorizedOperations.put(CodegenUtils.normalizeForBIdentifier(operationIId), new OperationCategory(CodegenUtils.normalizeForBIdentifier(operationIId)));
                ((OperationCategory)categorizedOperations.get(CodegenUtils.normalizeForBIdentifier(operationIId))).addOperation(entry);
                ((OperationCategory)categorizedOperations.get(CodegenUtils.normalizeForBIdentifier(operationIId))).addMethod(((PathItem.HttpMethod)operationI.getKey()).name());
                continue;
            }
            entry = new AbstractMap.SimpleEntry<String, BallerinaOperation>(((PathItem.HttpMethod)operationI.getKey()).name(), operation);
            this.operations.add(entry);
        }
        this.sameResourceOperations = categorizedOperations.entrySet();
        this.setSameResourceOperationExists(!this.sameResourceOperations.isEmpty());
        this.setNoOperationsForPath(operationMap.isEmpty());
        return this;
    }

    @Override
    public BallerinaPath buildContext(PathItem item) throws BallerinaOpenApiException {
        return this.buildContext(item, (OpenAPI)null);
    }

    @Override
    public BallerinaPath getDefaultValue() {
        return null;
    }

    public String getRef() {
        return this.ref;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<Map.Entry<String, BallerinaOperation>> getOperations() {
        return this.operations;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = CodegenUtils.normalizeForBIdentifier(resourceName);
    }

    public boolean isNoOperationsForPath() {
        return this.noOperationsForPath;
    }

    private void setNoOperationsForPath(boolean noOperationsForPath) {
        this.noOperationsForPath = noOperationsForPath;
    }

    private void setSameResourceOperationExists(boolean sameResourceOperationExists) {
        this.sameResourceOperationExists = sameResourceOperationExists;
    }

    public boolean isSameResourceOperationExists() {
        return this.sameResourceOperationExists;
    }
}

