/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.openapi.model;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.util.AbstractMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.openapi.exception.BallerinaOpenApiException;
import org.ballerinalang.openapi.model.BallerinaMediaType;
import org.ballerinalang.openapi.model.BallerinaOpenApiObject;

public class BallerinaRequestBody
implements BallerinaOpenApiObject<BallerinaRequestBody, RequestBody> {
    private String description;
    private Set<Map.Entry<String, BallerinaMediaType>> content;
    private Boolean required;
    private Map<String, Object> extensions;
    private String ref;
    private BallerinaMediaType selectedMedia;

    @Override
    public BallerinaRequestBody buildContext(RequestBody body) throws BallerinaOpenApiException {
        return this.buildContext(body, (OpenAPI)null);
    }

    @Override
    public BallerinaRequestBody buildContext(RequestBody body, OpenAPI openAPI) throws BallerinaOpenApiException {
        if (body == null || openAPI == null) {
            return this.getDefaultValue();
        }
        if (body.getContent() == null) {
            throw new BallerinaOpenApiException("RequestBody content cannot be null");
        }
        if (!StringUtils.isEmpty((CharSequence)body.get$ref())) {
            String refType = this.getReferenceType(body.get$ref());
            body = (RequestBody)openAPI.getComponents().getRequestBodies().get(refType);
        }
        this.description = body.getDescription();
        this.required = body.getRequired();
        this.extensions = body.getExtensions();
        this.ref = body.get$ref();
        this.content = new LinkedHashSet<Map.Entry<String, BallerinaMediaType>>();
        int i = 0;
        for (Map.Entry m : body.getContent().entrySet()) {
            BallerinaMediaType bMedia = new BallerinaMediaType().buildContext((MediaType)m.getValue(), openAPI);
            bMedia.setMediaType((String)m.getKey());
            String bType = this.getRequestBType((String)m.getKey());
            if (bType != null) {
                bMedia.getSchema().setType(bType);
            }
            AbstractMap.SimpleEntry entry = new AbstractMap.SimpleEntry(m.getKey(), bMedia);
            if (i == 0) {
                this.selectedMedia = bMedia;
            }
            this.content.add(entry);
            ++i;
        }
        return this;
    }

    private String getRequestBType(String mType) {
        String type = null;
        if (mType == null) {
            type = null;
        } else if ("text/plain".equals(mType)) {
            type = "string";
        } else if ("application/octet-stream".equals(mType)) {
            type = "blob";
        } else if (mType.endsWith("/json") || mType.endsWith("+json")) {
            type = null;
        } else if (mType.endsWith("/xml") || mType.endsWith("+xml")) {
            type = "xml";
        } else if (mType.startsWith("multipart/")) {
            type = "mime:Entity[]";
        }
        return type;
    }

    @Override
    public BallerinaRequestBody getDefaultValue() {
        return null;
    }

    private String getReferenceType(String refPath) {
        return refPath.substring(refPath.lastIndexOf("/") + 1);
    }

    public String getDescription() {
        return this.description;
    }

    public Set<Map.Entry<String, BallerinaMediaType>> getContent() {
        return this.content;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public String getRef() {
        return this.ref;
    }

    public BallerinaMediaType getSelectedMedia() {
        return this.selectedMedia;
    }
}

