/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.openapi.model;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BinarySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.ByteArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.EmailSchema;
import io.swagger.v3.oas.models.media.FileSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.PasswordSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.ballerinalang.openapi.exception.BallerinaOpenApiException;
import org.ballerinalang.openapi.model.BallerinaOpenApiObject;
import org.ballerinalang.openapi.utils.GeneratorConstants;

public class BallerinaSchema
implements BallerinaOpenApiObject<BallerinaSchema, Schema> {
    private static final String LIST_SUFFIX = "List";
    private static final String UNSUPPORTED_PROPERTY_MSG = "// Unsupported Property Found.";
    private Schema oasSchema;
    private String type;
    private boolean isComposed;
    private Set<Map.Entry<String, Schema>> properties;

    @Override
    public BallerinaSchema buildContext(Schema schema, OpenAPI openAPI) throws BallerinaOpenApiException {
        this.oasSchema = schema;
        if (schema instanceof ArraySchema) {
            this.extractArraySchema((ArraySchema)schema);
            return this;
        }
        if (schema instanceof ComposedSchema) {
            this.extractComposedSchema((ComposedSchema)schema, openAPI);
            return this;
        }
        if (this.isValueTypeSchema(schema)) {
            this.type = this.getPropertyType(schema);
            return this;
        }
        if (schema.get$ref() != null) {
            String refType = this.getReferenceType(schema.get$ref());
            schema = (Schema)openAPI.getComponents().getSchemas().get(refType);
            if (schema == null) {
                throw new BallerinaOpenApiException("Reference schema " + refType + " not found.");
            }
            BallerinaSchema concreteSchema = new BallerinaSchema().buildContext(schema, openAPI);
            concreteSchema.setType(refType);
            return concreteSchema;
        }
        if (schema.getProperties() == null) {
            if (schema.getType() == null) {
                throw new BallerinaOpenApiException("Unsupported schema type in schema: " + schema.getName());
            }
            this.type = this.getPropertyType(schema);
            return this;
        }
        Set entries = schema.getProperties().entrySet();
        LinkedHashSet<Map.Entry<String, Schema>> newEntries = new LinkedHashSet<Map.Entry<String, Schema>>();
        for (Map.Entry entry : entries) {
            String name;
            Schema prop = (Schema)entry.getValue();
            if (prop.get$ref() != null) {
                String type = this.getReferenceType(prop.get$ref());
                type = type.isEmpty() ? UNSUPPORTED_PROPERTY_MSG : type;
                name = this.toPropertyName((String)entry.getKey());
                prop.setType(type);
                newEntries.add(new AbstractMap.SimpleEntry<String, Schema>(name, prop));
                continue;
            }
            name = this.toPropertyName((String)entry.getKey());
            prop.setType(this.getPropertyType(prop));
            newEntries.add(new AbstractMap.SimpleEntry<String, Schema>(name, prop));
        }
        this.properties = newEntries;
        return this;
    }

    @Override
    public BallerinaSchema buildContext(Schema schema) throws BallerinaOpenApiException {
        return this.buildContext(schema, (OpenAPI)null);
    }

    @Override
    public BallerinaSchema getDefaultValue() {
        return null;
    }

    private String getReferenceType(String refPath) {
        return refPath.substring(refPath.lastIndexOf("/") + 1);
    }

    private String getPropertyType(Schema prop) {
        String type;
        String check = prop.getType();
        if (prop instanceof ComposedSchema) {
            if (prop.getType() == null) {
                check = "json";
            }
        } else {
            check = prop.getType();
        }
        switch (check) {
            case "integer": {
                type = "int";
                break;
            }
            case "number": {
                type = "float";
                break;
            }
            case "array": {
                String ref = null;
                if (prop instanceof ArraySchema) {
                    ref = ((ArraySchema)prop).getItems().get$ref();
                }
                type = ref == null ? this.getPropertyType(((ArraySchema)prop).getItems()) : this.getReferenceType(ref);
                type = type + "[]";
                break;
            }
            case "object": {
                type = "any";
                break;
            }
            case "json": {
                type = "json";
                break;
            }
            default: {
                type = prop.getType();
            }
        }
        return type;
    }

    private void extractArraySchema(ArraySchema schema) {
        this.properties = new LinkedHashSet<Map.Entry<String, Schema>>();
        Schema propSchema = new Schema();
        String type = schema.getItems().get$ref() != null ? this.getReferenceType(schema.getItems().get$ref()) : schema.getItems().getType();
        String name = type.toLowerCase(Locale.ENGLISH) + LIST_SUFFIX;
        name = this.toPropertyName(name);
        type = type.isEmpty() ? UNSUPPORTED_PROPERTY_MSG : type + "[]";
        propSchema.setType(type);
        this.type = type;
        AbstractMap.SimpleEntry<String, Schema> entry = new AbstractMap.SimpleEntry<String, Schema>(name, propSchema);
        this.properties.add(entry);
    }

    private void extractComposedSchema(ComposedSchema cSchema, OpenAPI openAPI) throws BallerinaOpenApiException {
        this.properties = new LinkedHashSet<Map.Entry<String, Schema>>();
        this.isComposed = true;
        List allOf = cSchema.getAllOf();
        ArrayList<BallerinaSchema> childSchemas = new ArrayList<BallerinaSchema>();
        if (allOf != null) {
            for (Schema schema2 : allOf) {
                childSchemas.add(new BallerinaSchema().buildContext(schema2, openAPI));
            }
            childSchemas.forEach(schema -> {
                if (schema.getProperties() != null) {
                    this.properties.addAll(schema.getProperties());
                }
            });
        }
    }

    private String toPropertyName(String origName) {
        String escapedName = origName;
        boolean isKeyword = GeneratorConstants.RESERVED_KEYWORDS.stream().anyMatch(key -> key.equals(origName));
        if (isKeyword) {
            escapedName = '_' + origName;
        }
        escapedName = escapedName.replaceAll("[^a-zA-Z0-9_]+", "_");
        return escapedName;
    }

    private boolean isValueTypeSchema(Schema schema) {
        return schema instanceof BinarySchema || schema instanceof BooleanSchema || schema instanceof ByteArraySchema || schema instanceof DateSchema || schema instanceof DateTimeSchema || schema instanceof EmailSchema || schema instanceof FileSchema || schema instanceof IntegerSchema || schema instanceof BooleanSchema || schema instanceof MapSchema || schema instanceof NumberSchema || schema instanceof PasswordSchema || schema instanceof StringSchema;
    }

    public Schema getOasSchema() {
        return this.oasSchema;
    }

    public Set<Map.Entry<String, Schema>> getProperties() {
        return this.properties;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isComposed() {
        return this.isComposed;
    }
}

