/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.openapi.model;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.servers.ServerVariable;
import io.swagger.v3.oas.models.servers.ServerVariables;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.ballerinalang.openapi.exception.BallerinaOpenApiException;
import org.ballerinalang.openapi.model.BallerinaOpenApiObject;

public class BallerinaServer
implements BallerinaOpenApiObject<BallerinaServer, Server> {
    private static final int HTTP_PORT = 80;
    private static final int HTTPS_PORT = 443;
    private String host;
    private int port;
    private String basePath;
    private String description;
    private Server server;

    @Override
    public BallerinaServer buildContext(Server server) throws BallerinaOpenApiException {
        this.server = server;
        if (server == null || "/".equals(server.getUrl())) {
            return this.getDefaultValue();
        }
        this.description = server.getDescription();
        try {
            String resolvedUrl = this.buildUrl(server.getUrl(), server.getVariables());
            URL url = new URL(resolvedUrl);
            this.host = url.getHost();
            this.basePath = url.getPath();
            this.port = url.getPort();
            boolean isHttps = "https".equalsIgnoreCase(url.getProtocol());
            this.port = isHttps ? (this.port == -1 ? 443 : this.port) : (this.port == -1 ? 80 : this.port);
        }
        catch (MalformedURLException e) {
            throw new BallerinaOpenApiException("Failed to read endpoint details of the server: " + server.getUrl(), e);
        }
        return this;
    }

    @Override
    public BallerinaServer buildContext(Server server, OpenAPI openAPI) throws BallerinaOpenApiException {
        return this.buildContext(server);
    }

    @Override
    public BallerinaServer getDefaultValue() {
        this.host = null;
        this.port = 9090;
        this.basePath = "/";
        return this;
    }

    private String buildUrl(String absUrl, ServerVariables variables) {
        String url = absUrl;
        if (variables != null) {
            for (Map.Entry entry : variables.entrySet()) {
                String replaceKey = "\\{" + (String)entry.getKey() + '}';
                url = url.replaceAll(replaceKey, ((ServerVariable)entry.getValue()).getDefault());
            }
        }
        return url;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getDescription() {
        return this.description;
    }

    public Server getServer() {
        return this.server;
    }
}

