/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.openapi.typemodel;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.openapi.exception.BallerinaOpenApiException;
import org.ballerinalang.openapi.model.BallerinaServer;
import org.ballerinalang.openapi.typemodel.BallerinaOpenApiComponent;
import org.ballerinalang.openapi.typemodel.BallerinaOpenApiPath;

public class BallerinaOpenApiType {
    private String balModule;
    private String balServiceName;
    private String defPath;
    private List<BallerinaServer> servers = new ArrayList<BallerinaServer>();
    private List<Tag> tags;
    private List<BallerinaOpenApiPath> pathList;
    private BallerinaOpenApiComponent component;

    public BallerinaOpenApiComponent getComponent() {
        return this.component;
    }

    public void setComponent(BallerinaOpenApiComponent component) {
        this.component = component;
    }

    public List<BallerinaServer> getServers() {
        return this.servers;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public String getBalModule() {
        return this.balModule;
    }

    public void setBalModule(String balModule) {
        this.balModule = balModule;
    }

    public String getBalServiceName() {
        return this.balServiceName;
    }

    public void setBalServiceName(String balServiceName) {
        this.balServiceName = balServiceName;
    }

    public String getDefPath() {
        return this.defPath;
    }

    public void setDefPath(String defPath) {
        this.defPath = defPath;
    }

    public List<BallerinaOpenApiPath> getPathList() {
        return this.pathList;
    }

    public void setPathList(List<BallerinaOpenApiPath> pathList) {
        this.pathList = pathList;
    }

    public void setServers(OpenAPI openAPI) throws BallerinaOpenApiException {
        List serverList = openAPI.getServers();
        if (serverList == null) {
            BallerinaServer server2 = new BallerinaServer().getDefaultValue();
            this.servers.add(server2);
            return;
        }
        serverList.forEach(server -> {
            try {
                BallerinaServer balServer = new BallerinaServer().buildContext((Server)server);
                this.servers.add(balServer);
            }
            catch (BallerinaOpenApiException e) {
                this.servers.add(new BallerinaServer().getDefaultValue());
            }
        });
    }
}

