/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.openapi.utils;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import javax.annotation.Nullable;

public class CodegenUtils {
    public static boolean isBallerinaProject(Path path) {
        boolean isProject = false;
        Path cachePath = path.resolve("Ballerina.toml");
        if (Files.exists(cachePath, new LinkOption[0])) {
            isProject = true;
        }
        return isProject;
    }

    public static Path getSourcePath(String pkg, String path) {
        return pkg == null || pkg.isEmpty() ? Paths.get(path, new String[0]).resolve("src") : Paths.get(path, new String[0]).resolve("src").resolve(Paths.get(pkg, new String[0]));
    }

    public static Path getImplPath(String pkg, Path srcPath) {
        return pkg == null || pkg.isEmpty() ? srcPath : srcPath.getParent();
    }

    public static void writeFile(Path filePath, String content) throws IOException {
        try (PrintWriter writer = null;){
            writer = new PrintWriter(filePath.toString(), "UTF-8");
            writer.print(content);
        }
    }

    public static String normalizeForBIdentifier(@Nullable String identifier) {
        if (identifier == null) {
            return null;
        }
        String resourceName = identifier;
        if (identifier.split("-").length > 0) {
            String[] spllitedIdentifier = identifier.split("-");
            resourceName = spllitedIdentifier[spllitedIdentifier.length - 1];
        }
        return resourceName.replaceAll(" ", "_").replaceAll("-", "").replaceAll("/", "");
    }

    public static String generateOperationId(OpenAPI openAPI) {
        int prevNumber = 0;
        for (Map.Entry path : openAPI.getPaths().entrySet()) {
            for (Operation operation : ((PathItem)path.getValue()).readOperations()) {
                int number;
                String[] numbers;
                String operationId = operation.getOperationId();
                if (operationId == null || !operationId.matches("resource\\d+") || (numbers = operationId.split("resource")).length <= 0 || prevNumber >= (number = Integer.parseInt(numbers[numbers.length - 1]))) continue;
                prevNumber = number;
            }
        }
        return "resource" + (prevNumber + 1);
    }
}

