/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.coordination;

import io.ballerina.messaging.broker.common.StartupContext;
import io.ballerina.messaging.broker.common.config.BrokerConfigProvider;
import io.ballerina.messaging.broker.coordination.BrokerHaConfiguration;
import io.ballerina.messaging.broker.coordination.HaStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HaStrategyFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(HaStrategyFactory.class);

    public static HaStrategy getHaStrategy(StartupContext startupContext) throws Exception {
        BrokerConfigProvider brokerConfigProvider = (BrokerConfigProvider)startupContext.getService(BrokerConfigProvider.class);
        BrokerHaConfiguration brokerHaConfiguration = (BrokerHaConfiguration)brokerConfigProvider.getConfigurationObject("ballerina.broker.failover", BrokerHaConfiguration.class);
        startupContext.registerService(BrokerHaConfiguration.class, (Object)brokerHaConfiguration);
        if (!brokerHaConfiguration.isEnabled()) {
            return null;
        }
        String haStrategyClass = brokerHaConfiguration.getStrategy();
        LOGGER.info("Initializing HA Strategy: {}", (Object)haStrategyClass);
        HaStrategy haStrategy = (HaStrategy)ClassLoader.getSystemClassLoader().loadClass(haStrategyClass).newInstance();
        haStrategy.setup(startupContext);
        startupContext.registerService(HaStrategy.class, (Object)haStrategy);
        return haStrategy;
    }
}

