/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.coordination.rdbms;

import io.ballerina.messaging.broker.common.StartupContext;
import io.ballerina.messaging.broker.coordination.AbstractHaStrategy;
import io.ballerina.messaging.broker.coordination.BrokerHaConfiguration;
import io.ballerina.messaging.broker.coordination.rdbms.RdbmsCoordinationDaoImpl;
import io.ballerina.messaging.broker.coordination.rdbms.RdbmsCoordinationListener;
import io.ballerina.messaging.broker.coordination.rdbms.RdbmsCoordinationStrategy;
import javax.sql.DataSource;

public class RdbmsHaStrategy
extends AbstractHaStrategy
implements RdbmsCoordinationListener {
    private RdbmsCoordinationStrategy rdbmsCoordinationStrategy;

    @Override
    public void setup(StartupContext startupContext) throws Exception {
        DataSource dataSource = (DataSource)startupContext.getService(DataSource.class);
        BrokerHaConfiguration brokerHaConfiguration = (BrokerHaConfiguration)startupContext.getService(BrokerHaConfiguration.class);
        this.rdbmsCoordinationStrategy = new RdbmsCoordinationStrategy(new RdbmsCoordinationDaoImpl(dataSource), brokerHaConfiguration.getOptions());
        this.rdbmsCoordinationStrategy.addCoordinationListener(this);
    }

    @Override
    public void start() {
        this.rdbmsCoordinationStrategy.start();
    }

    @Override
    public boolean isActiveNode() {
        return this.rdbmsCoordinationStrategy.isCoordinator();
    }

    @Override
    public void stop() {
        super.stop();
        this.rdbmsCoordinationStrategy.stop();
    }

    public void pause() {
        this.rdbmsCoordinationStrategy.pause();
    }

    public void resume() {
        this.rdbmsCoordinationStrategy.resume();
    }

    @Override
    public void becameCoordinatorNode() {
        this.notifyBecameActiveNode();
    }

    @Override
    public void lostCoordinatorState() {
        this.notifyBecamePassiveNode();
    }
}

