/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.websub;

import java.util.ArrayList;
import org.ballerinalang.jvm.types.AttachedFunction;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.net.http.HttpResource;
import org.ballerinalang.net.http.HttpService;
import org.ballerinalang.net.uri.DispatcherUtil;
import org.ballerinalang.net.websub.WebSubHttpResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSubHttpService
extends HttpService {
    private static final Logger logger = LoggerFactory.getLogger(WebSubHttpService.class);
    private String topic;

    private WebSubHttpService(ObjectValue service) {
        super(service);
    }

    private static MapValue getWebSubSubscriberServiceConfigAnnotation(ObjectValue service) {
        return WebSubHttpService.getServiceConfigAnnotation((ObjectValue)service, (String)"ballerina/websub", (String)"SubscriberServiceConfig");
    }

    static WebSubHttpService buildWebSubSubscriberHttpService(ObjectValue service) {
        WebSubHttpService websubHttpService = new WebSubHttpService(service);
        MapValue serviceConfigAnnotation = WebSubHttpService.getWebSubSubscriberServiceConfigAnnotation(service);
        if (!serviceConfigAnnotation.containsKey((Object)"path")) {
            logger.debug("'path' not specified in the service config annotation, using the default base path");
            websubHttpService.setBasePath("/".concat(websubHttpService.getName()));
        } else {
            websubHttpService.setBasePath(serviceConfigAnnotation.getStringValue("path"));
        }
        ArrayList<HttpResource> resources = new ArrayList<HttpResource>();
        for (AttachedFunction resource : websubHttpService.getBalService().getType().getAttachedFunctions()) {
            HttpResource httpResource = WebSubHttpResource.buildWebSubHttpResource(resource, websubHttpService);
            resources.add(httpResource);
        }
        websubHttpService.setResources(resources);
        websubHttpService.setAllAllowedMethods(DispatcherUtil.getAllResourceMethods((HttpService)websubHttpService));
        websubHttpService.setHostName("b7a.default");
        return websubHttpService;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }
}

