/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.ldap.nativeimpl;

import java.nio.charset.StandardCharsets;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapContext;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.stdlib.ldap.CommonLdapConfiguration;
import org.ballerinalang.stdlib.ldap.LdapConnectionContext;
import org.ballerinalang.stdlib.ldap.util.LdapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Authenticate {
    private static final Logger LOG = LoggerFactory.getLogger(Authenticate.class);
    private static LdapConnectionContext connectionSource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object doAuthenticate(MapValue<?, ?> ldapConnection, String userName, String password) {
        if (userName == null || userName.isEmpty()) {
            return LdapUtils.createError("Username is null or empty.");
        }
        byte[] credential = password.getBytes(StandardCharsets.UTF_8);
        connectionSource = (LdapConnectionContext)ldapConnection.getNativeData("connectionSource");
        DirContext ldapConnectionContext = (DirContext)ldapConnection.getNativeData("connectionContext");
        CommonLdapConfiguration ldapConfiguration = (CommonLdapConfiguration)ldapConnection.getNativeData("ldapConfiguration");
        LdapUtils.setServiceName((String)ldapConnection.getNativeData("instanceId"));
        try {
            String name;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Authenticating user " + userName);
            }
            if ((name = LdapUtils.getNameInSpaceForUsernameFromLDAP(userName.trim(), ldapConfiguration, ldapConnectionContext)) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Authenticating with " + name);
                }
                Boolean bl = Authenticate.bindAsUser(name, credential);
                return bl;
            }
            Boolean bl = false;
            return bl;
        }
        catch (NamingException e) {
            LOG.error("Cannot bind user: " + userName, (Throwable)e);
            ErrorValue errorValue = LdapUtils.createError(e.getMessage());
            return errorValue;
        }
        finally {
            LdapUtils.removeServiceName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean bindAsUser(String dn, byte[] credentials) throws NamingException {
        boolean authenticated;
        LdapContext cxt = null;
        try {
            cxt = connectionSource.getContextWithCredentials(dn, credentials);
            authenticated = true;
        }
        catch (Throwable throwable) {
            LdapUtils.closeContext(cxt);
            throw throwable;
        }
        LdapUtils.closeContext(cxt);
        if (LOG.isDebugEnabled()) {
            LOG.debug("User: " + dn + " is authenticated: " + authenticated);
        }
        return authenticated;
    }
}

