/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.BallerinaClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.CodeGenerator;
import org.wso2.ballerinalang.compiler.bir.codegen.FunctionParamComparator;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmErrorGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmInstructionGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmLabelGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmObservabilityGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTerminatorGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.Nilable;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.ExternalMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.InteropMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JType;
import org.wso2.ballerinalang.compiler.bir.model.BIRInstruction;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIRNonTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BIROperand;
import org.wso2.ballerinalang.compiler.bir.model.BIRTerminator;
import org.wso2.ballerinalang.compiler.bir.model.InstructionKind;
import org.wso2.ballerinalang.compiler.bir.model.VarKind;
import org.wso2.ballerinalang.compiler.bir.model.VarScope;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNilType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BServiceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.TypeTags;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class JvmMethodGen {
    public static int nextId = -1;
    public static int nextVarId = -1;
    private static final FunctionParamComparator FUNCTION_PARAM_COMPARATOR = new FunctionParamComparator();
    static BUnionType errorOrNilType;

    static void generateMethod(BIRNode.BIRFunction birFunc, ClassWriter cw, BIRNode.BIRPackage birModule, @Nilable BType attachedType, boolean isService, String serviceName) {
        if (JvmMethodGen.isExternFunc(birFunc)) {
            ExternalMethodGen.genJMethodForBExternalFunc(birFunc, cw, birModule, attachedType);
        } else {
            JvmMethodGen.genJMethodForBFunc(birFunc, cw, birModule, isService, serviceName, attachedType);
        }
    }

    public static void genJMethodForBFunc(BIRNode.BIRFunction func, ClassWriter cw, BIRNode.BIRPackage module, boolean isService, String serviceName, @Nilable BType attachedType) {
        boolean isRemote;
        int localVarOffset;
        String currentPackageName = JvmPackageGen.getPackageName(module.org.value, module.name.value);
        BalToJVMIndexMap indexMap = new BalToJVMIndexMap();
        String funcName = JvmMethodGen.cleanupFunctionName(func.name.value);
        int returnVarRefIndex = -1;
        BIRNode.BIRVariableDcl strandVar = new BIRNode.BIRVariableDcl(JvmPackageGen.symbolTable.stringType, new Name("strand"), VarScope.FUNCTION, VarKind.ARG);
        int ignoreStrandVarIndex = indexMap.getIndex(strandVar);
        String desc = JvmMethodGen.getMethodDesc(func.type.paramTypes, func.type.retType, null, false);
        int access = 1;
        if (attachedType != null) {
            localVarOffset = 1;
            BIRNode.BIRVariableDcl selfVar = new BIRNode.BIRVariableDcl(JvmPackageGen.symbolTable.anyType, new Name("self"), VarScope.FUNCTION, VarKind.ARG);
            int n = indexMap.getIndex(selfVar);
        } else {
            localVarOffset = 0;
            access += 8;
        }
        MethodVisitor mv = cw.visitMethod(access, funcName, desc, null, null);
        JvmInstructionGen.InstructionGenerator instGen = new JvmInstructionGen.InstructionGenerator(mv, indexMap, module);
        JvmErrorGen.ErrorHandlerGenerator errorGen = new JvmErrorGen.ErrorHandlerGenerator(mv, indexMap, currentPackageName);
        JvmLabelGen.LabelGenerator labelGen = new JvmLabelGen.LabelGenerator();
        mv.visitCode();
        Label tryStart = null;
        boolean isObserved = false;
        boolean isWorker = (func.flags & 0x1000000) == 0x1000000;
        boolean bl = isRemote = (func.flags & 0x10000) == 65536;
        if ((isService || isRemote || isWorker) && !"__init".equals(funcName) && !"$__init$".equals(funcName)) {
            isObserved = true;
            tryStart = labelGen.getLabel("try-start");
            mv.visitLabel(tryStart);
        }
        Label methodStartLabel = new Label();
        mv.visitLabel(methodStartLabel);
        int k = 1;
        if (func.workerChannels.length > 0) {
            mv.visitVarInsn(25, localVarOffset);
            JvmTerminatorGen.loadChannelDetails(mv, Arrays.asList(func.workerChannels));
            mv.visitMethodInsn(182, "org/ballerinalang/jvm/scheduling/Strand", "updateChannelDetails", String.format("([L%s;)V", "org/ballerinalang/jvm/values/ChannelDetails"), false);
        }
        JvmMethodGen.checkStrandCancelled(mv, localVarOffset);
        func.localVars.sort(FUNCTION_PARAM_COMPARATOR);
        List<BIRNode.BIRVariableDcl> localVars = func.localVars;
        while (k < localVars.size()) {
            BIRNode.BIRVariableDcl localVar = JvmMethodGen.getVariableDcl(localVars.get(k));
            int index = indexMap.getIndex(localVar);
            if (localVar.kind != VarKind.ARG) {
                BType bType = localVar.type;
                JvmMethodGen.genDefaultValue(mv, bType, index);
            }
            ++k;
        }
        BIRNode.BIRVariableDcl varDcl = JvmMethodGen.getVariableDcl(localVars.get(0));
        returnVarRefIndex = indexMap.getIndex(varDcl);
        BType returnType = func.type.retType;
        JvmMethodGen.genDefaultValue(mv, returnType, returnVarRefIndex);
        BIRNode.BIRVariableDcl stateVar = new BIRNode.BIRVariableDcl(JvmPackageGen.symbolTable.stringType, new Name("state"), null, VarKind.TEMP);
        int stateVarIndex = indexMap.getIndex(stateVar);
        mv.visitInsn(3);
        mv.visitVarInsn(54, stateVarIndex);
        mv.visitVarInsn(25, localVarOffset);
        mv.visitFieldInsn(180, "org/ballerinalang/jvm/scheduling/Strand", "resumeIndex", "I");
        Label resumeLable = labelGen.getLabel(funcName + "resume");
        mv.visitJumpInsn(157, resumeLable);
        Label varinitLable = labelGen.getLabel(funcName + "varinit");
        mv.visitLabel(varinitLable);
        List<BIRNode.BIRBasicBlock> basicBlocks = func.basicBlocks;
        ArrayList<Label> lables = new ArrayList<Label>();
        ArrayList<Integer> states = new ArrayList<Integer>();
        int caseIndex = 0;
        for (int i = 0; i < basicBlocks.size(); ++i) {
            BIRNode.BIRBasicBlock bb = JvmMethodGen.getBasicBlock(basicBlocks.get(i));
            if (i == 0) {
                lables.add(caseIndex, labelGen.getLabel(funcName + bb.id.value));
                states.add(caseIndex, caseIndex);
                ++caseIndex;
            }
            lables.add(caseIndex, labelGen.getLabel(funcName + bb.id.value + "beforeTerm"));
            states.add(caseIndex, caseIndex);
            ++caseIndex;
        }
        JvmTerminatorGen.TerminatorGenerator termGen = new JvmTerminatorGen.TerminatorGenerator(mv, indexMap, labelGen, errorGen, module);
        mv.visitVarInsn(21, stateVarIndex);
        Label yieldLable = labelGen.getLabel(funcName + "yield");
        mv.visitLookupSwitchInsn(yieldLable, JvmMethodGen.toIntArray(states), lables.toArray(new Label[0]));
        JvmMethodGen.generateBasicBlocks(mv, basicBlocks, labelGen, errorGen, instGen, termGen, func, returnVarRefIndex, stateVarIndex, localVarOffset, false, module, currentPackageName, attachedType, isObserved, isService, serviceName);
        String frameName = JvmMethodGen.getFrameClassName(currentPackageName, funcName, attachedType);
        mv.visitLabel(resumeLable);
        mv.visitVarInsn(25, localVarOffset);
        mv.visitFieldInsn(180, "org/ballerinalang/jvm/scheduling/Strand", "frames", "[Ljava/lang/Object;");
        mv.visitVarInsn(25, localVarOffset);
        mv.visitInsn(89);
        mv.visitFieldInsn(180, "org/ballerinalang/jvm/scheduling/Strand", "resumeIndex", "I");
        mv.visitInsn(4);
        mv.visitInsn(100);
        mv.visitInsn(90);
        mv.visitFieldInsn(181, "org/ballerinalang/jvm/scheduling/Strand", "resumeIndex", "I");
        mv.visitInsn(50);
        mv.visitTypeInsn(192, frameName);
        JvmMethodGen.generateFrameClassFieldLoad(localVars, mv, indexMap, frameName);
        mv.visitFieldInsn(180, frameName, "state", "I");
        mv.visitVarInsn(54, stateVarIndex);
        mv.visitJumpInsn(167, varinitLable);
        mv.visitLabel(yieldLable);
        mv.visitTypeInsn(187, frameName);
        mv.visitInsn(89);
        mv.visitMethodInsn(183, frameName, "<init>", "()V", false);
        JvmMethodGen.generateFrameClassFieldUpdate(localVars, mv, indexMap, frameName);
        mv.visitInsn(89);
        mv.visitVarInsn(21, stateVarIndex);
        mv.visitFieldInsn(181, frameName, "state", "I");
        BIRNode.BIRVariableDcl frameVar = new BIRNode.BIRVariableDcl(JvmPackageGen.symbolTable.stringType, new Name("frame"), null, VarKind.TEMP);
        int frameVarIndex = indexMap.getIndex(frameVar);
        mv.visitVarInsn(58, frameVarIndex);
        mv.visitVarInsn(25, localVarOffset);
        mv.visitFieldInsn(180, "org/ballerinalang/jvm/scheduling/Strand", "frames", "[Ljava/lang/Object;");
        mv.visitVarInsn(25, localVarOffset);
        mv.visitInsn(89);
        mv.visitFieldInsn(180, "org/ballerinalang/jvm/scheduling/Strand", "resumeIndex", "I");
        mv.visitInsn(90);
        mv.visitInsn(4);
        mv.visitInsn(96);
        mv.visitFieldInsn(181, "org/ballerinalang/jvm/scheduling/Strand", "resumeIndex", "I");
        mv.visitVarInsn(25, frameVarIndex);
        mv.visitInsn(83);
        Label methodEndLabel = new Label();
        if (isObserved) {
            Label tryEnd = labelGen.getLabel("try-end");
            Label tryCatch = labelGen.getLabel("try-handler");
            mv.visitTryCatchBlock(tryStart, tryEnd, tryCatch, "org/ballerinalang/jvm/values/ErrorValue");
            Label tryFinally = labelGen.getLabel("try-finally");
            mv.visitTryCatchBlock(tryStart, tryEnd, tryFinally, null);
            Label tryCatchFinally = labelGen.getLabel("try-catch-finally");
            mv.visitTryCatchBlock(tryCatch, tryCatchFinally, tryFinally, null);
            BIRNode.BIRVariableDcl catchVarDcl = new BIRNode.BIRVariableDcl(JvmPackageGen.symbolTable.anyType, new Name("$_catch_$"), VarScope.FUNCTION, VarKind.ARG);
            int catchVarIndex = indexMap.getIndex(catchVarDcl);
            BIRNode.BIRVariableDcl throwableVarDcl = new BIRNode.BIRVariableDcl(JvmPackageGen.symbolTable.anyType, new Name("$_throwable_$"), VarScope.FUNCTION, VarKind.ARG);
            int throwableVarIndex = indexMap.getIndex(throwableVarDcl);
            mv.visitLabel(tryEnd);
            Label tryBlock1 = labelGen.getLabel("try-block-1");
            mv.visitLabel(tryBlock1);
            mv.visitJumpInsn(167, methodEndLabel);
            mv.visitLabel(tryCatch);
            mv.visitVarInsn(58, catchVarIndex);
            Label tryBlock2 = labelGen.getLabel("try-block-2");
            mv.visitLabel(tryBlock2);
            JvmObservabilityGen.emitReportErrorInvocation(mv, localVarOffset, catchVarIndex);
            mv.visitLabel(tryCatchFinally);
            JvmObservabilityGen.emitStopObservationInvocation(mv, localVarOffset);
            Label tryBlock3 = labelGen.getLabel("try-block-3");
            mv.visitLabel(tryBlock3);
            mv.visitVarInsn(25, catchVarIndex);
            mv.visitInsn(191);
            mv.visitLabel(tryFinally);
            mv.visitVarInsn(58, throwableVarIndex);
            JvmObservabilityGen.emitStopObservationInvocation(mv, localVarOffset);
            Label tryBlock4 = labelGen.getLabel("try-block-4");
            mv.visitLabel(tryBlock4);
            mv.visitVarInsn(25, throwableVarIndex);
            mv.visitInsn(191);
        }
        mv.visitLabel(methodEndLabel);
        termGen.genReturnTerm(new BIRTerminator.Return(null), returnVarRefIndex, func, false, -1);
        mv.visitLocalVariable("__strand", String.format("L%s;", "org/ballerinalang/jvm/scheduling/Strand"), null, methodStartLabel, methodEndLabel, localVarOffset);
        for (k = localVarOffset; k < localVars.size(); ++k) {
            String metaVarName;
            boolean tmpBoolParam;
            BIRNode.BIRVariableDcl localVar = JvmMethodGen.getVariableDcl(localVars.get(k));
            Label startLabel = methodStartLabel;
            Label endLabel = methodEndLabel;
            boolean bl2 = tmpBoolParam = localVar.type.tag == 6 && localVar.name.value.startsWith("%syn");
            if (tmpBoolParam || localVar.kind != VarKind.LOCAL && localVar.kind != VarKind.ARG) continue;
            if (localVar.kind == VarKind.LOCAL) {
                int insOffset = localVar.insOffset;
                if (localVar.startBB != null) {
                    startLabel = labelGen.getLabel(funcName + localVar.startBB.id.value + "ins" + insOffset);
                }
                if (localVar.endBB != null) {
                    endLabel = labelGen.getLabel(funcName + localVar.endBB.id.value + "beforeTerm");
                }
            }
            if ((metaVarName = localVar.metaVarName) == null || "".equals(metaVarName) || metaVarName.startsWith("$") && metaVarName.endsWith("$") || metaVarName.startsWith("$$") && metaVarName.endsWith("$$") || metaVarName.startsWith("_$$_")) continue;
            mv.visitLocalVariable(metaVarName, JvmMethodGen.getJVMTypeSign(localVar.type), null, startLabel, endLabel, indexMap.getIndex(localVar));
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static int[] toIntArray(List<Integer> states) {
        int[] ints = new int[states.size()];
        for (int i = 0; i < states.size(); ++i) {
            ints[i] = states.get(i);
        }
        return ints;
    }

    private static void generateFrameClassFieldLoad(List<BIRNode.BIRVariableDcl> localVars, MethodVisitor mv, BalToJVMIndexMap indexMap, String frameName) {
        for (int k = 0; k < localVars.size(); ++k) {
            BIRNode.BIRVariableDcl localVar = JvmMethodGen.getVariableDcl(localVars.get(k));
            int index = indexMap.getIndex(localVar);
            BType bType = localVar.type;
            mv.visitInsn(89);
            if (TypeTags.isIntegerTypeTag(bType.tag)) {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), "J");
                mv.visitVarInsn(55, index);
                continue;
            }
            if (bType.tag == 2) {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), "I");
                mv.visitVarInsn(54, index);
                continue;
            }
            if (bType.tag == 3) {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), "D");
                mv.visitVarInsn(57, index);
                continue;
            }
            if (TypeTags.isStringTypeTag(bType.tag)) {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", JvmInstructionGen.isBString ? "org/ballerinalang/jvm/values/api/BString" : "java/lang/String"));
                mv.visitVarInsn(58, index);
                continue;
            }
            if (bType.tag == 4) {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "org/ballerinalang/jvm/values/DecimalValue"));
                mv.visitVarInsn(58, index);
                continue;
            }
            if (bType.tag == 6) {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), "Z");
                mv.visitVarInsn(54, index);
                continue;
            }
            if (bType.tag == 15 || bType.tag == 12) {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "org/ballerinalang/jvm/values/MapValue"));
                mv.visitVarInsn(58, index);
                continue;
            }
            if (bType.tag == 9) {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "org/ballerinalang/jvm/values/TableValue"));
                mv.visitVarInsn(58, index);
                continue;
            }
            if (bType.tag == 14) {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "org/ballerinalang/jvm/values/StreamValue"));
                mv.visitVarInsn(58, index);
                continue;
            }
            if (bType.tag == 19 || bType.tag == 29) {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "org/ballerinalang/jvm/values/ArrayValue"));
                mv.visitVarInsn(58, index);
                continue;
            }
            if (bType.tag == 32) {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "org/ballerinalang/jvm/values/ObjectValue"));
                mv.visitVarInsn(58, index);
                continue;
            }
            if (bType.tag == 27) {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "org/ballerinalang/jvm/values/ErrorValue"));
                mv.visitVarInsn(58, index);
                continue;
            }
            if (bType.tag == 30) {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "org/ballerinalang/jvm/values/FutureValue"));
                mv.visitVarInsn(58, index);
                continue;
            }
            if (bType.tag == 16) {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "org/ballerinalang/jvm/values/FPValue"));
                mv.visitVarInsn(58, index);
                continue;
            }
            if (bType.tag == 13) {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "org/ballerinalang/jvm/values/TypedescValue"));
                mv.visitVarInsn(58, index);
                continue;
            }
            if (bType.tag == 10 || bType.tag == 17 || bType.tag == 11 || bType.tag == 20 || bType.tag == 7 || bType.tag == 31) {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "java/lang/Object"));
                mv.visitVarInsn(58, index);
                continue;
            }
            if (TypeTags.isXMLTypeTag(bType.tag)) {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "org/ballerinalang/jvm/values/XMLValue"));
                mv.visitVarInsn(58, index);
                continue;
            }
            if (bType.tag == 35) {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "org/ballerinalang/jvm/values/HandleValue"));
                mv.visitVarInsn(58, index);
                continue;
            }
            if (bType.tag == Integer.MAX_VALUE) {
                JvmMethodGen.generateFrameClassJFieldLoad(localVar, mv, index, frameName);
                continue;
            }
            throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", bType));
        }
    }

    private static void generateFrameClassJFieldLoad(BIRNode.BIRVariableDcl localVar, MethodVisitor mv, int index, String frameName) {
        JType jType = (JType)localVar.type;
        if (jType.jTag == 1) {
            mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), "I");
            mv.visitVarInsn(54, index);
        } else if (jType.jTag == 2) {
            mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), "I");
            mv.visitVarInsn(54, index);
        } else if (jType.jTag == 3) {
            mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), "I");
            mv.visitVarInsn(54, index);
        } else if (jType.jTag == 4) {
            mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), "I");
            mv.visitVarInsn(54, index);
        } else if (jType.jTag == 5) {
            mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), "J");
            mv.visitVarInsn(55, index);
        } else if (jType.jTag == 6) {
            mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), "F");
            mv.visitVarInsn(56, index);
        } else if (jType.jTag == 7) {
            mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), "D");
            mv.visitVarInsn(57, index);
        } else if (jType.jTag == 8) {
            mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), "Z");
            mv.visitVarInsn(54, index);
        } else if (jType.jTag == 9 || jType.jTag == 10) {
            mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), InteropMethodGen.getJTypeSignature(jType));
            mv.visitVarInsn(58, index);
        } else {
            throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", jType));
        }
    }

    private static void generateFrameClassFieldUpdate(@Nilable List<BIRNode.BIRVariableDcl> localVars, MethodVisitor mv, BalToJVMIndexMap indexMap, String frameName) {
        for (int k = 0; k < localVars.size(); ++k) {
            BIRNode.BIRVariableDcl localVar = JvmMethodGen.getVariableDcl(localVars.get(k));
            int index = indexMap.getIndex(localVar);
            mv.visitInsn(89);
            BType bType = localVar.type;
            if (TypeTags.isIntegerTypeTag(bType.tag)) {
                mv.visitVarInsn(22, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), "J");
                continue;
            }
            if (bType.tag == 2) {
                mv.visitVarInsn(21, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), "I");
                continue;
            }
            if (bType.tag == 3) {
                mv.visitVarInsn(24, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), "D");
                continue;
            }
            if (TypeTags.isStringTypeTag(bType.tag)) {
                mv.visitVarInsn(25, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", JvmInstructionGen.isBString ? "org/ballerinalang/jvm/values/api/BString" : "java/lang/String"));
                continue;
            }
            if (bType.tag == 4) {
                mv.visitVarInsn(25, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "org/ballerinalang/jvm/values/DecimalValue"));
                continue;
            }
            if (bType.tag == 6) {
                mv.visitVarInsn(21, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), "Z");
                continue;
            }
            if (bType.tag == 15 || bType.tag == 12) {
                mv.visitVarInsn(25, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "org/ballerinalang/jvm/values/MapValue"));
                continue;
            }
            if (bType.tag == 9) {
                mv.visitVarInsn(25, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "org/ballerinalang/jvm/values/TableValue"));
                continue;
            }
            if (bType.tag == 14) {
                mv.visitVarInsn(25, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "org/ballerinalang/jvm/values/StreamValue"));
                continue;
            }
            if (bType.tag == 19 || bType.tag == 29) {
                mv.visitVarInsn(25, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "org/ballerinalang/jvm/values/ArrayValue"));
                continue;
            }
            if (bType.tag == 27) {
                mv.visitVarInsn(25, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "org/ballerinalang/jvm/values/ErrorValue"));
                continue;
            }
            if (bType.tag == 30) {
                mv.visitVarInsn(25, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "org/ballerinalang/jvm/values/FutureValue"));
                continue;
            }
            if (bType.tag == 13) {
                mv.visitVarInsn(25, index);
                mv.visitTypeInsn(192, "org/ballerinalang/jvm/values/TypedescValue");
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "org/ballerinalang/jvm/values/TypedescValue"));
                continue;
            }
            if (bType.tag == 32) {
                mv.visitVarInsn(25, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "org/ballerinalang/jvm/values/ObjectValue"));
                continue;
            }
            if (bType.tag == 16) {
                mv.visitVarInsn(25, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "org/ballerinalang/jvm/values/FPValue"));
                continue;
            }
            if (bType.tag == 10 || bType.tag == 17 || bType.tag == 11 || bType.tag == 20 || bType.tag == 7 || bType.tag == 31) {
                mv.visitVarInsn(25, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "java/lang/Object"));
                continue;
            }
            if (TypeTags.isXMLTypeTag(bType.tag)) {
                mv.visitVarInsn(25, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "org/ballerinalang/jvm/values/XMLValue"));
                continue;
            }
            if (bType.tag == 35) {
                mv.visitVarInsn(25, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "org/ballerinalang/jvm/values/HandleValue"));
                continue;
            }
            if (bType.tag == Integer.MAX_VALUE) {
                JvmMethodGen.generateFrameClassJFieldUpdate(localVar, mv, index, frameName);
                continue;
            }
            throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", bType));
        }
    }

    private static void generateFrameClassJFieldUpdate(BIRNode.BIRVariableDcl localVar, MethodVisitor mv, int index, String frameName) {
        JType jType = (JType)localVar.type;
        if (jType.jTag == 1) {
            mv.visitVarInsn(21, index);
            mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), "B");
        } else if (jType.jTag == 2) {
            mv.visitVarInsn(21, index);
            mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), "C");
        } else if (jType.jTag == 3) {
            mv.visitVarInsn(21, index);
            mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), "S");
        } else if (jType.jTag == 4) {
            mv.visitVarInsn(21, index);
            mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), "I");
        } else if (jType.jTag == 5) {
            mv.visitVarInsn(22, index);
            mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), "J");
        } else if (jType.jTag == 6) {
            mv.visitVarInsn(23, index);
            mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), "F");
        } else if (jType.jTag == 7) {
            mv.visitVarInsn(24, index);
            mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), "D");
        } else if (jType.jTag == 8) {
            mv.visitVarInsn(21, index);
            mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), "Z");
        } else if (jType.jTag == 9 || jType.jTag == 10) {
            String classSig = InteropMethodGen.getJTypeSignature(jType);
            String className = InteropMethodGen.getSignatureForJType(jType);
            mv.visitVarInsn(25, index);
            mv.visitTypeInsn(192, className);
            mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), classSig);
        } else {
            throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", jType));
        }
    }

    private static String getJVMTypeSign(BType bType) {
        String jvmType = "";
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            jvmType = "J";
        } else if (bType.tag == 2) {
            jvmType = "I";
        } else if (bType.tag == 3) {
            jvmType = "D";
        } else if (bType.tag == 6) {
            jvmType = "Z";
        } else if (TypeTags.isStringTypeTag(bType.tag)) {
            jvmType = String.format("L%s;", "java/lang/String");
        } else if (bType.tag == 4) {
            jvmType = String.format("L%s;", "org/ballerinalang/jvm/values/DecimalValue");
        } else if (bType.tag == 15 || bType.tag == 12) {
            jvmType = String.format("L%s;", "org/ballerinalang/jvm/values/MapValue");
        } else if (bType.tag == 9) {
            jvmType = String.format("L%s;", "org/ballerinalang/jvm/values/TableValue");
        } else if (bType.tag == 14) {
            jvmType = String.format("L%s;", "org/ballerinalang/jvm/values/StreamValue");
        } else if (bType.tag == 19 || bType.tag == 29) {
            jvmType = String.format("L%s;", "org/ballerinalang/jvm/values/ArrayValue");
        } else if (bType.tag == 32) {
            jvmType = String.format("L%s;", "org/ballerinalang/jvm/values/ObjectValue");
        } else if (bType.tag == 27) {
            jvmType = String.format("L%s;", "org/ballerinalang/jvm/values/ErrorValue");
        } else if (bType.tag == 30) {
            jvmType = String.format("L%s;", "org/ballerinalang/jvm/values/FutureValue");
        } else if (bType.tag == 16) {
            jvmType = String.format("L%s;", "org/ballerinalang/jvm/values/FPValue");
        } else if (bType.tag == 35) {
            jvmType = String.format("L%s;", "org/ballerinalang/jvm/values/HandleValue");
        } else if (bType.tag == 13) {
            jvmType = String.format("L%s;", "org/ballerinalang/jvm/values/TypedescValue");
        } else if (bType.tag == 10 || bType.tag == 17 || bType.tag == 11 || bType.tag == 20 || bType.tag == 7 || bType.tag == 31) {
            jvmType = String.format("L%s;", "java/lang/Object");
        } else if (bType.tag == Integer.MAX_VALUE) {
            jvmType = InteropMethodGen.getJTypeSignature((JType)bType);
        } else if (TypeTags.isXMLTypeTag(bType.tag)) {
            jvmType = String.format("L%s;", "org/ballerinalang/jvm/values/XMLValue");
        } else {
            throw new BLangCompilerException("JVM code generation is not supported for type " + String.format("%s", bType));
        }
        return jvmType;
    }

    public static void generateBasicBlocks(MethodVisitor mv, @Nilable List<BIRNode.BIRBasicBlock> basicBlocks, JvmLabelGen.LabelGenerator labelGen, JvmErrorGen.ErrorHandlerGenerator errorGen, JvmInstructionGen.InstructionGenerator instGen, JvmTerminatorGen.TerminatorGenerator termGen, BIRNode.BIRFunction func, int returnVarRefIndex, int stateVarIndex, int localVarOffset, boolean isArg, BIRNode.BIRPackage module, String currentPackageName, @Nilable BType attachedType, boolean isObserved, boolean isService, String serviceName) {
        String funcName = JvmMethodGen.cleanupFunctionName(func.name.value);
        int caseIndex = 0;
        for (int j = 0; j < basicBlocks.size(); ++j) {
            BIRNode.BIRBasicBlock bb = JvmMethodGen.getBasicBlock(basicBlocks.get(j));
            String currentBBName = String.format("%s", bb.id.value);
            Label bbLabel = labelGen.getLabel(funcName + bb.id.value);
            mv.visitLabel(bbLabel);
            if (j == 0 && !isArg) {
                mv.visitIntInsn(17, caseIndex);
                mv.visitVarInsn(54, stateVarIndex);
                ++caseIndex;
            }
            String serviceOrConnectorName = serviceName;
            if (isObserved && j == 0) {
                String observationStartMethod;
                String string = observationStartMethod = isService ? "startResourceObservation" : "startCallableObservation";
                if (!isService && attachedType != null && attachedType.tag == 32) {
                    BObjectType attachedTypeObj = (BObjectType)attachedType;
                    serviceOrConnectorName = JvmObservabilityGen.getFullQualifiedRemoteFunctionName(attachedTypeObj.tsymbol.pkgID.orgName.value, attachedTypeObj.tsymbol.pkgID.name.value, serviceName);
                }
                JvmObservabilityGen.emitStartObservationInvocation(mv, localVarOffset, serviceOrConnectorName, funcName, observationStartMethod);
            }
            int m = 0;
            int insCount = bb.instructions.size();
            while (m < insCount) {
                Label insLabel = labelGen.getLabel(funcName + bb.id.value + "ins" + m);
                mv.visitLabel(insLabel);
                BIRInstruction inst = bb.instructions.get(m);
                if (inst == null) continue;
                InstructionKind insKind = inst.getKind();
                JvmMethodGen.generateDiagnosticPos(((BIRNode)((Object)inst)).pos, mv);
                if (inst instanceof BIRNonTerminator.BinaryOp) {
                    instGen.generateBinaryOpIns((BIRNonTerminator.BinaryOp)inst);
                } else {
                    switch (insKind) {
                        case MOVE: {
                            instGen.generateMoveIns((BIRNonTerminator.Move)inst);
                            break;
                        }
                        case CONST_LOAD: {
                            instGen.generateConstantLoadIns((BIRNonTerminator.ConstantLoad)inst);
                            break;
                        }
                        case NEW_STRUCTURE: {
                            instGen.generateMapNewIns((BIRNonTerminator.NewStructure)inst, localVarOffset);
                            break;
                        }
                        case NEW_INSTANCE: {
                            instGen.generateObjectNewIns((BIRNonTerminator.NewInstance)inst, localVarOffset);
                            break;
                        }
                        case MAP_STORE: {
                            instGen.generateMapStoreIns((BIRNonTerminator.FieldAccess)inst);
                            break;
                        }
                        case NEW_ARRAY: {
                            instGen.generateArrayNewIns((BIRNonTerminator.NewArray)inst);
                            break;
                        }
                        case ARRAY_STORE: {
                            instGen.generateArrayStoreIns((BIRNonTerminator.FieldAccess)inst);
                            break;
                        }
                        case MAP_LOAD: {
                            instGen.generateMapLoadIns((BIRNonTerminator.FieldAccess)inst);
                            break;
                        }
                        case ARRAY_LOAD: {
                            instGen.generateArrayValueLoad((BIRNonTerminator.FieldAccess)inst);
                            break;
                        }
                        case NEW_ERROR: {
                            instGen.generateNewErrorIns((BIRNonTerminator.NewError)inst);
                            break;
                        }
                        case TYPE_CAST: {
                            instGen.generateCastIns((BIRNonTerminator.TypeCast)inst);
                            break;
                        }
                        case IS_LIKE: {
                            instGen.generateIsLikeIns((BIRNonTerminator.IsLike)inst);
                            break;
                        }
                        case TYPE_TEST: {
                            instGen.generateTypeTestIns((BIRNonTerminator.TypeTest)inst);
                            break;
                        }
                        case OBJECT_STORE: {
                            instGen.generateObjectStoreIns((BIRNonTerminator.FieldAccess)inst);
                            break;
                        }
                        case OBJECT_LOAD: {
                            instGen.generateObjectLoadIns((BIRNonTerminator.FieldAccess)inst);
                            break;
                        }
                        case NEW_XML_ELEMENT: {
                            instGen.generateNewXMLElementIns((BIRNonTerminator.NewXMLElement)inst);
                            break;
                        }
                        case NEW_XML_TEXT: {
                            instGen.generateNewXMLTextIns((BIRNonTerminator.NewXMLText)inst);
                            break;
                        }
                        case NEW_XML_COMMENT: {
                            instGen.generateNewXMLCommentIns((BIRNonTerminator.NewXMLComment)inst);
                            break;
                        }
                        case NEW_XML_PI: {
                            instGen.generateNewXMLProcIns((BIRNonTerminator.NewXMLProcIns)inst);
                            break;
                        }
                        case NEW_XML_QNAME: {
                            instGen.generateNewXMLQNameIns((BIRNonTerminator.NewXMLQName)inst);
                            break;
                        }
                        case NEW_STRING_XML_QNAME: {
                            instGen.generateNewStringXMLQNameIns((BIRNonTerminator.NewStringXMLQName)inst);
                            break;
                        }
                        case XML_SEQ_STORE: {
                            instGen.generateXMLStoreIns((BIRNonTerminator.XMLAccess)inst);
                            break;
                        }
                        case XML_SEQ_LOAD: {
                            instGen.generateXMLLoadIns((BIRNonTerminator.FieldAccess)inst);
                            break;
                        }
                        case XML_LOAD: {
                            instGen.generateXMLLoadIns((BIRNonTerminator.FieldAccess)inst);
                            break;
                        }
                        case XML_LOAD_ALL: {
                            instGen.generateXMLLoadAllIns((BIRNonTerminator.XMLAccess)inst);
                            break;
                        }
                        case XML_ATTRIBUTE_STORE: {
                            instGen.generateXMLAttrStoreIns((BIRNonTerminator.FieldAccess)inst);
                            break;
                        }
                        case XML_ATTRIBUTE_LOAD: {
                            instGen.generateXMLAttrLoadIns((BIRNonTerminator.FieldAccess)inst);
                            break;
                        }
                        case FP_LOAD: {
                            instGen.generateFPLoadIns((BIRNonTerminator.FPLoad)inst);
                            break;
                        }
                        case STRING_LOAD: {
                            instGen.generateStringLoadIns((BIRNonTerminator.FieldAccess)inst);
                            break;
                        }
                        case NEW_TABLE: {
                            instGen.generateTableNewIns((BIRNonTerminator.NewTable)inst);
                            break;
                        }
                        case TYPEOF: {
                            instGen.generateTypeofIns((BIRNonTerminator.UnaryOP)inst);
                            break;
                        }
                        case NOT: {
                            instGen.generateNotIns((BIRNonTerminator.UnaryOP)inst);
                            break;
                        }
                        case NEW_TYPEDESC: {
                            instGen.generateNewTypedescIns((BIRNonTerminator.NewTypeDesc)inst);
                            break;
                        }
                        case NEGATE: {
                            instGen.generateNegateIns((BIRNonTerminator.UnaryOP)inst);
                            break;
                        }
                        case PLATFORM: {
                            instGen.generatePlatformIns((InteropMethodGen.JInstruction)inst);
                            break;
                        }
                        default: {
                            throw new BLangCompilerException("JVM generation is not supported for operation " + String.format("%s", inst));
                        }
                    }
                }
                ++m;
            }
            Label bbEndLable = labelGen.getLabel(funcName + bb.id.value + "beforeTerm");
            mv.visitLabel(bbEndLable);
            BIRTerminator terminator = bb.terminator;
            if (!isArg) {
                mv.visitIntInsn(17, caseIndex);
                mv.visitVarInsn(54, stateVarIndex);
                ++caseIndex;
            }
            if (!isArg || !(terminator instanceof BIRTerminator.Return)) {
                JvmMethodGen.generateDiagnosticPos(terminator.pos, mv);
                if (JvmMethodGen.isModuleInitFunction(module, func) && terminator instanceof BIRTerminator.Return) {
                    JvmMethodGen.generateAnnotLoad(mv, module.typeDefs, JvmPackageGen.getPackageName(module.org.value, module.name.value));
                }
                termGen.genTerminator(terminator, func, funcName, localVarOffset, returnVarRefIndex, attachedType, isObserved);
            }
            errorGen.generateTryCatch(func, funcName, bb, instGen, termGen, labelGen);
            BIRNode.BIRBasicBlock thenBB = terminator.thenBB;
            if (thenBB == null) continue;
            JvmMethodGen.genYieldCheck(mv, termGen.labelGen, thenBB, funcName, localVarOffset);
        }
    }

    private static void genYieldCheck(MethodVisitor mv, JvmLabelGen.LabelGenerator labelGen, BIRNode.BIRBasicBlock thenBB, String funcName, int localVarOffset) {
        mv.visitVarInsn(25, localVarOffset);
        mv.visitMethodInsn(182, "org/ballerinalang/jvm/scheduling/Strand", "isYielded", "()Z", false);
        Label yieldLabel = labelGen.getLabel(funcName + "yield");
        mv.visitJumpInsn(154, yieldLabel);
        Label gotoLabel = labelGen.getLabel(funcName + thenBB.id.value);
        mv.visitJumpInsn(167, gotoLabel);
    }

    static void generateLambdaMethod(BIRInstruction ins, ClassWriter cw, String lambdaName) {
        int argIndex;
        List<BIRNode.BIRVariableDcl> paramTypes;
        BType returnType;
        String funcName;
        String moduleName;
        String orgName;
        BType lhsType;
        int paramIndex = 1;
        boolean isVirtual = false;
        InstructionKind kind = ins.getKind();
        if (kind == InstructionKind.ASYNC_CALL) {
            BIRTerminator.AsyncCall asyncIns = (BIRTerminator.AsyncCall)ins;
            isVirtual = asyncIns.isVirtual;
            lhsType = asyncIns.lhsOp != null ? asyncIns.lhsOp.variableDcl.type : null;
            orgName = asyncIns.calleePkg.orgName.value;
            moduleName = asyncIns.calleePkg.name.value;
            funcName = asyncIns.name.getValue();
        } else if (kind == InstructionKind.FP_LOAD) {
            BIRNonTerminator.FPLoad fpIns = (BIRNonTerminator.FPLoad)ins;
            lhsType = fpIns.lhsOp.variableDcl.type;
            orgName = fpIns.pkgId.orgName.value;
            moduleName = fpIns.pkgId.name.value;
            funcName = fpIns.funcName.getValue();
        } else {
            throw new BLangCompilerException("JVM lambda method generation is not supported for instruction " + String.format("%s", ins));
        }
        boolean isExternFunction = JvmTerminatorGen.isExternStaticFunctionCall(ins);
        boolean isBuiltinModule = ExternalMethodGen.isBallerinaBuiltinModule(orgName, moduleName);
        if (lhsType.tag == 30) {
            returnType = ((BFutureType)lhsType).constraint;
        } else if (ins instanceof BIRNonTerminator.FPLoad) {
            returnType = ((BIRNonTerminator.FPLoad)ins).retType;
            if (returnType.tag == 16) {
                returnType = ((BInvokableType)returnType).retType;
            }
        } else {
            throw new BLangCompilerException("JVM generation is not supported for async return type " + String.format("%s", lhsType));
        }
        int closureMapsCount = 0;
        if (kind == InstructionKind.FP_LOAD) {
            closureMapsCount = ((BIRNonTerminator.FPLoad)ins).closureMaps.size();
        }
        String closureMapsDesc = JvmMethodGen.getMapValueDesc(closureMapsCount);
        MethodVisitor mv = cw.visitMethod(9, JvmMethodGen.cleanupFunctionName(lambdaName), String.format("(%s[L%s;)L%s;", closureMapsDesc, "java/lang/Object", "java/lang/Object"), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, closureMapsCount);
        mv.visitInsn(3);
        mv.visitInsn(50);
        mv.visitTypeInsn(192, "org/ballerinalang/jvm/scheduling/Strand");
        if (isExternFunction) {
            Label blockedOnExternLabel = new Label();
            mv.visitInsn(89);
            mv.visitMethodInsn(182, "org/ballerinalang/jvm/scheduling/Strand", "isBlockedOnExtern", "()Z", false);
            mv.visitJumpInsn(153, blockedOnExternLabel);
            mv.visitInsn(89);
            mv.visitInsn(3);
            mv.visitFieldInsn(181, "org/ballerinalang/jvm/scheduling/Strand", "blockedOnExtern", "Z");
            mv.visitInsn(89);
            mv.visitFieldInsn(180, "org/ballerinalang/jvm/scheduling/Strand", "returnValue", "Ljava/lang/Object;");
            mv.visitInsn(176);
            mv.visitLabel(blockedOnExternLabel);
        }
        ArrayList<BType> paramBTypes = new ArrayList<BType>();
        if (kind == InstructionKind.ASYNC_CALL) {
            BIRTerminator.AsyncCall asyncIns = (BIRTerminator.AsyncCall)ins;
            paramTypes = asyncIns.args;
            if (isVirtual) {
                JvmMethodGen.genLoadDataForObjectAttachedLambdas(asyncIns, mv, closureMapsCount, paramTypes, isBuiltinModule);
                int paramTypeIndex = 1;
                paramIndex = 2;
                while (paramTypeIndex < paramTypes.size()) {
                    JvmMethodGen.generateObjectArgs(mv, paramIndex);
                    ++paramTypeIndex;
                    ++paramIndex;
                    if (isBuiltinModule) continue;
                    JvmMethodGen.generateObjectArgs(mv, paramIndex);
                    ++paramIndex;
                }
            } else {
                argIndex = 1;
                for (BIROperand bIROperand : paramTypes) {
                    BIROperand ref = JvmMethodGen.getVarRef(bIROperand);
                    mv.visitVarInsn(25, 0);
                    mv.visitIntInsn(16, argIndex);
                    mv.visitInsn(50);
                    JvmInstructionGen.addUnboxInsn(mv, ref.variableDcl.type);
                    paramBTypes.add(paramIndex - 1, bIROperand.variableDcl.type);
                    ++paramIndex;
                    ++argIndex;
                    if (!isBuiltinModule) {
                        JvmMethodGen.addBooleanTypeToLambdaParamTypes(mv, 0, argIndex);
                        paramBTypes.add(paramIndex - 1, JvmPackageGen.symbolTable.booleanType);
                        ++paramIndex;
                    }
                    ++argIndex;
                }
            }
        } else {
            int i;
            for (i = 0; i < closureMapsCount; ++i) {
                mv.visitVarInsn(25, i);
                mv.visitInsn(4);
            }
            paramTypes = ((BIRNonTerminator.FPLoad)ins).params;
            argIndex = 1;
            for (BIRNode.BIRVariableDcl bIRVariableDcl : paramTypes) {
                BIRNode.BIRVariableDcl dcl = JvmMethodGen.getVariableDcl(bIRVariableDcl);
                mv.visitVarInsn(25, closureMapsCount);
                mv.visitIntInsn(16, argIndex);
                mv.visitInsn(50);
                JvmInstructionGen.addUnboxInsn(mv, dcl.type);
                paramBTypes.add(paramIndex - 1, dcl.type);
                ++paramIndex;
                ++i;
                ++argIndex;
                if (!isBuiltinModule) {
                    JvmMethodGen.addBooleanTypeToLambdaParamTypes(mv, closureMapsCount, argIndex);
                    paramBTypes.add(paramIndex - 1, JvmPackageGen.symbolTable.booleanType);
                    ++paramIndex;
                }
                ++argIndex;
            }
        }
        if (isVirtual) {
            String methodDesc = String.format("(L%s;L%s;[L%s;)L%s;", "org/ballerinalang/jvm/scheduling/Strand", "java/lang/String", "java/lang/Object", "java/lang/Object");
            mv.visitMethodInsn(185, "org/ballerinalang/jvm/values/ObjectValue", "call", methodDesc, true);
        } else {
            String jvmClass;
            String lookupKey = JvmPackageGen.getPackageName(orgName, moduleName) + funcName;
            JvmPackageGen.BIRFunctionWrapper functionWrapper = JvmPackageGen.birFunctionMap.get(lookupKey);
            String methodDesc = JvmMethodGen.getLambdaMethodDesc(paramBTypes, returnType, closureMapsCount);
            if (functionWrapper != null) {
                jvmClass = functionWrapper.fullQualifiedClassName;
            } else {
                BPackageSymbol bPackageSymbol = CodeGenerator.packageCache.getSymbol(orgName + "/" + moduleName);
                BInvokableSymbol funcSymbol = (BInvokableSymbol)bPackageSymbol.scope.lookup((Name)new Name((String)funcName)).symbol;
                BInvokableType type = (BInvokableType)funcSymbol.type;
                ArrayList<BType> params = new ArrayList<BType>(type.paramTypes);
                if (type.restType != null) {
                    params.add(type.restType);
                }
                for (int j = params.size() - 1; j >= 0; --j) {
                    params.add(j + 1, JvmPackageGen.symbolTable.booleanType);
                }
                String balFileName = funcSymbol.source;
                if (balFileName == null || !balFileName.endsWith(".bal")) {
                    balFileName = "___init";
                }
                jvmClass = JvmPackageGen.getModuleLevelClassName(orgName, moduleName, JvmMethodGen.cleanupPathSeperators(JvmMethodGen.cleanupBalExt(balFileName)));
            }
            mv.visitMethodInsn(184, jvmClass, funcName, methodDesc, false);
        }
        if (!isVirtual) {
            JvmInstructionGen.addBoxInsn(mv, returnType);
        }
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void genLoadDataForObjectAttachedLambdas(BIRTerminator.AsyncCall ins, MethodVisitor mv, int closureMapsCount, @Nilable List<BIROperand> paramTypes, boolean isBuiltinModule) {
        mv.visitInsn(87);
        mv.visitVarInsn(25, closureMapsCount);
        mv.visitInsn(4);
        BIROperand ref = JvmMethodGen.getVarRef((BIROperand)ins.args.get(0));
        mv.visitInsn(50);
        JvmInstructionGen.addUnboxInsn(mv, ref.variableDcl.type);
        mv.visitVarInsn(25, closureMapsCount);
        mv.visitInsn(3);
        mv.visitInsn(50);
        mv.visitTypeInsn(192, "org/ballerinalang/jvm/scheduling/Strand");
        mv.visitLdcInsn((Object)JvmTerminatorGen.cleanupObjectTypeName(ins.name.value));
        int objectArrayLength = paramTypes.size() - 1;
        if (!isBuiltinModule) {
            mv.visitIntInsn(16, objectArrayLength * 2);
        } else {
            mv.visitIntInsn(16, objectArrayLength);
        }
        mv.visitTypeInsn(189, "java/lang/Object");
    }

    private static void generateObjectArgs(MethodVisitor mv, int paramIndex) {
        mv.visitInsn(89);
        mv.visitIntInsn(16, paramIndex - 2);
        mv.visitVarInsn(25, 0);
        mv.visitIntInsn(16, paramIndex + 1);
        mv.visitInsn(50);
        mv.visitInsn(83);
    }

    private static void addBooleanTypeToLambdaParamTypes(MethodVisitor mv, int arrayIndex, int paramIndex) {
        mv.visitVarInsn(25, arrayIndex);
        mv.visitIntInsn(16, paramIndex);
        mv.visitInsn(50);
        JvmInstructionGen.addUnboxInsn(mv, JvmPackageGen.symbolTable.booleanType);
    }

    private static void genDefaultValue(MethodVisitor mv, BType bType, int index) {
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            mv.visitInsn(9);
            mv.visitVarInsn(55, index);
        } else if (bType.tag == 2) {
            mv.visitInsn(3);
            mv.visitVarInsn(54, index);
        } else if (bType.tag == 3) {
            mv.visitInsn(14);
            mv.visitVarInsn(57, index);
        } else if (TypeTags.isStringTypeTag(bType.tag)) {
            mv.visitInsn(1);
            mv.visitVarInsn(58, index);
        } else if (bType.tag == 6) {
            mv.visitInsn(3);
            mv.visitVarInsn(54, index);
        } else if (bType.tag == 15 || bType.tag == 19 || bType.tag == 9 || bType.tag == 14 || bType.tag == 27 || bType.tag == 10 || bType.tag == 17 || bType.tag == 11 || bType.tag == 32 || bType.tag == 42 || bType.tag == 4 || bType.tag == 20 || bType.tag == 12 || bType.tag == 29 || bType.tag == 30 || bType.tag == 7 || TypeTags.isXMLTypeTag(bType.tag) || bType.tag == 16 || bType.tag == 31 || bType.tag == 35 || bType.tag == 13) {
            mv.visitInsn(1);
            mv.visitVarInsn(58, index);
        } else if (bType.tag == Integer.MAX_VALUE) {
            JvmMethodGen.genJDefaultValue(mv, (JType)bType, index);
        } else {
            throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", bType));
        }
    }

    private static void genJDefaultValue(MethodVisitor mv, JType jType, int index) {
        if (jType.jTag == 1) {
            mv.visitInsn(3);
            mv.visitVarInsn(54, index);
        } else if (jType.jTag == 2) {
            mv.visitInsn(3);
            mv.visitVarInsn(54, index);
        } else if (jType.jTag == 3) {
            mv.visitInsn(3);
            mv.visitVarInsn(54, index);
        } else if (jType.jTag == 4) {
            mv.visitInsn(3);
            mv.visitVarInsn(54, index);
        } else if (jType.jTag == 5) {
            mv.visitInsn(9);
            mv.visitVarInsn(55, index);
        } else if (jType.jTag == 6) {
            mv.visitInsn(11);
            mv.visitVarInsn(56, index);
        } else if (jType.jTag == 7) {
            mv.visitInsn(14);
            mv.visitVarInsn(57, index);
        } else if (jType.jTag == 8) {
            mv.visitInsn(3);
            mv.visitVarInsn(54, index);
        } else if (jType.jTag == 9 || jType.jTag == 10) {
            mv.visitInsn(1);
            mv.visitVarInsn(58, index);
        } else {
            throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", jType));
        }
    }

    static void loadDefaultValue(MethodVisitor mv, BType bType) {
        if (TypeTags.isIntegerTypeTag(bType.tag) || bType.tag == 2) {
            mv.visitInsn(9);
        } else if (bType.tag == 3) {
            mv.visitInsn(14);
        } else if (bType.tag == 6) {
            mv.visitInsn(3);
        } else if (TypeTags.isStringTypeTag(bType.tag) || bType.tag == 15 || bType.tag == 19 || bType.tag == 9 || bType.tag == 27 || bType.tag == 10 || bType.tag == 17 || bType.tag == 11 || bType.tag == 32 || bType.tag == 20 || bType.tag == 12 || bType.tag == 29 || bType.tag == 30 || bType.tag == 7 || TypeTags.isXMLTypeTag(bType.tag) || bType.tag == 16 || bType.tag == 31 || bType.tag == 35 || bType.tag == 13) {
            mv.visitInsn(1);
        } else if (bType.tag == Integer.MAX_VALUE) {
            JvmMethodGen.loadDefaultJValue(mv, (JType)bType);
        } else {
            throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", bType));
        }
    }

    private static void loadDefaultJValue(MethodVisitor mv, JType jType) {
        if (jType.jTag == 1) {
            mv.visitInsn(3);
        } else if (jType.jTag == 2) {
            mv.visitInsn(3);
        } else if (jType.jTag == 3) {
            mv.visitInsn(3);
        } else if (jType.jTag == 4) {
            mv.visitInsn(3);
        } else if (jType.jTag == 5) {
            mv.visitInsn(9);
        } else if (jType.jTag == 6) {
            mv.visitInsn(11);
        } else if (jType.jTag == 7) {
            mv.visitInsn(14);
        } else if (jType.jTag == 8) {
            mv.visitInsn(3);
        } else if (jType.jTag == 9 || jType.jTag == 10) {
            mv.visitInsn(1);
        } else {
            throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", jType));
        }
    }

    public static String getMethodDesc(@Nilable List<BType> paramTypes, @Nilable BType retType, @Nilable BType attachedType, boolean isExtern) {
        StringBuilder desc = new StringBuilder("(Lorg/ballerinalang/jvm/scheduling/Strand;");
        if (attachedType != null) {
            desc.append(JvmMethodGen.getArgTypeSignature(attachedType));
        }
        for (int i = 0; i < paramTypes.size(); ++i) {
            BType paramType = JvmMethodGen.getType(paramTypes.get(i));
            desc.append(JvmMethodGen.getArgTypeSignature(paramType));
        }
        String returnType = JvmMethodGen.generateReturnType(retType, isExtern);
        desc.append(returnType);
        return desc.toString();
    }

    private static String getLambdaMethodDesc(@Nilable List<BType> paramTypes, @Nilable BType retType, int closureMapsCount) {
        StringBuilder desc = new StringBuilder("(Lorg/ballerinalang/jvm/scheduling/Strand;");
        for (int j = 0; j < closureMapsCount; ++j) {
            desc.append("L").append("org/ballerinalang/jvm/values/MapValue").append(";").append("Z");
        }
        for (int i = 0; i < paramTypes.size(); ++i) {
            BType paramType = JvmMethodGen.getType(paramTypes.get(i));
            desc.append(JvmMethodGen.getArgTypeSignature(paramType));
        }
        String returnType = JvmMethodGen.generateReturnType(retType, false);
        desc.append(returnType);
        return desc.toString();
    }

    private static String getArgTypeSignature(BType bType) {
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            return "J";
        }
        if (bType.tag == 2) {
            return "I";
        }
        if (bType.tag == 3) {
            return "D";
        }
        if (TypeTags.isStringTypeTag(bType.tag)) {
            return String.format("L%s;", JvmInstructionGen.isBString ? "org/ballerinalang/jvm/values/api/BString" : "java/lang/String");
        }
        if (bType.tag == 4) {
            return String.format("L%s;", "org/ballerinalang/jvm/values/DecimalValue");
        }
        if (bType.tag == 6) {
            return "Z";
        }
        if (bType.tag == 10) {
            return String.format("L%s;", "java/lang/Object");
        }
        if (bType.tag == 19 || bType.tag == 29) {
            return String.format("L%s;", "org/ballerinalang/jvm/values/ArrayValue");
        }
        if (bType.tag == 27) {
            return String.format("L%s;", "org/ballerinalang/jvm/values/ErrorValue");
        }
        if (bType.tag == 11 || bType.tag == 20 || bType.tag == 7 || bType.tag == 31 || bType.tag == 17) {
            return String.format("L%s;", "java/lang/Object");
        }
        if (bType.tag == 15 || bType.tag == 12) {
            return String.format("L%s;", "org/ballerinalang/jvm/values/MapValue");
        }
        if (bType.tag == 30) {
            return String.format("L%s;", "org/ballerinalang/jvm/values/FutureValue");
        }
        if (bType.tag == 9) {
            return String.format("L%s;", "org/ballerinalang/jvm/values/TableValue");
        }
        if (bType.tag == 14) {
            return String.format("L%s;", "org/ballerinalang/jvm/values/StreamValue");
        }
        if (bType.tag == 16) {
            return String.format("L%s;", "org/ballerinalang/jvm/values/FPValue");
        }
        if (bType.tag == 13) {
            return String.format("L%s;", "org/ballerinalang/jvm/values/TypedescValue");
        }
        if (bType.tag == 32) {
            return String.format("L%s;", "org/ballerinalang/jvm/values/ObjectValue");
        }
        if (TypeTags.isXMLTypeTag(bType.tag)) {
            return String.format("L%s;", "org/ballerinalang/jvm/values/XMLValue");
        }
        if (bType.tag == 35) {
            return String.format("L%s;", "org/ballerinalang/jvm/values/HandleValue");
        }
        throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", bType));
    }

    private static String generateReturnType(@Nilable BType bType, boolean isExtern) {
        if (bType == null || bType.tag == 10) {
            if (isExtern) {
                return ")V";
            }
            return String.format(")L%s;", "java/lang/Object");
        }
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            return ")J";
        }
        if (bType.tag == 2) {
            return ")I";
        }
        if (bType.tag == 3) {
            return ")D";
        }
        if (TypeTags.isStringTypeTag(bType.tag)) {
            return String.format(")L%s;", JvmInstructionGen.isBString ? "org/ballerinalang/jvm/values/api/BString" : "java/lang/String");
        }
        if (bType.tag == 4) {
            return String.format(")L%s;", "org/ballerinalang/jvm/values/DecimalValue");
        }
        if (bType.tag == 6) {
            return ")Z";
        }
        if (bType.tag == 19 || bType.tag == 29) {
            return String.format(")L%s;", "org/ballerinalang/jvm/values/ArrayValue");
        }
        if (bType.tag == 15 || bType.tag == 12) {
            return String.format(")L%s;", "org/ballerinalang/jvm/values/MapValue");
        }
        if (bType.tag == 27) {
            return String.format(")L%s;", "org/ballerinalang/jvm/values/ErrorValue");
        }
        if (bType.tag == 9) {
            return String.format(")L%s;", "org/ballerinalang/jvm/values/TableValue");
        }
        if (bType.tag == 14) {
            return String.format(")L%s;", "org/ballerinalang/jvm/values/StreamValue");
        }
        if (bType.tag == 30) {
            return String.format(")L%s;", "org/ballerinalang/jvm/values/FutureValue");
        }
        if (bType.tag == 13) {
            return String.format(")L%s;", "org/ballerinalang/jvm/values/TypedescValue");
        }
        if (bType.tag == 17 || bType.tag == 11 || bType.tag == 20 || bType.tag == 7 || bType.tag == 31) {
            return String.format(")L%s;", "java/lang/Object");
        }
        if (bType.tag == 32) {
            return String.format(")L%s;", "org/ballerinalang/jvm/values/ObjectValue");
        }
        if (bType.tag == 16) {
            return String.format(")L%s;", "org/ballerinalang/jvm/values/FPValue");
        }
        if (TypeTags.isXMLTypeTag(bType.tag)) {
            return String.format(")L%s;", "org/ballerinalang/jvm/values/XMLValue");
        }
        if (bType.tag == 35) {
            return String.format(")L%s;", "org/ballerinalang/jvm/values/HandleValue");
        }
        throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", bType));
    }

    @Nilable
    static BIRNode.BIRFunction getMainFunc(@Nilable List<BIRNode.BIRFunction> funcs) {
        BIRNode.BIRFunction userMainFunc = null;
        for (BIRNode.BIRFunction func : funcs) {
            if (func == null || !func.name.value.equals("main")) continue;
            userMainFunc = func;
            break;
        }
        return userMainFunc;
    }

    static void createFunctionPointer(MethodVisitor mv, String klass, String lambdaName, int closureMapCount) {
        mv.visitTypeInsn(187, "org/ballerinalang/jvm/values/FPValue");
        mv.visitInsn(89);
        JvmInstructionGen.InstructionGenerator.visitInvokeDyn(mv, klass, JvmMethodGen.cleanupFunctionName(lambdaName), closureMapCount);
        mv.visitInsn(1);
        mv.visitInsn(3);
        mv.visitMethodInsn(183, "org/ballerinalang/jvm/values/FPValue", "<init>", String.format("(L%s;L%s;Z)V", "java/util/function/Function", "org/ballerinalang/jvm/types/BType"), false);
    }

    static void generateMainMethod(@Nilable BIRNode.BIRFunction userMainFunc, ClassWriter cw, BIRNode.BIRPackage pkg, String mainClass, String initClass, boolean serviceEPAvailable) {
        String lambdaName;
        MethodVisitor mv = cw.visitMethod(9, "main", "([Ljava/lang/String;)V", null, null);
        JvmMethodGen.generateJavaCompatibilityCheck(mv);
        JvmMethodGen.initConfigurations(mv);
        JvmMethodGen.startListeners(mv, serviceEPAvailable);
        JvmMethodGen.registerShutdownListener(mv, initClass);
        BalToJVMIndexMap indexMap = new BalToJVMIndexMap();
        String pkgName = JvmPackageGen.getPackageName(pkg.org.value, pkg.name.value);
        JvmErrorGen.ErrorHandlerGenerator errorGen = new JvmErrorGen.ErrorHandlerGenerator(mv, indexMap, pkgName);
        BIRNode.BIRVariableDcl argsVar = new BIRNode.BIRVariableDcl(JvmPackageGen.symbolTable.anyType, new Name("argsdummy"), VarScope.FUNCTION, VarKind.ARG);
        int ignoreArgsVarIndex = indexMap.getIndex(argsVar);
        boolean isVoidFunction = userMainFunc != null && userMainFunc.type.retType.tag == 10;
        mv.visitTypeInsn(187, "org/ballerinalang/jvm/scheduling/Scheduler");
        mv.visitInsn(89);
        mv.visitInsn(3);
        mv.visitMethodInsn(183, "org/ballerinalang/jvm/scheduling/Scheduler", "<init>", "(Z)V", false);
        BIRNode.BIRVariableDcl schedulerVar = new BIRNode.BIRVariableDcl(JvmPackageGen.symbolTable.anyType, new Name("schedulerdummy"), VarScope.FUNCTION, VarKind.ARG);
        int schedulerVarIndex = indexMap.getIndex(schedulerVar);
        mv.visitVarInsn(58, schedulerVarIndex);
        if (JvmMethodGen.hasInitFunction(pkg)) {
            mv.visitVarInsn(25, schedulerVarIndex);
            mv.visitIntInsn(16, 1);
            mv.visitTypeInsn(189, "java/lang/Object");
            lambdaName = String.format("$lambda$%s$", "$moduleInit");
            JvmMethodGen.createFunctionPointer(mv, initClass, lambdaName, 0);
            mv.visitInsn(1);
            BType anyType = JvmPackageGen.symbolTable.anyType;
            JvmTypeGen.loadType(mv, anyType);
            mv.visitMethodInsn(182, "org/ballerinalang/jvm/scheduling/Scheduler", "scheduleFunction", String.format("([L%s;L%s;L%s;L%s;)L%s;", "java/lang/Object", "org/ballerinalang/jvm/values/FPValue", "org/ballerinalang/jvm/scheduling/Strand", "org/ballerinalang/jvm/types/BType", "org/ballerinalang/jvm/values/FutureValue"), false);
            mv.visitInsn(89);
            mv.visitInsn(89);
            mv.visitFieldInsn(180, "org/ballerinalang/jvm/values/FutureValue", "strand", String.format("L%s;", "org/ballerinalang/jvm/scheduling/Strand"));
            mv.visitIntInsn(16, 100);
            mv.visitTypeInsn(189, "java/lang/Object");
            mv.visitFieldInsn(181, "org/ballerinalang/jvm/scheduling/Strand", "frames", String.format("[L%s;", "java/lang/Object"));
            errorGen.printStackTraceFromFutureValue(mv, indexMap);
            BIRNode.BIRVariableDcl futureVar = new BIRNode.BIRVariableDcl(JvmPackageGen.symbolTable.anyType, new Name("initdummy"), VarScope.FUNCTION, VarKind.ARG);
            int futureVarIndex = indexMap.getIndex(futureVar);
            mv.visitVarInsn(58, futureVarIndex);
            mv.visitVarInsn(25, futureVarIndex);
            mv.visitFieldInsn(180, "org/ballerinalang/jvm/values/FutureValue", "result", String.format("L%s;", "java/lang/Object"));
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/util/RuntimeUtils", "handleRuntimeReturnValues", String.format("(L%s;)V", "java/lang/Object"), false);
        }
        if (userMainFunc != null) {
            mv.visitVarInsn(25, schedulerVarIndex);
            JvmMethodGen.loadCLIArgsForMain(mv, new ArrayList<BIRNode.BIRFunctionParameter>(userMainFunc.parameters.keySet()), userMainFunc.restParam != null, userMainFunc.annotAttachments);
            lambdaName = "$lambda$main$";
            JvmMethodGen.createFunctionPointer(mv, initClass, lambdaName, 0);
            mv.visitInsn(1);
            JvmTypeGen.loadType(mv, userMainFunc.type.retType);
            mv.visitMethodInsn(182, "org/ballerinalang/jvm/scheduling/Scheduler", "scheduleFunction", String.format("([L%s;L%s;L%s;L%s;)L%s;", "java/lang/Object", "org/ballerinalang/jvm/values/FPValue", "org/ballerinalang/jvm/scheduling/Strand", "org/ballerinalang/jvm/types/BType", "org/ballerinalang/jvm/values/FutureValue"), false);
            mv.visitInsn(89);
            mv.visitInsn(89);
            mv.visitFieldInsn(180, "org/ballerinalang/jvm/values/FutureValue", "strand", String.format("L%s;", "org/ballerinalang/jvm/scheduling/Strand"));
            mv.visitIntInsn(16, 100);
            mv.visitTypeInsn(189, "java/lang/Object");
            mv.visitFieldInsn(181, "org/ballerinalang/jvm/scheduling/Strand", "frames", String.format("[L%s;", "java/lang/Object"));
            errorGen.printStackTraceFromFutureValue(mv, indexMap);
            if (!isVoidFunction) {
                BIRNode.BIRVariableDcl futureVar = new BIRNode.BIRVariableDcl(JvmPackageGen.symbolTable.anyType, new Name("dummy"), VarScope.FUNCTION, VarKind.ARG);
                int futureVarIndex = indexMap.getIndex(futureVar);
                mv.visitVarInsn(58, futureVarIndex);
                mv.visitVarInsn(25, futureVarIndex);
                mv.visitFieldInsn(180, "org/ballerinalang/jvm/values/FutureValue", "result", String.format("L%s;", "java/lang/Object"));
                mv.visitMethodInsn(184, "org/ballerinalang/jvm/util/RuntimeUtils", "handleRuntimeReturnValues", String.format("(L%s;)V", "java/lang/Object"), false);
            }
        }
        if (JvmMethodGen.hasInitFunction(pkg)) {
            JvmMethodGen.scheduleStartMethod(mv, pkg, initClass, serviceEPAvailable, errorGen, indexMap, schedulerVarIndex);
        }
        JvmMethodGen.stopListeners(mv, serviceEPAvailable);
        if (!serviceEPAvailable) {
            mv.visitMethodInsn(184, "java/lang/Runtime", "getRuntime", String.format("()L%s;", "java/lang/Runtime"), false);
            mv.visitInsn(3);
            mv.visitMethodInsn(182, "java/lang/Runtime", "exit", "(I)V", false);
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void initConfigurations(MethodVisitor mv) {
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "org/ballerinalang/jvm/launch/LaunchUtils", "initConfigurations", String.format("([L%s;)[L%s;", "java/lang/String", "java/lang/String"), false);
        mv.visitVarInsn(58, 0);
    }

    private static void startListeners(MethodVisitor mv, boolean isServiceEPAvailable) {
        mv.visitLdcInsn((Object)isServiceEPAvailable);
        mv.visitMethodInsn(184, "org/ballerinalang/jvm/launch/LaunchUtils", "startListeners", "(Z)V", false);
    }

    private static void stopListeners(MethodVisitor mv, boolean isServiceEPAvailable) {
        mv.visitLdcInsn((Object)isServiceEPAvailable);
        mv.visitMethodInsn(184, "org/ballerinalang/jvm/launch/LaunchUtils", "stopListeners", "(Z)V", false);
    }

    private static void registerShutdownListener(MethodVisitor mv, String initClass) {
        String shutdownClassName = initClass + "$SignalListener";
        mv.visitMethodInsn(184, "java/lang/Runtime", "getRuntime", String.format("()L%s;", "java/lang/Runtime"), false);
        mv.visitTypeInsn(187, shutdownClassName);
        mv.visitInsn(89);
        mv.visitMethodInsn(183, shutdownClassName, "<init>", "()V", false);
        mv.visitMethodInsn(182, "java/lang/Runtime", "addShutdownHook", String.format("(L%s;)V", "java/lang/Thread"), false);
    }

    private static void scheduleStartMethod(MethodVisitor mv, BIRNode.BIRPackage pkg, String initClass, boolean serviceEPAvailable, JvmErrorGen.ErrorHandlerGenerator errorGen, BalToJVMIndexMap indexMap, int schedulerVarIndex) {
        mv.visitVarInsn(25, schedulerVarIndex);
        String startLambdaName = String.format("$lambda$%s$", "$moduleStart");
        mv.visitIntInsn(16, 1);
        mv.visitTypeInsn(189, "java/lang/Object");
        JvmMethodGen.createFunctionPointer(mv, initClass, startLambdaName, 0);
        mv.visitInsn(1);
        BType anyType = JvmPackageGen.symbolTable.anyType;
        JvmTypeGen.loadType(mv, anyType);
        mv.visitMethodInsn(182, "org/ballerinalang/jvm/scheduling/Scheduler", "scheduleFunction", String.format("([L%s;L%s;L%s;L%s;)L%s;", "java/lang/Object", "org/ballerinalang/jvm/values/FPValue", "org/ballerinalang/jvm/scheduling/Strand", "org/ballerinalang/jvm/types/BType", "org/ballerinalang/jvm/values/FutureValue"), false);
        mv.visitInsn(89);
        mv.visitInsn(89);
        mv.visitFieldInsn(180, "org/ballerinalang/jvm/values/FutureValue", "strand", String.format("L%s;", "org/ballerinalang/jvm/scheduling/Strand"));
        mv.visitIntInsn(16, 100);
        mv.visitTypeInsn(189, "java/lang/Object");
        mv.visitFieldInsn(181, "org/ballerinalang/jvm/scheduling/Strand", "frames", String.format("[L%s;", "java/lang/Object"));
        errorGen.printStackTraceFromFutureValue(mv, indexMap);
        BIRNode.BIRVariableDcl futureVar = new BIRNode.BIRVariableDcl(JvmPackageGen.symbolTable.anyType, new Name("startdummy"), VarScope.FUNCTION, VarKind.ARG);
        int futureVarIndex = indexMap.getIndex(futureVar);
        mv.visitVarInsn(58, futureVarIndex);
        mv.visitVarInsn(25, futureVarIndex);
        mv.visitFieldInsn(180, "org/ballerinalang/jvm/values/FutureValue", "result", String.format("L%s;", "java/lang/Object"));
        mv.visitMethodInsn(184, "org/ballerinalang/jvm/util/RuntimeUtils", "handleRuntimeReturnValues", String.format("(L%s;)V", "java/lang/Object"), false);
        if (serviceEPAvailable) {
            mv.visitVarInsn(25, schedulerVarIndex);
            mv.visitInsn(89);
            mv.visitInsn(4);
            mv.visitFieldInsn(181, "org/ballerinalang/jvm/scheduling/Scheduler", "immortal", "Z");
            mv.visitMethodInsn(182, "org/ballerinalang/jvm/scheduling/Scheduler", "start", "()V", false);
        }
    }

    static void generateLambdaForMain(BIRNode.BIRFunction userMainFunc, ClassWriter cw, BIRNode.BIRPackage pkg, String mainClass, String initClass) {
        BType returnType = userMainFunc.type.retType;
        MethodVisitor mv = cw.visitMethod(9, "$lambda$main$", String.format("([L%s;)L%s;", "java/lang/Object", "java/lang/Object"), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitInsn(3);
        mv.visitInsn(50);
        mv.visitTypeInsn(192, "org/ballerinalang/jvm/scheduling/Strand");
        List<BType> paramTypes = userMainFunc.type.paramTypes;
        int paramIndex = 1;
        for (BType paramType : paramTypes) {
            BType pType = JvmMethodGen.getType(paramType);
            mv.visitVarInsn(25, 0);
            mv.visitIntInsn(16, paramIndex);
            mv.visitInsn(50);
            JvmInstructionGen.addUnboxInsn(mv, pType);
            ++paramIndex;
        }
        mv.visitMethodInsn(184, mainClass, userMainFunc.name.value, JvmMethodGen.getMethodDesc(paramTypes, returnType, null, false), false);
        JvmInstructionGen.addBoxInsn(mv, returnType);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void loadCLIArgsForMain(MethodVisitor mv, @Nilable List<BIRNode.BIRFunctionParameter> params, boolean hasRestParam, @Nilable List<BIRNode.BIRAnnotationAttachment> annotAttachments) {
        ArrayList<String> defaultableNames = new ArrayList<String>();
        int defaultableIndex = 0;
        for (BIRNode.BIRAnnotationAttachment attachment : annotAttachments) {
            if (attachment == null || !attachment.annotTagRef.value.equals("DefaultableArgs")) continue;
            BIRNode.BIRAnnotationRecordValue annotRecValue = (BIRNode.BIRAnnotationRecordValue)attachment.annotValues.get(0);
            Map<String, BIRNode.BIRAnnotationValue> annotFieldMap = annotRecValue.annotValueEntryMap;
            BIRNode.BIRAnnotationArrayValue annotArrayValue = (BIRNode.BIRAnnotationArrayValue)annotFieldMap.get("args");
            for (BIRNode.BIRAnnotationValue entryOptional : annotArrayValue.annotArrayValue) {
                BIRNode.BIRAnnotationLiteralValue argValue = (BIRNode.BIRAnnotationLiteralValue)entryOptional;
                defaultableNames.add(defaultableIndex, (String)argValue.value);
                ++defaultableIndex;
            }
        }
        mv.visitIntInsn(16, params.size());
        mv.visitTypeInsn(189, String.format("%s$ParamInfo", "org/ballerinalang/jvm/util/RuntimeUtils"));
        int index = 0;
        defaultableIndex = 0;
        for (BIRNode.BIRFunctionParameter param : params) {
            mv.visitInsn(89);
            mv.visitIntInsn(16, index);
            ++index;
            mv.visitTypeInsn(187, String.format("%s$ParamInfo", "org/ballerinalang/jvm/util/RuntimeUtils"));
            mv.visitInsn(89);
            if (param != null) {
                if (param.hasDefaultExpr) {
                    mv.visitInsn(4);
                } else {
                    mv.visitInsn(3);
                }
                mv.visitLdcInsn(defaultableNames.get(defaultableIndex));
                ++defaultableIndex;
                JvmTypeGen.loadType(mv, param.type);
            }
            mv.visitMethodInsn(183, String.format("%s$ParamInfo", "org/ballerinalang/jvm/util/RuntimeUtils"), "<init>", String.format("(ZL%s;L%s;)V", "java/lang/String", "org/ballerinalang/jvm/types/BType"), false);
            mv.visitInsn(83);
        }
        mv.visitVarInsn(25, 0);
        if (hasRestParam) {
            mv.visitInsn(4);
        } else {
            mv.visitInsn(3);
        }
        mv.visitMethodInsn(184, "org/ballerinalang/jvm/util/ArgumentParser", "extractEntryFuncArgs", String.format("([L%s$ParamInfo;[L%s;Z)[L%s;", "org/ballerinalang/jvm/util/RuntimeUtils", "java/lang/String", "java/lang/Object"), false);
    }

    static void generateLambdaForPackageInits(ClassWriter cw, BIRNode.BIRPackage pkg, String mainClass, String initClass, List<PackageID> depMods) {
        if (!JvmMethodGen.hasInitFunction(pkg)) {
            return;
        }
        JvmMethodGen.generateLambdaForModuleFunction(cw, "$moduleInit", initClass, false);
        JvmMethodGen.generateLambdaForModuleFunction(cw, "$moduleStart", initClass, false);
        String stopFuncName = "<stop>";
        PackageID currentModId = JvmPackageGen.packageToModuleId(pkg);
        String fullFuncName = JvmMethodGen.calculateModuleSpecialFuncName(currentModId, stopFuncName);
        JvmMethodGen.generateLambdaForDepModStopFunc(cw, JvmMethodGen.cleanupFunctionName(fullFuncName), initClass);
        for (PackageID id : depMods) {
            fullFuncName = JvmMethodGen.calculateModuleSpecialFuncName(id, stopFuncName);
            String jvmClass = JvmPackageGen.getPackageName(id.orgName, id.name) + "___init";
            JvmMethodGen.generateLambdaForDepModStopFunc(cw, JvmMethodGen.cleanupFunctionName(fullFuncName), jvmClass);
        }
    }

    private static void generateLambdaForModuleFunction(ClassWriter cw, String funcName, String initClass, boolean voidReturn) {
        MethodVisitor mv = cw.visitMethod(9, String.format("$lambda$%s$", funcName), String.format("([L%s;)L%s;", "java/lang/Object", "java/lang/Object"), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitInsn(3);
        mv.visitInsn(50);
        mv.visitTypeInsn(192, "org/ballerinalang/jvm/scheduling/Strand");
        mv.visitMethodInsn(184, initClass, funcName, String.format("(L%s;)L%s;", "org/ballerinalang/jvm/scheduling/Strand", "java/lang/Object"), false);
        JvmInstructionGen.addBoxInsn(mv, errorOrNilType);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void generateLambdaForDepModStopFunc(ClassWriter cw, String funcName, String initClass) {
        MethodVisitor mv = cw.visitMethod(9, String.format("$lambda$%s", funcName), String.format("([L%s;)L%s;", "java/lang/Object", "java/lang/Object"), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitInsn(3);
        mv.visitInsn(50);
        mv.visitTypeInsn(192, "org/ballerinalang/jvm/scheduling/Strand");
        mv.visitMethodInsn(184, initClass, funcName, String.format("(L%s;)L%s;", "org/ballerinalang/jvm/scheduling/Strand", "java/lang/Object"), false);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static boolean hasInitFunction(BIRNode.BIRPackage pkg) {
        for (BIRNode.BIRFunction func : pkg.functions) {
            if (func == null || !JvmMethodGen.isModuleInitFunction(pkg, func)) continue;
            return true;
        }
        return false;
    }

    private static boolean isModuleInitFunction(BIRNode.BIRPackage module, BIRNode.BIRFunction func) {
        String moduleInit = JvmMethodGen.getModuleInitFuncName(module);
        return func.name.value.equals(moduleInit);
    }

    private static String getModuleInitFuncName(BIRNode.BIRPackage module) {
        return JvmMethodGen.calculateModuleInitFuncName(JvmPackageGen.packageToModuleId(module));
    }

    private static String calculateModuleInitFuncName(PackageID id) {
        return JvmMethodGen.calculateModuleSpecialFuncName(id, "<init>");
    }

    private static String calculateModuleSpecialFuncName(PackageID id, String funcSuffix) {
        String orgName = id.orgName.value;
        String moduleName = id.name.value;
        String version = id.version.value;
        String funcName = moduleName.equals(".") ? ".." + funcSuffix : (version.equals("") ? moduleName + "." + funcSuffix : moduleName + ":" + version + "." + funcSuffix);
        if (!orgName.equalsIgnoreCase("$anon")) {
            funcName = orgName + "/" + funcName;
        }
        return funcName;
    }

    static void addInitAndTypeInitInstructions(BIRNode.BIRPackage pkg, BIRNode.BIRFunction func) {
        ArrayList<BIRNode.BIRBasicBlock> basicBlocks = new ArrayList<BIRNode.BIRBasicBlock>();
        nextId = -1;
        BIRNode.BIRBasicBlock nextBB = new BIRNode.BIRBasicBlock(JvmMethodGen.getNextBBId());
        basicBlocks.add(nextBB);
        PackageID modID = JvmPackageGen.packageToModuleId(pkg);
        BIRNode.BIRBasicBlock typeOwnerCreateBB = new BIRNode.BIRBasicBlock(JvmMethodGen.getNextBBId());
        basicBlocks.add(typeOwnerCreateBB);
        nextBB.terminator = new BIRTerminator.Call(null, InstructionKind.CALL, false, modID, new Name("$currentModuleInit"), new ArrayList<BIROperand>(), null, typeOwnerCreateBB);
        if (func.basicBlocks.size() == 0) {
            typeOwnerCreateBB.terminator = new BIRTerminator.Return(func.pos);
            func.basicBlocks = basicBlocks;
            return;
        }
        typeOwnerCreateBB.terminator = new BIRTerminator.GOTO(null, func.basicBlocks.get(0));
        basicBlocks.addAll(func.basicBlocks);
        func.basicBlocks = basicBlocks;
    }

    static void enrichPkgWithInitializers(Map<String, JvmPackageGen.JavaClass> jvmClassMap, String typeOwnerClass, BIRNode.BIRPackage pkg, List<PackageID> depModArray) {
        JvmPackageGen.JavaClass javaClass = jvmClassMap.get(typeOwnerClass);
        BIRNode.BIRFunction initFunc = JvmMethodGen.generateDepModInit(depModArray, pkg, "$moduleInit", "<init>");
        javaClass.functions.add(initFunc);
        pkg.functions.add(initFunc);
        BIRNode.BIRFunction startFunc = JvmMethodGen.generateDepModInit(depModArray, pkg, "$moduleStart", "<start>");
        javaClass.functions.add(startFunc);
        pkg.functions.add(startFunc);
    }

    private static BIRNode.BIRFunction generateDepModInit(List<PackageID> imprtMods, BIRNode.BIRPackage pkg, String funcName, String initName) {
        nextId = -1;
        nextVarId = -1;
        BIRNode.BIRVariableDcl retVar = new BIRNode.BIRVariableDcl(null, errorOrNilType, new Name("%ret"), VarScope.FUNCTION, VarKind.RETURN, "");
        BIROperand retVarRef = new BIROperand(retVar);
        BIRNode.BIRFunction modInitFunc = new BIRNode.BIRFunction(null, new Name(funcName), 0, new BInvokableType(Collections.emptyList(), null, errorOrNilType, null), null, 0, null);
        modInitFunc.localVars.add(retVar);
        BIRNode.BIRBasicBlock ignoreNextBB = JvmMethodGen.addAndGetNextBasicBlock(modInitFunc);
        BIRNode.BIRVariableDcl boolVal = JvmMethodGen.addAndGetNextVar(modInitFunc, JvmPackageGen.symbolTable.booleanType);
        BIROperand boolRef = new BIROperand(boolVal);
        for (PackageID id : imprtMods) {
            String initFuncName = JvmMethodGen.calculateModuleSpecialFuncName(id, initName);
            BIRNode.BIRBasicBlock bIRBasicBlock = JvmMethodGen.addCheckedInvocation(modInitFunc, id, initFuncName, retVarRef, boolRef);
        }
        PackageID currentModId = JvmPackageGen.packageToModuleId(pkg);
        String currentInitFuncName = JvmMethodGen.calculateModuleSpecialFuncName(currentModId, initName);
        BIRNode.BIRBasicBlock lastBB = JvmMethodGen.addCheckedInvocation(modInitFunc, currentModId, currentInitFuncName, retVarRef, boolRef);
        lastBB.terminator = new BIRTerminator.Return(null);
        return modInitFunc;
    }

    private static Name getNextBBId() {
        String bbIdPrefix = "genBB";
        return new Name(bbIdPrefix + ++nextId);
    }

    static Name getNextVarId() {
        String varIdPrefix = "%";
        return new Name(varIdPrefix + ++nextVarId);
    }

    private static BIRNode.BIRBasicBlock addCheckedInvocation(BIRNode.BIRFunction func, PackageID modId, String initFuncName, BIROperand retVar, BIROperand boolRef) {
        BIRNode.BIRBasicBlock lastBB = func.basicBlocks.get(func.basicBlocks.size() - 1);
        BIRNode.BIRBasicBlock nextBB = JvmMethodGen.addAndGetNextBasicBlock(func);
        if (modId.orgName.value.equals("ballerina") && modId.name.value.equals("lang.annotations")) {
            lastBB.terminator = new BIRTerminator.Call(null, InstructionKind.CALL, false, modId, new Name(initFuncName), Collections.emptyList(), null, nextBB);
            return nextBB;
        }
        lastBB.terminator = new BIRTerminator.Call(null, InstructionKind.CALL, false, modId, new Name(initFuncName), Collections.emptyList(), retVar, nextBB);
        BIRNonTerminator.TypeTest typeTest = new BIRNonTerminator.TypeTest(null, JvmPackageGen.symbolTable.errorType, boolRef, retVar);
        nextBB.instructions.add(typeTest);
        BIRNode.BIRBasicBlock trueBB = JvmMethodGen.addAndGetNextBasicBlock(func);
        BIRNode.BIRBasicBlock retBB = JvmMethodGen.addAndGetNextBasicBlock(func);
        retBB.terminator = new BIRTerminator.Return(null);
        trueBB.terminator = new BIRTerminator.GOTO(null, retBB);
        BIRNode.BIRBasicBlock falseBB = JvmMethodGen.addAndGetNextBasicBlock(func);
        nextBB.terminator = new BIRTerminator.Branch(null, boolRef, trueBB, falseBB);
        return falseBB;
    }

    private static BIRNode.BIRBasicBlock addAndGetNextBasicBlock(BIRNode.BIRFunction func) {
        BIRNode.BIRBasicBlock nextbb = new BIRNode.BIRBasicBlock(JvmMethodGen.getNextBBId());
        func.basicBlocks.add(nextbb);
        return nextbb;
    }

    private static BIRNode.BIRVariableDcl addAndGetNextVar(BIRNode.BIRFunction func, BType typeVal) {
        BIRNode.BIRVariableDcl nextLocalVar = new BIRNode.BIRVariableDcl(typeVal, JvmMethodGen.getNextVarId(), VarScope.FUNCTION, VarKind.LOCAL);
        func.localVars.add(nextLocalVar);
        return nextLocalVar;
    }

    private static void generateAnnotLoad(MethodVisitor mv, @Nilable List<BIRNode.BIRTypeDefinition> typeDefs, String pkgName) {
        String typePkgName = ".";
        if (!"".equals(pkgName)) {
            typePkgName = pkgName;
        }
        for (BIRNode.BIRTypeDefinition optionalTypeDef : typeDefs) {
            if (optionalTypeDef.isBuiltin) continue;
            BIRNode.BIRTypeDefinition typeDef = JvmMethodGen.getTypeDef(optionalTypeDef);
            BType bType = typeDef.type;
            if (bType.tag == 31 || bType instanceof BServiceType) continue;
            JvmMethodGen.loadAnnots(mv, typePkgName, typeDef);
        }
    }

    private static void loadAnnots(MethodVisitor mv, String pkgName, BIRNode.BIRTypeDefinition typeDef) {
        String pkgClassName = pkgName.equals(".") || pkgName.equals("") ? "___init" : JvmPackageGen.lookupGlobalVarClassName(pkgName, "$annotation_data");
        mv.visitFieldInsn(178, pkgClassName, "$annotation_data", String.format("L%s;", "org/ballerinalang/jvm/values/MapValue"));
        JvmTypeGen.loadLocalType(mv, typeDef);
        mv.visitMethodInsn(184, String.format("%s", "org/ballerinalang/jvm/AnnotationUtils"), "processAnnotations", String.format("(L%s;L%s;)V", "org/ballerinalang/jvm/values/MapValue", "org/ballerinalang/jvm/types/BType"), false);
    }

    static void generateFrameClasses(BIRNode.BIRPackage pkg, Map<String, byte[]> pkgEntries) {
        for (BIRNode.BIRFunction func : pkg.functions) {
            JvmMethodGen.generateFrameClassForFunction(pkg, func, pkgEntries, null);
        }
        for (BIRNode.BIRTypeDefinition typeDef : pkg.typeDefs) {
            List<BIRNode.BIRFunction> attachedFuncs = typeDef.attachedFuncs;
            if (attachedFuncs == null) continue;
            BType attachedType = typeDef.type.tag == 12 ? null : typeDef.type;
            for (BIRNode.BIRFunction func : attachedFuncs) {
                JvmMethodGen.generateFrameClassForFunction(pkg, func, pkgEntries, attachedType);
            }
        }
    }

    private static void generateFrameClassForFunction(BIRNode.BIRPackage pkg, @Nilable BIRNode.BIRFunction func, Map<String, byte[]> pkgEntries, @Nilable BType attachedType) {
        String pkgName = JvmPackageGen.getPackageName(pkg.org.value, pkg.name.value);
        BIRNode.BIRFunction currentFunc = JvmMethodGen.getFunction(func);
        String frameClassName = JvmMethodGen.getFrameClassName(pkgName, currentFunc.name.value, attachedType);
        BallerinaClassWriter cw = new BallerinaClassWriter(2);
        if (currentFunc.pos != null && currentFunc.pos.src != null) {
            cw.visitSource(currentFunc.pos.src.cUnitName, null);
        }
        JvmPackageGen.currentClass = frameClassName;
        cw.visit(52, 33, frameClassName, null, "java/lang/Object", null);
        JvmMethodGen.generateDefaultConstructor(cw, "java/lang/Object");
        List<BIRNode.BIRVariableDcl> localVars = currentFunc.localVars;
        for (int k = 0; k < localVars.size(); ++k) {
            BIRNode.BIRVariableDcl localVar = JvmMethodGen.getVariableDcl(localVars.get(k));
            BType bType = localVar.type;
            String fieldName = localVar.name.value.replace("%", "_");
            JvmMethodGen.generateField(cw, bType, fieldName, false);
        }
        FieldVisitor fv = cw.visitField(1, "state", "I", null, null);
        fv.visitEnd();
        cw.visitEnd();
        pkgEntries.put(frameClassName + ".class", cw.toByteArray());
    }

    private static String getFrameClassName(String pkgName, String funcName, @Nilable BType attachedType) {
        String frameClassName = pkgName;
        if (attachedType != null) {
            if (attachedType.tag == 32) {
                frameClassName = frameClassName + JvmMethodGen.cleanupTypeName(JvmTerminatorGen.TerminatorGenerator.toNameString(attachedType)) + "_";
            } else if (attachedType instanceof BServiceType) {
                frameClassName = frameClassName + JvmMethodGen.cleanupTypeName(JvmTerminatorGen.TerminatorGenerator.toNameString(attachedType)) + "_";
            } else if (attachedType.tag == 12) {
                frameClassName = frameClassName + JvmMethodGen.cleanupTypeName(JvmTerminatorGen.TerminatorGenerator.toNameString(attachedType)) + "_";
            }
        }
        return frameClassName + JvmMethodGen.cleanupFunctionName(funcName) + "Frame";
    }

    static String cleanupTypeName(String name) {
        return name.replace("$", "_");
    }

    static String cleanupBalExt(String name) {
        return name.replace(".bal", "");
    }

    static String cleanupPathSeperators(String name) {
        return name.replace("\\", "/");
    }

    static void generateField(ClassWriter cw, BType bType, String fieldName, boolean isPackage) {
        String typeSig;
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            typeSig = "J";
        } else if (bType.tag == 2) {
            typeSig = "I";
        } else if (bType.tag == 3) {
            typeSig = "D";
        } else if (TypeTags.isStringTypeTag(bType.tag)) {
            typeSig = String.format("L%s;", JvmInstructionGen.isBString ? "org/ballerinalang/jvm/values/api/BString" : "java/lang/String");
        } else if (bType.tag == 4) {
            typeSig = String.format("L%s;", "org/ballerinalang/jvm/values/DecimalValue");
        } else if (bType.tag == 6) {
            typeSig = "Z";
        } else if (bType.tag == 10) {
            typeSig = String.format("L%s;", "java/lang/Object");
        } else if (bType.tag == 15) {
            typeSig = String.format("L%s;", "org/ballerinalang/jvm/values/MapValue");
        } else if (bType.tag == 9) {
            typeSig = String.format("L%s;", "org/ballerinalang/jvm/values/TableValue");
        } else if (bType.tag == 14) {
            typeSig = String.format("L%s;", "org/ballerinalang/jvm/values/StreamValue");
        } else if (bType.tag == 12) {
            typeSig = String.format("L%s;", "org/ballerinalang/jvm/values/MapValue");
        } else if (bType.tag == 19 || bType.tag == 29) {
            typeSig = String.format("L%s;", "org/ballerinalang/jvm/values/ArrayValue");
        } else if (bType.tag == 27) {
            typeSig = String.format("L%s;", "org/ballerinalang/jvm/values/ErrorValue");
        } else if (bType.tag == 30) {
            typeSig = String.format("L%s;", "org/ballerinalang/jvm/values/FutureValue");
        } else if (bType.tag == 32) {
            typeSig = String.format("L%s;", "org/ballerinalang/jvm/values/ObjectValue");
        } else if (TypeTags.isXMLTypeTag(bType.tag)) {
            typeSig = String.format("L%s;", "org/ballerinalang/jvm/values/XMLValue");
        } else if (bType.tag == 13) {
            typeSig = String.format("L%s;", "org/ballerinalang/jvm/values/TypedescValue");
        } else if (bType.tag == 17 || bType.tag == 11 || bType.tag == 20 || bType.tag == 7 || bType.tag == 31) {
            typeSig = String.format("L%s;", "java/lang/Object");
        } else if (bType.tag == 16) {
            typeSig = String.format("L%s;", "org/ballerinalang/jvm/values/FPValue");
        } else if (bType.tag == 35) {
            typeSig = String.format("L%s;", "org/ballerinalang/jvm/values/HandleValue");
        } else if (bType.tag == Integer.MAX_VALUE) {
            typeSig = InteropMethodGen.getJTypeSignature((JType)bType);
        } else {
            throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", bType));
        }
        FieldVisitor fv = isPackage ? cw.visitField(9, fieldName, typeSig, null, null) : cw.visitField(1, fieldName, typeSig, null, null);
        fv.visitEnd();
    }

    static void generateDefaultConstructor(ClassWriter cw, String ownerClass) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, ownerClass, "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private static void generateDiagnosticPos(DiagnosticPos pos, MethodVisitor mv) {
        if (pos != null && pos.sLine != Integer.MIN_VALUE) {
            Label label = new Label();
            mv.visitLabel(label);
            mv.visitLineNumber(pos.sLine, label);
        }
    }

    static String cleanupFunctionName(String functionName) {
        return functionName.replaceAll("[\\.:/<>]", "_");
    }

    public static BIRNode.BIRVariableDcl getVariableDcl(@Nilable BIRNode.BIRVariableDcl localVar) {
        if (localVar == null) {
            throw new BLangCompilerException("Invalid variable declarion");
        }
        return localVar;
    }

    static BIRNode.BIRFunctionParameter getFunctionParam(@Nilable BIRNode.BIRFunctionParameter localVar) {
        if (localVar == null) {
            throw new BLangCompilerException("Invalid function parameter");
        }
        return localVar;
    }

    static BIRNode.BIRBasicBlock getBasicBlock(@Nilable BIRNode.BIRBasicBlock bb) {
        if (bb == null) {
            throw new BLangCompilerException("Invalid basic block");
        }
        return bb;
    }

    static BIRNode.BIRFunction getFunction(@Nilable BIRNode.BIRFunction bfunction) {
        if (bfunction == null) {
            throw new BLangCompilerException("Invalid function");
        }
        return bfunction;
    }

    static BIRNode.BIRTypeDefinition getTypeDef(@Nilable BIRNode.BIRTypeDefinition typeDef) {
        if (typeDef == null) {
            throw new BLangCompilerException("Invalid type definition");
        }
        return typeDef;
    }

    static BField getObjectField(@Nilable BField objectField) {
        if (objectField == null) {
            throw new BLangCompilerException("Invalid object field");
        }
        return objectField;
    }

    static BField getRecordField(@Nilable BField recordField) {
        if (recordField != null) {
            return recordField;
        }
        throw new BLangCompilerException("Invalid record field");
    }

    static boolean isExternFunc(BIRNode.BIRFunction func) {
        return (func.flags & 2) == 2;
    }

    private static BIROperand getVarRef(@Nilable BIROperand varRef) {
        if (varRef == null) {
            throw new BLangCompilerException("Invalid variable reference");
        }
        return varRef;
    }

    static BType getType(@Nilable BType bType) {
        if (bType == null) {
            throw new BLangCompilerException("Invalid type");
        }
        return bType;
    }

    private static String getMapValueDesc(int count) {
        StringBuilder desc = new StringBuilder();
        for (int i = count; i > 0; --i) {
            desc.append("L").append("org/ballerinalang/jvm/values/MapValue").append(";");
        }
        return desc.toString();
    }

    static List<BIRNode.BIRFunction> getFunctions(List<BIRNode.BIRFunction> functions) {
        if (functions == null) {
            throw new BLangCompilerException(String.format("Invalid functions: %s", functions));
        }
        return functions;
    }

    private static void checkStrandCancelled(MethodVisitor mv, int localVarOffset) {
        mv.visitVarInsn(25, localVarOffset);
        mv.visitFieldInsn(180, "org/ballerinalang/jvm/scheduling/Strand", "cancel", "Z");
        Label notCancelledLabel = new Label();
        mv.visitJumpInsn(153, notCancelledLabel);
        mv.visitMethodInsn(184, "org/ballerinalang/jvm/BallerinaErrors", "createCancelledFutureError", String.format("()L%s;", "org/ballerinalang/jvm/values/ErrorValue"), false);
        mv.visitInsn(191);
        mv.visitLabel(notCancelledLabel);
    }

    static void generateModuleInitializer(ClassWriter cw, BIRNode.BIRPackage module) {
        String orgName = module.org.value;
        String moduleName = module.name.value;
        String version = module.version.value;
        String pkgName = JvmPackageGen.getPackageName(orgName, moduleName);
        MethodVisitor mv = cw.visitMethod(9, "$currentModuleInit", String.format("(L%s;)L%s;", "org/ballerinalang/jvm/scheduling/Strand", "java/lang/Object"), null, null);
        mv.visitCode();
        mv.visitMethodInsn(184, JvmTypeGen.typeOwnerClass, "$createTypes", "()V", false);
        mv.visitTypeInsn(187, JvmTypeGen.typeOwnerClass);
        mv.visitInsn(89);
        mv.visitMethodInsn(183, JvmTypeGen.typeOwnerClass, "<init>", "()V", false);
        mv.visitVarInsn(58, 1);
        mv.visitLdcInsn((Object)orgName);
        mv.visitLdcInsn((Object)moduleName);
        mv.visitLdcInsn((Object)version);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(184, String.format("%s", "org/ballerinalang/jvm/values/ValueCreator"), "addValueCreator", String.format("(L%s;L%s;L%s;L%s;)V", "java/lang/String", "java/lang/String", "java/lang/String", "org/ballerinalang/jvm/values/ValueCreator"), false);
        mv.visitInsn(1);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        BIRNode.BIRFunction func = new BIRNode.BIRFunction(null, new Name("$currentModuleInit"), 0, new BInvokableType(Collections.emptyList(), null, new BNilType(), null), new Name(""), 0, null);
        JvmPackageGen.birFunctionMap.put(pkgName + "$currentModuleInit", JvmPackageGen.getFunctionWrapper(func, orgName, moduleName, version, JvmTypeGen.typeOwnerClass));
    }

    static void generateExecutionStopMethod(ClassWriter cw, String initClass, BIRNode.BIRPackage module, List<PackageID> imprtMods) {
        String orgName = module.org.value;
        String moduleName = module.name.value;
        String version = module.version.value;
        String pkgName = JvmPackageGen.getPackageName(orgName, moduleName);
        MethodVisitor mv = cw.visitMethod(9, "$moduleStop", "()V", null, null);
        mv.visitCode();
        BalToJVMIndexMap indexMap = new BalToJVMIndexMap();
        JvmErrorGen.ErrorHandlerGenerator errorGen = new JvmErrorGen.ErrorHandlerGenerator(mv, indexMap, pkgName);
        BIRNode.BIRVariableDcl argsVar = new BIRNode.BIRVariableDcl(JvmPackageGen.symbolTable.anyType, new Name("schedulerVar"), VarScope.FUNCTION, VarKind.ARG);
        int schedulerIndex = indexMap.getIndex(argsVar);
        BIRNode.BIRVariableDcl futureVar = new BIRNode.BIRVariableDcl(JvmPackageGen.symbolTable.anyType, new Name("futureVar"), VarScope.FUNCTION, VarKind.ARG);
        int futureIndex = indexMap.getIndex(futureVar);
        mv.visitTypeInsn(187, "org/ballerinalang/jvm/scheduling/Scheduler");
        mv.visitInsn(89);
        mv.visitInsn(4);
        mv.visitInsn(3);
        mv.visitMethodInsn(183, "org/ballerinalang/jvm/scheduling/Scheduler", "<init>", "(IZ)V", false);
        mv.visitVarInsn(58, schedulerIndex);
        String stopFuncName = "<stop>";
        PackageID currentModId = JvmPackageGen.packageToModuleId(module);
        String fullFuncName = JvmMethodGen.calculateModuleSpecialFuncName(currentModId, stopFuncName);
        JvmMethodGen.scheduleStopMethod(mv, initClass, JvmMethodGen.cleanupFunctionName(fullFuncName), errorGen, indexMap, schedulerIndex, futureIndex);
        for (int i = imprtMods.size() - 1; i >= 0; --i) {
            PackageID id = imprtMods.get(i);
            fullFuncName = JvmMethodGen.calculateModuleSpecialFuncName(id, stopFuncName);
            JvmMethodGen.scheduleStopMethod(mv, initClass, JvmMethodGen.cleanupFunctionName(fullFuncName), errorGen, indexMap, schedulerIndex, futureIndex);
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        BIRNode.BIRFunction func = new BIRNode.BIRFunction(null, new Name("$moduleStop"), 0, new BInvokableType(Collections.emptyList(), null, new BNilType(), null), new Name(""), 0, null);
        JvmPackageGen.birFunctionMap.put(pkgName + "$moduleStop", JvmPackageGen.getFunctionWrapper(func, orgName, moduleName, version, JvmTypeGen.typeOwnerClass));
    }

    private static void scheduleStopMethod(MethodVisitor mv, String initClass, String stopFuncName, JvmErrorGen.ErrorHandlerGenerator errorGen, BalToJVMIndexMap indexMap, int schedulerIndex, int futureIndex) {
        String lambdaFuncName = "$lambda$" + stopFuncName;
        mv.visitVarInsn(25, schedulerIndex);
        mv.visitIntInsn(16, 1);
        mv.visitTypeInsn(189, "java/lang/Object");
        JvmMethodGen.createFunctionPointer(mv, initClass, lambdaFuncName, 0);
        mv.visitInsn(1);
        JvmTypeGen.loadType(mv, new BNilType());
        mv.visitMethodInsn(182, "org/ballerinalang/jvm/scheduling/Scheduler", "scheduleFunction", String.format("([L%s;L%s;L%s;L%s;)L%s;", "java/lang/Object", "org/ballerinalang/jvm/values/FPValue", "org/ballerinalang/jvm/scheduling/Strand", "org/ballerinalang/jvm/types/BType", "org/ballerinalang/jvm/values/FutureValue"), false);
        mv.visitVarInsn(58, futureIndex);
        mv.visitVarInsn(25, futureIndex);
        mv.visitFieldInsn(180, "org/ballerinalang/jvm/values/FutureValue", "strand", String.format("L%s;", "org/ballerinalang/jvm/scheduling/Strand"));
        mv.visitIntInsn(16, 100);
        mv.visitTypeInsn(189, "java/lang/Object");
        mv.visitFieldInsn(181, "org/ballerinalang/jvm/scheduling/Strand", "frames", String.format("[L%s;", "java/lang/Object"));
        mv.visitVarInsn(25, futureIndex);
        mv.visitFieldInsn(180, "org/ballerinalang/jvm/values/FutureValue", "strand", String.format("L%s;", "org/ballerinalang/jvm/scheduling/Strand"));
        mv.visitFieldInsn(180, "org/ballerinalang/jvm/scheduling/Strand", "scheduler", String.format("L%s;", "org/ballerinalang/jvm/scheduling/Scheduler"));
        mv.visitMethodInsn(182, "org/ballerinalang/jvm/scheduling/Scheduler", "start", "()V", false);
        mv.visitVarInsn(25, futureIndex);
        mv.visitFieldInsn(180, "org/ballerinalang/jvm/values/FutureValue", "panic", String.format("L%s;", "java/lang/Throwable"));
        Label labelIf = new Label();
        mv.visitJumpInsn(198, labelIf);
        mv.visitVarInsn(25, futureIndex);
        mv.visitFieldInsn(180, "org/ballerinalang/jvm/values/FutureValue", "panic", String.format("L%s;", "java/lang/Throwable"));
        mv.visitMethodInsn(184, "org/ballerinalang/jvm/util/RuntimeUtils", "silentlyLogBadSad", String.format("(L%s;)V", "java/lang/Throwable"), false);
        mv.visitLabel(labelIf);
    }

    private static void generateJavaCompatibilityCheck(MethodVisitor mv) {
        mv.visitLdcInsn((Object)JvmMethodGen.getJavaVersion());
        mv.visitMethodInsn(184, "org/ballerinalang/jvm/util/CompatibilityChecker", "verifyJavaCompatibility", String.format("(L%s;)V", "java/lang/String"), false);
    }

    private static String getJavaVersion() {
        String versionProperty = "java.version";
        String javaVersion = System.getProperty(versionProperty);
        if (javaVersion != null) {
            return javaVersion;
        }
        return "";
    }

    public static class BalToJVMIndexMap {
        private int localVarIndex = 0;
        private Map<String, Integer> jvmLocalVarIndexMap = new HashMap<String, Integer>();

        void add(BIRNode.BIRVariableDcl varDcl) {
            String varRefName = this.getVarRefName(varDcl);
            this.jvmLocalVarIndexMap.put(varRefName, this.localVarIndex);
            BType bType = varDcl.type;
            if (TypeTags.isIntegerTypeTag(bType.tag) || bType.tag == 3) {
                this.localVarIndex += 2;
            } else if (bType.tag == Integer.MAX_VALUE) {
                JType jType = (JType)bType;
                this.localVarIndex = jType.jTag == 5 || jType.jTag == 7 ? (this.localVarIndex += 2) : ++this.localVarIndex;
            } else {
                ++this.localVarIndex;
            }
        }

        private String getVarRefName(BIRNode.BIRVariableDcl varDcl) {
            return varDcl.name.value;
        }

        public int getIndex(BIRNode.BIRVariableDcl varDcl) {
            Integer index;
            String varRefName = this.getVarRefName(varDcl);
            if (!this.jvmLocalVarIndexMap.containsKey(varRefName)) {
                this.add(varDcl);
            }
            return (index = this.jvmLocalVarIndexMap.get(varRefName)) != null ? index : -1;
        }
    }
}

