/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.interop;

import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.util.diagnostic.DiagnosticCode;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JFieldMethod;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JInteropException;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JMethodKind;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JType;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.ParamTypeConstraint;

class JInterop {
    static final String INTEROP_ANNOT_ORG = "ballerina";
    static final String INTEROP_ANNOT_MODULE = "java";
    static final String CONSTRUCTOR_ANNOT_TAG = "Constructor";
    static final String METHOD_ANNOT_TAG = "Method";
    static final String FIELD_GET_ANNOT_TAG = "FieldGet";
    static final String FIELD_PUT_ANNOT_TAG = "FieldSet";
    static final String J_OBJECT_TNAME = Object.class.getTypeName();
    static final String J_STRING_TNAME = String.class.getTypeName();
    static final String J_BOOLEAN_OBJ_TNAME = Boolean.class.getTypeName();
    static final String J_INTEGER_OBJ_TNAME = Integer.class.getTypeName();
    static final String J_LONG_OBJ_TNAME = Long.class.getTypeName();
    static final String J_DOUBLE_OBJ_TNAME = Double.class.getTypeName();
    static final String J_PRIMITIVE_INT_TNAME = Integer.TYPE.getTypeName();
    static final String J_PRIMITIVE_LONG_TNAME = Long.TYPE.getTypeName();
    static final String J_PRIMITIVE_BYTE_TNAME = Byte.TYPE.getTypeName();
    static final String J_PRIMITIVE_SHORT_TNAME = Short.TYPE.getTypeName();
    static final String J_PRIMITIVE_CHAR_TNAME = Character.TYPE.getTypeName();
    static final String J_PRIMITIVE_FLOAT_TNAME = Float.TYPE.getTypeName();
    static final String J_PRIMITIVE_DOUBLE_TNAME = Double.TYPE.getTypeName();
    static final String J_PRIMITIVE_BOOLEAN_TNAME = Boolean.TYPE.getTypeName();
    static final String J_VOID_TNAME = Void.TYPE.getTypeName();

    JInterop() {
    }

    static JType getJType(Class<?> jTypeClass) {
        if (jTypeClass.isPrimitive()) {
            String primitiveName = jTypeClass.getName();
            return JType.getJTypeForPrimitive(primitiveName);
        }
        if (jTypeClass == Void.class) {
            throw new IllegalArgumentException("The Java Void type is not yet supported.");
        }
        if (jTypeClass.isArray()) {
            return JType.getJArrayTypeFromTypeName(jTypeClass.getComponentType().getName(), (byte)0);
        }
        JType.JRefType jRefType = new JType.JRefType(jTypeClass.getName().replace('.', '/'));
        jRefType.isArray = jTypeClass.isArray();
        jRefType.isInterface = jTypeClass.isInterface();
        return jRefType;
    }

    static String getMethodSig(Class<?> returnType, Class<?> ... parameterTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (Class<?> type : parameterTypes) {
            sb.append(JInterop.getSig(type));
        }
        sb.append(')');
        return sb.append(JInterop.getSig(returnType)).toString();
    }

    static String getSig(Class<?> c) {
        if (c.isPrimitive()) {
            if (Integer.TYPE == c) {
                return "I";
            }
            if (Long.TYPE == c) {
                return "J";
            }
            if (Boolean.TYPE == c) {
                return "Z";
            }
            if (Byte.TYPE == c) {
                return "B";
            }
            if (Short.TYPE == c) {
                return "S";
            }
            if (Character.TYPE == c) {
                return "C";
            }
            if (Float.TYPE == c) {
                return "F";
            }
            if (Double.TYPE == c) {
                return "D";
            }
            return "V";
        }
        if (Void.TYPE == c || Void.class == c) {
            return "V";
        }
        String className = c.getName().replace('.', '/');
        if (c.isArray()) {
            return className;
        }
        return 'L' + className + ';';
    }

    static ParamTypeConstraint[] buildParamTypeConstraints(List<JType> javaTypeConstraints, ClassLoader classLoader) {
        if (javaTypeConstraints == null) {
            return new ParamTypeConstraint[0];
        }
        ArrayList<ParamTypeConstraint> constraintList = new ArrayList<ParamTypeConstraint>();
        for (JType javaTypeConstraint : javaTypeConstraints) {
            constraintList.add(JInterop.buildParamTypeConstraint(javaTypeConstraint, classLoader));
        }
        return constraintList.toArray(new ParamTypeConstraint[0]);
    }

    private static ParamTypeConstraint buildParamTypeConstraint(JType javaTypeConstraint, ClassLoader classLoader) {
        switch (javaTypeConstraint.jTag) {
            case 10: {
                return JInterop.buildConstraintFromJavaRefType((JType.JRefType)javaTypeConstraint, classLoader);
            }
            case 9: {
                return JInterop.buildConstraintFromJavaArrayType((JType.JArrayType)javaTypeConstraint, classLoader);
            }
            case 12: {
                return ParamTypeConstraint.NO_CONSTRAINT;
            }
        }
        return JInterop.buildConstraintFromJavaPrimitiveType(javaTypeConstraint);
    }

    private static ParamTypeConstraint buildConstraintFromJavaRefType(JType.JRefType javaRefType, ClassLoader classLoader) {
        String constraintBValue = javaRefType.typeValue;
        return new ParamTypeConstraint(JInterop.loadClass(constraintBValue, classLoader));
    }

    private static ParamTypeConstraint buildConstraintFromJavaArrayType(JType.JArrayType jArrayType, ClassLoader classLoader) {
        String typeSig = JInterop.getJavaArrayTypeSig(jArrayType);
        return new ParamTypeConstraint(JInterop.loadClass(typeSig, classLoader));
    }

    private static String getJavaArrayTypeSig(JType.JArrayType jArrayType) {
        JType elementType = jArrayType.elementType;
        String elementTypeSig = "[";
        int jTag = elementType.jTag;
        elementTypeSig = jTag == 10 ? elementTypeSig + "L" + ((JType.JRefType)elementType).typeValue + ";" : (jTag == 9 ? elementTypeSig + JInterop.getJavaArrayTypeSig((JType.JArrayType)elementType) : elementTypeSig + JInterop.getSignatureFromJavaPrimitiveType(elementType));
        return elementTypeSig;
    }

    private static ParamTypeConstraint buildConstraintFromJavaPrimitiveType(JType primitiveTypeName) {
        Class<Comparable<Byte>> constraintClass;
        switch (primitiveTypeName.jTag) {
            case 1: {
                constraintClass = Byte.TYPE;
                break;
            }
            case 3: {
                constraintClass = Short.TYPE;
                break;
            }
            case 2: {
                constraintClass = Character.TYPE;
                break;
            }
            case 4: {
                constraintClass = Integer.TYPE;
                break;
            }
            case 5: {
                constraintClass = Long.TYPE;
                break;
            }
            case 6: {
                constraintClass = Float.TYPE;
                break;
            }
            case 7: {
                constraintClass = Double.TYPE;
                break;
            }
            case 8: {
                constraintClass = Boolean.TYPE;
                break;
            }
            default: {
                throw new JInteropException(DiagnosticCode.UNSUPPORTED_PRIMITIVE_TYPE, "Unsupported Java primitive type '" + primitiveTypeName + "'");
            }
        }
        return new ParamTypeConstraint(constraintClass);
    }

    private static String getSignatureFromJavaPrimitiveType(JType primitiveTypeName) {
        switch (primitiveTypeName.jTag) {
            case 1: {
                return "B";
            }
            case 3: {
                return "S";
            }
            case 2: {
                return "C";
            }
            case 4: {
                return "I";
            }
            case 5: {
                return "J";
            }
            case 6: {
                return "F";
            }
            case 7: {
                return "D";
            }
            case 8: {
                return "Z";
            }
        }
        throw new JInteropException(DiagnosticCode.UNSUPPORTED_PRIMITIVE_TYPE, "Unsupported Java primitive type '" + primitiveTypeName + "'");
    }

    static Class<?> loadClass(String className, ClassLoader classLoader) {
        try {
            return Class.forName(className.replace("/", "."), false, classLoader);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new JInteropException(DiagnosticCode.CLASS_NOT_FOUND, e.getMessage(), e);
        }
    }

    static JMethodKind getMethodKindFromAnnotTag(String annotTagRef) {
        if (CONSTRUCTOR_ANNOT_TAG.equals(annotTagRef)) {
            return JMethodKind.CONSTRUCTOR;
        }
        return JMethodKind.METHOD;
    }

    static JFieldMethod getFieldMethodFromAnnotTag(String annotTagRef) {
        if (FIELD_GET_ANNOT_TAG.equals(annotTagRef)) {
            return JFieldMethod.ACCESS;
        }
        return JFieldMethod.MUTATE;
    }

    static boolean isInteropAnnotationTag(String annotTag) {
        switch (annotTag) {
            case "Constructor": 
            case "Method": 
            case "FieldGet": 
            case "FieldSet": {
                return true;
            }
        }
        return false;
    }

    static boolean isMethodAnnotationTag(String annotTag) {
        return CONSTRUCTOR_ANNOT_TAG.equals(annotTag) || METHOD_ANNOT_TAG.equals(annotTag);
    }
}

