/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.lang3.StringEscapeUtils;
import org.ballerinalang.model.Whitespace;
import org.ballerinalang.model.elements.AttachPoint;
import org.ballerinalang.model.tree.CompilationUnitNode;
import org.ballerinalang.util.diagnostic.DiagnosticCode;
import org.wso2.ballerinalang.compiler.parser.BLangPackageBuilder;
import org.wso2.ballerinalang.compiler.parser.antlr4.BallerinaParser;
import org.wso2.ballerinalang.compiler.parser.antlr4.BallerinaParserBaseListener;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.FieldKind;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.NumericLiteralSupport;
import org.wso2.ballerinalang.compiler.util.QuoteType;
import org.wso2.ballerinalang.compiler.util.diagnotic.BDiagnosticSource;
import org.wso2.ballerinalang.compiler.util.diagnotic.BLangDiagnosticLogHelper;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class BLangParserListener
extends BallerinaParserBaseListener {
    private static final String KEYWORD_PUBLIC = "public";
    private static final String KEYWORD_KEY = "key";
    private BLangPackageBuilder pkgBuilder;
    private BDiagnosticSource diagnosticSrc;
    private BLangDiagnosticLogHelper dlog;
    private List<String> pkgNameComps;
    private String pkgVersion;
    private boolean isInErrorState = false;
    private Pattern pattern = Pattern.compile("\\\\u\\{([a-fA-F0-9]+)\\}");

    BLangParserListener(CompilerContext context, CompilationUnitNode compUnit, BDiagnosticSource diagnosticSource) {
        this.pkgBuilder = new BLangPackageBuilder(context, compUnit);
        this.diagnosticSrc = diagnosticSource;
        this.dlog = BLangDiagnosticLogHelper.getInstance(context);
    }

    @Override
    public void enterParameterList(BallerinaParser.ParameterListContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startVarList();
    }

    @Override
    public void exitParameter(BallerinaParser.ParameterContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addSimpleVar(this.getCurrentPos(ctx), this.getWS(ctx), ctx.Identifier().getText(), this.getCurrentPos(ctx.Identifier()), false, ctx.annotationAttachment().size(), ctx.PUBLIC() != null);
    }

    @Override
    public void enterFormalParameterList(BallerinaParser.FormalParameterListContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startVarList();
    }

    @Override
    public void exitFormalParameterList(BallerinaParser.FormalParameterListContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.endFormalParameterList(this.getWS(ctx));
    }

    @Override
    public void exitDefaultableParameter(BallerinaParser.DefaultableParameterContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addDefaultableParam(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void exitRestParameter(BallerinaParser.RestParameterContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addRestParam(this.getCurrentPos(ctx), this.getWS(ctx), ctx.Identifier().getText(), this.getCurrentPos(ctx.Identifier()), ctx.annotationAttachment().size());
    }

    @Override
    public void exitRestParameterTypeName(BallerinaParser.RestParameterTypeNameContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addRestParam(this.getCurrentPos(ctx), this.getWS(ctx), null, null, 0);
    }

    @Override
    public void exitParameterTypeName(BallerinaParser.ParameterTypeNameContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addSimpleVar(this.getCurrentPos(ctx), this.getWS(ctx), null, null, false, 0);
    }

    @Override
    public void enterCompilationUnit(BallerinaParser.CompilationUnitContext ctx) {
    }

    @Override
    public void exitCompilationUnit(BallerinaParser.CompilationUnitContext ctx) {
        this.pkgBuilder.endCompilationUnit(this.getWS(ctx));
    }

    @Override
    public void exitPackageName(BallerinaParser.PackageNameContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgNameComps = new ArrayList<String>();
        ctx.Identifier().forEach(e -> this.pkgNameComps.add(e.getText()));
        this.pkgVersion = ctx.version() != null ? ctx.version().versionPattern().getText() : null;
    }

    @Override
    public void exitImportDeclaration(BallerinaParser.ImportDeclarationContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        String alias = ctx.Identifier() != null ? ctx.Identifier().getText() : null;
        BallerinaParser.OrgNameContext orgNameContext = ctx.orgName();
        if (orgNameContext == null) {
            this.pkgBuilder.addImportPackageDeclaration(this.getCurrentPos(ctx), this.getWS(ctx), null, this.pkgNameComps, this.pkgVersion, alias);
        } else {
            this.pkgBuilder.addImportPackageDeclaration(this.getCurrentPos(ctx), this.getWS(ctx), orgNameContext.getText(), this.pkgNameComps, this.pkgVersion, alias);
        }
    }

    @Override
    public void exitServiceDefinition(BallerinaParser.ServiceDefinitionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        DiagnosticPos serviceDefPos = this.getCurrentPos(ctx);
        String serviceVarName = ctx.Identifier() != null ? ctx.Identifier().getText() : null;
        DiagnosticPos varPos = ctx.Identifier() != null ? this.getCurrentPos(ctx.Identifier()) : serviceDefPos;
        this.pkgBuilder.endServiceDef(serviceDefPos, this.getWS(ctx), serviceVarName, varPos, false);
    }

    @Override
    public void enterServiceBody(BallerinaParser.ServiceBodyContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startServiceDef(this.getCurrentPos(ctx));
        this.pkgBuilder.startObjectType();
    }

    @Override
    public void exitServiceBody(BallerinaParser.ServiceBodyContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        boolean isFieldAnalyseRequired = ctx.parent.parent instanceof BallerinaParser.GlobalVariableDefinitionContext || ctx.parent.parent instanceof BallerinaParser.ReturnParameterContext || ctx.parent.parent.parent.parent instanceof BallerinaParser.TypeDefinitionContext;
        this.pkgBuilder.addObjectType(this.getCurrentPos(ctx), this.getWS(ctx), isFieldAnalyseRequired, false, false, false, true);
    }

    @Override
    public void enterBlockFunctionBody(BallerinaParser.BlockFunctionBodyContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startBlockFunctionBody();
    }

    @Override
    public void exitBlockFunctionBody(BallerinaParser.BlockFunctionBodyContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.endBlockFunctionBody(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void enterExprFunctionBody(BallerinaParser.ExprFunctionBodyContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startExprFunctionBody();
    }

    @Override
    public void exitExprFunctionBody(BallerinaParser.ExprFunctionBodyContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.endExprFunctionBody(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void enterExternalFunctionBody(BallerinaParser.ExternalFunctionBodyContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startExternFunctionBody();
    }

    @Override
    public void exitExternalFunctionBody(BallerinaParser.ExternalFunctionBodyContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.endExternalFunctionBody(ctx.annotationAttachment().size(), this.getWS(ctx));
    }

    @Override
    public void enterFunctionDefinition(BallerinaParser.FunctionDefinitionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        int annotCount = ((BallerinaParser.CompilationUnitContext)ctx.parent.parent).annotationAttachment().size();
        this.pkgBuilder.startFunctionDef(annotCount, false);
    }

    @Override
    public void exitFunctionDefinition(BallerinaParser.FunctionDefinitionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        String funcName = ctx.anyIdentifierName().getText();
        boolean publicFunc = ctx.PUBLIC() != null;
        boolean privateFunc = ctx.PRIVATE() != null;
        boolean remoteFunc = ctx.REMOTE() != null;
        boolean nativeFunc = ctx.functionDefinitionBody().externalFunctionBody() != null;
        this.pkgBuilder.endFunctionDefinition(this.getCurrentPos(ctx), this.getWS(ctx), funcName, this.getCurrentPos(ctx.anyIdentifierName()), publicFunc, remoteFunc, nativeFunc, privateFunc, false);
    }

    @Override
    public void enterExplicitAnonymousFunctionExpr(BallerinaParser.ExplicitAnonymousFunctionExprContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startLambdaFunctionDef(this.diagnosticSrc.pkgID);
    }

    @Override
    public void exitExplicitAnonymousFunctionExpr(BallerinaParser.ExplicitAnonymousFunctionExprContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addLambdaFunctionDef(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void enterInferAnonymousFunctionExpr(BallerinaParser.InferAnonymousFunctionExprContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startVarList();
    }

    @Override
    public void exitInferAnonymousFunctionExpression(BallerinaParser.InferAnonymousFunctionExpressionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addArrowFunctionDef(this.getCurrentPos(ctx), this.getWS(ctx), this.diagnosticSrc.pkgID);
    }

    @Override
    public void exitInferParamList(BallerinaParser.InferParamListContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addWSForInferParamList(this.getWS(ctx));
    }

    @Override
    public void exitInferParam(BallerinaParser.InferParamContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addVarWithoutType(this.getCurrentPos(ctx), this.getWS(ctx), ctx.Identifier().getText(), this.getCurrentPos(ctx.Identifier()), false, 0);
    }

    @Override
    public void exitFunctionSignature(BallerinaParser.FunctionSignatureContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.endFunctionSignature(this.getCurrentPos(ctx), this.getWS(ctx), ctx.formalParameterList() != null, ctx.returnParameter() != null, ctx.formalParameterList() != null && ctx.formalParameterList().restParameter() != null);
    }

    @Override
    public void exitFiniteType(BallerinaParser.FiniteTypeContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.endFiniteType(this.getWS(ctx));
    }

    @Override
    public void exitTypeDefinition(BallerinaParser.TypeDefinitionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        boolean publicObject = ctx.PUBLIC() != null;
        this.pkgBuilder.endTypeDefinition(this.getCurrentPos(ctx), this.getWS(ctx), ctx.Identifier().getText(), this.getCurrentPos(ctx.Identifier()), publicObject);
    }

    @Override
    public void enterObjectBody(BallerinaParser.ObjectBodyContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startObjectType();
    }

    @Override
    public void exitObjectBody(BallerinaParser.ObjectBodyContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        boolean isAnonymous = !(ctx.parent.parent instanceof BallerinaParser.FiniteTypeUnitContext) || ctx.parent.parent instanceof BallerinaParser.FiniteTypeUnitContext && ctx.parent.parent.parent instanceof BallerinaParser.FiniteTypeContext && ctx.parent.parent.parent.getChildCount() > 1;
        boolean isFieldAnalyseRequired = ctx.parent.parent instanceof BallerinaParser.GlobalVariableDefinitionContext || ctx.parent.parent instanceof BallerinaParser.ReturnParameterContext || ctx.parent.parent.parent.parent instanceof BallerinaParser.TypeDefinitionContext;
        boolean isAbstract = ((BallerinaParser.ObjectTypeNameLabelContext)ctx.parent).ABSTRACT() != null;
        boolean isClient = ((BallerinaParser.ObjectTypeNameLabelContext)ctx.parent).CLIENT() != null;
        this.pkgBuilder.addObjectType(this.getCurrentPos(ctx), this.getWS(ctx), isFieldAnalyseRequired, isAnonymous, isAbstract, isClient, false);
    }

    @Override
    public void exitObjectTypeNameLabel(BallerinaParser.ObjectTypeNameLabelContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addObjectTypeName(this.getWS(ctx));
    }

    @Override
    public void exitTypeReference(BallerinaParser.TypeReferenceContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addTypeReference(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void exitFieldDefinition(BallerinaParser.FieldDefinitionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        DiagnosticPos currentPos = this.getCurrentPos(ctx);
        Set<Whitespace> ws = this.getWS(ctx);
        String name = ctx.Identifier().getText();
        DiagnosticPos identifierPos = this.getCurrentPos(ctx.Identifier());
        boolean exprAvailable = ctx.expression() != null;
        boolean isOptional = ctx.QUESTION_MARK() != null;
        boolean markdownExists = ctx.documentationString() != null;
        this.pkgBuilder.addFieldVariable(currentPos, ws, name, identifierPos, exprAvailable, ctx.annotationAttachment().size(), false, isOptional, markdownExists);
    }

    @Override
    public void exitObjectFieldDefinition(BallerinaParser.ObjectFieldDefinitionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        DiagnosticPos currentPos = this.getCurrentPos(ctx);
        Set<Whitespace> ws = this.getWS(ctx);
        String name = ctx.Identifier().getText();
        DiagnosticPos identifierPos = this.getCurrentPos(ctx.Identifier());
        boolean exprAvailable = ctx.expression() != null;
        int annotationCount = ctx.annotationAttachment().size();
        boolean isPrivate = ctx.PRIVATE() != null;
        boolean isPublic = ctx.PUBLIC() != null;
        boolean markdownExists = ctx.documentationString() != null;
        this.pkgBuilder.addObjectFieldVariable(currentPos, ws, name, identifierPos, exprAvailable, annotationCount, isPrivate, isPublic, markdownExists);
    }

    @Override
    public void enterMethodDeclaration(BallerinaParser.MethodDeclarationContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startObjectFunctionDef();
    }

    @Override
    public void enterMethodDefinition(BallerinaParser.MethodDefinitionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startObjectFunctionDef();
    }

    @Override
    public void exitMethodDefinition(BallerinaParser.MethodDefinitionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        String funcName = ctx.anyIdentifierName().getText();
        DiagnosticPos funcNamePos = this.getCurrentPos(ctx.anyIdentifierName());
        boolean publicFunc = ctx.PUBLIC() != null;
        boolean isPrivate = ctx.PRIVATE() != null;
        boolean remoteFunc = ctx.REMOTE() != null;
        boolean resourceFunc = ctx.RESOURCE() != null;
        boolean markdownDocExists = ctx.documentationString() != null;
        this.pkgBuilder.endObjectAttachedFunctionDef(this.getCurrentPos(ctx), this.getWS(ctx), funcName, funcNamePos, publicFunc, isPrivate, remoteFunc, resourceFunc, false, markdownDocExists, ctx.annotationAttachment().size());
    }

    @Override
    public void exitMethodDeclaration(BallerinaParser.MethodDeclarationContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        String funcName = ctx.anyIdentifierName().getText();
        DiagnosticPos funcNamePos = this.getCurrentPos(ctx.anyIdentifierName());
        boolean isPublic = ctx.PUBLIC() != null;
        boolean isPrivate = ctx.PRIVATE() != null;
        boolean remoteFunc = ctx.REMOTE() != null;
        boolean resourceFunc = ctx.RESOURCE() != null;
        boolean markdownDocExists = ctx.documentationString() != null;
        this.pkgBuilder.endObjectAttachedFunctionDef(this.getCurrentPos(ctx), this.getWS(ctx), funcName, funcNamePos, isPublic, isPrivate, remoteFunc, resourceFunc, true, markdownDocExists, ctx.annotationAttachment().size());
    }

    @Override
    public void enterAnnotationDefinition(BallerinaParser.AnnotationDefinitionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startAnnotationDef(this.getCurrentPos(ctx));
    }

    @Override
    public void exitAnnotationDefinition(BallerinaParser.AnnotationDefinitionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        boolean publicAnnotation = KEYWORD_PUBLIC.equals(ctx.getChild(0).getText());
        boolean isTypeAttached = ctx.typeName() != null;
        boolean isConst = ctx.CONST() != null;
        this.pkgBuilder.endAnnotationDef(this.getWS(ctx), ctx.Identifier().getText(), this.getCurrentPos(ctx.Identifier()), publicAnnotation, isTypeAttached, isConst);
    }

    @Override
    public void exitConstantDefinition(BallerinaParser.ConstantDefinitionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        boolean isPublic = ctx.PUBLIC() != null;
        boolean isTypeAvailable = ctx.typeName() != null;
        this.pkgBuilder.addConstant(this.getCurrentPos(ctx), this.getWS(ctx), ctx.Identifier().getText(), this.getCurrentPos(ctx.Identifier()), isPublic, isTypeAvailable);
    }

    @Override
    public void exitConstDivMulModExpression(BallerinaParser.ConstDivMulModExpressionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.createBinaryExpr(this.getCurrentPos(ctx), this.getWS(ctx), ctx.getChild(1).getText());
    }

    @Override
    public void exitConstAddSubExpression(BallerinaParser.ConstAddSubExpressionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.createBinaryExpr(this.getCurrentPos(ctx), this.getWS(ctx), ctx.getChild(1).getText());
    }

    @Override
    public void exitConstGroupExpression(BallerinaParser.ConstGroupExpressionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.createGroupExpression(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void exitGlobalVariableDefinition(BallerinaParser.GlobalVariableDefinitionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        boolean isPublic = ctx.PUBLIC() != null;
        boolean isFinal = ctx.FINAL() != null;
        boolean isDeclaredWithVar = ctx.VAR() != null;
        boolean isExpressionAvailable = ctx.expression() != null;
        boolean isListenerVar = ctx.LISTENER() != null;
        boolean isTypeNameProvided = ctx.typeName() != null;
        this.pkgBuilder.addGlobalVariable(this.getCurrentPos(ctx), this.getWS(ctx), ctx.Identifier().getText(), this.getCurrentPos(ctx.Identifier()), isPublic, isFinal, isDeclaredWithVar, isExpressionAvailable, isListenerVar, isTypeNameProvided);
    }

    @Override
    public void exitAttachmentPoint(BallerinaParser.AttachmentPointContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        AttachPoint attachPoint = ctx.dualAttachPoint() != null ? (ctx.dualAttachPoint().SOURCE() != null ? AttachPoint.getAttachmentPoint(ctx.dualAttachPoint().dualAttachPointIdent().getText(), true) : AttachPoint.getAttachmentPoint(ctx.getText(), false)) : AttachPoint.getAttachmentPoint(ctx.sourceOnlyAttachPoint().sourceOnlyAttachPointIdent().getText(), true);
        this.pkgBuilder.addAttachPoint(attachPoint, this.getWS(ctx));
    }

    @Override
    public void enterWorkerDeclaration(BallerinaParser.WorkerDeclarationContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startWorker(this.diagnosticSrc.pkgID);
    }

    @Override
    public void exitWorkerDeclaration(BallerinaParser.WorkerDeclarationContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        String workerName = null;
        DiagnosticPos workerNamePos = null;
        if (ctx.workerDefinition() != null) {
            workerName = BLangPackageBuilder.escapeQuotedIdentifier(ctx.workerDefinition().Identifier().getText());
            workerNamePos = this.getCurrentPos(ctx.workerDefinition().Identifier());
        }
        boolean retParamsAvail = ctx.workerDefinition().returnParameter() != null;
        int numAnnotations = ctx.annotationAttachment().size();
        this.pkgBuilder.addWorker(this.getCurrentPos(ctx), this.getWS(ctx), workerName, workerNamePos, retParamsAvail, numAnnotations);
    }

    @Override
    public void exitWorkerDefinition(BallerinaParser.WorkerDefinitionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.attachWorkerWS(this.getWS(ctx));
    }

    @Override
    public void exitArrayTypeNameLabel(BallerinaParser.ArrayTypeNameLabelContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        int index = 1;
        int dimensions = 0;
        ArrayList<Integer> sizes = new ArrayList<Integer>();
        List children = ctx.children;
        while (index < children.size()) {
            if (((ParseTree)children.get(index)).getText().equals("[")) {
                if (((ParseTree)children.get(index + 1)).getText().equals("]")) {
                    sizes.add(-1);
                    index += 2;
                } else if (((ParseTree)children.get(index + 1)).getText().equals("*")) {
                    sizes.add(-2);
                    ++index;
                } else {
                    sizes.add(Integer.parseInt(((ParseTree)children.get(index + 1)).getText()));
                    ++index;
                }
                ++dimensions;
                continue;
            }
            ++index;
        }
        Collections.reverse(sizes);
        this.pkgBuilder.addArrayType(this.getCurrentPos(ctx), this.getWS(ctx), dimensions, sizes.stream().mapToInt(val -> val).toArray());
    }

    @Override
    public void exitUnionTypeNameLabel(BallerinaParser.UnionTypeNameLabelContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addUnionType(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void exitTupleTypeNameLabel(BallerinaParser.TupleTypeNameLabelContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addTupleType(this.getCurrentPos(ctx), this.getWS(ctx), ctx.tupleTypeDescriptor().typeName().size(), ctx.tupleTypeDescriptor().tupleRestDescriptor() != null);
    }

    @Override
    public void exitNullableTypeNameLabel(BallerinaParser.NullableTypeNameLabelContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.markTypeNodeAsNullable(this.getWS(ctx));
    }

    @Override
    public void exitGroupTypeNameLabel(BallerinaParser.GroupTypeNameLabelContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.markTypeNodeAsGrouped(this.getWS(ctx));
    }

    @Override
    public void enterInclusiveRecordTypeDescriptor(BallerinaParser.InclusiveRecordTypeDescriptorContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startRecordType();
    }

    @Override
    public void exitInclusiveRecordTypeDescriptor(BallerinaParser.InclusiveRecordTypeDescriptorContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        boolean isAnonymous = !(ctx.parent.parent instanceof BallerinaParser.FiniteTypeUnitContext);
        boolean isFieldAnalyseRequired = ctx.parent.parent instanceof BallerinaParser.GlobalVariableDefinitionContext || ctx.parent.parent instanceof BallerinaParser.ReturnParameterContext || ctx.parent.parent.parent.parent instanceof BallerinaParser.TypeDefinitionContext;
        this.pkgBuilder.addRecordType(this.getCurrentPos(ctx), this.getWS(ctx), isFieldAnalyseRequired, isAnonymous, false, false);
    }

    @Override
    public void enterExclusiveRecordTypeDescriptor(BallerinaParser.ExclusiveRecordTypeDescriptorContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startRecordType();
    }

    @Override
    public void exitExclusiveRecordTypeDescriptor(BallerinaParser.ExclusiveRecordTypeDescriptorContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        boolean isAnonymous = !(ctx.parent.parent instanceof BallerinaParser.FiniteTypeUnitContext);
        boolean isFieldAnalyseRequired = ctx.parent.parent instanceof BallerinaParser.GlobalVariableDefinitionContext || ctx.parent.parent instanceof BallerinaParser.ReturnParameterContext || ctx.parent.parent.parent.parent instanceof BallerinaParser.TypeDefinitionContext;
        boolean hasRestField = ctx.recordRestFieldDefinition() != null;
        this.pkgBuilder.addRecordType(this.getCurrentPos(ctx), this.getWS(ctx), isFieldAnalyseRequired, isAnonymous, hasRestField, true);
    }

    @Override
    public void exitSimpleTypeName(BallerinaParser.SimpleTypeNameContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        if (ctx.referenceTypeName() != null || ctx.valueTypeName() != null) {
            return;
        }
        this.pkgBuilder.addValueType(this.getCurrentPos(ctx), this.getWS(ctx), ctx.getChild(0).getText());
    }

    @Override
    public void exitUserDefineTypeName(BallerinaParser.UserDefineTypeNameContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addUserDefineType(this.getWS(ctx));
    }

    @Override
    public void exitValueTypeName(BallerinaParser.ValueTypeNameContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addValueType(this.getCurrentPos(ctx), this.getWS(ctx), ctx.getText());
    }

    @Override
    public void exitBuiltInReferenceTypeName(BallerinaParser.BuiltInReferenceTypeNameContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        if (ctx.functionTypeName() != null) {
            return;
        }
        if (ctx.errorTypeName() != null) {
            return;
        }
        if (ctx.streamTypeName() != null) {
            return;
        }
        String typeName = ctx.getChild(0).getText();
        DiagnosticPos pos = this.getCurrentPos(ctx);
        if (ctx.typeName() != null) {
            this.pkgBuilder.addConstraintTypeWithTypeName(pos, this.getWS(ctx), typeName);
        } else {
            this.pkgBuilder.addBuiltInReferenceType(pos, this.getWS(ctx), typeName);
        }
    }

    @Override
    public void exitStreamTypeName(BallerinaParser.StreamTypeNameContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addStreamTypeWithTypeName(this.getCurrentPos(ctx), this.getWS(ctx), ctx.typeName(0) != null, ctx.typeName(1) != null);
    }

    @Override
    public void enterErrorTypeName(BallerinaParser.ErrorTypeNameContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startErrorType();
    }

    @Override
    public void exitErrorTypeName(BallerinaParser.ErrorTypeNameContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        boolean reasonTypeExists = !ctx.typeName().isEmpty();
        boolean detailsTypeExists = ctx.typeName().size() > 1;
        boolean isAnonymous = !(ctx.parent.parent.parent.parent.parent.parent instanceof BallerinaParser.FiniteTypeContext) && reasonTypeExists;
        this.pkgBuilder.addErrorType(this.getCurrentPos(ctx), this.getWS(ctx), reasonTypeExists, detailsTypeExists, isAnonymous);
    }

    @Override
    public void exitFunctionTypeName(BallerinaParser.FunctionTypeNameContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        boolean paramsAvail = false;
        boolean retParamAvail = false;
        boolean restParamAvail = false;
        if (ctx.parameterList() != null) {
            boolean bl = paramsAvail = ctx.parameterList().parameter().size() > 0;
            if (ctx.parameterList().restParameter() != null) {
                restParamAvail = true;
            }
        } else if (ctx.parameterTypeNameList() != null) {
            boolean bl = paramsAvail = ctx.parameterTypeNameList().parameterTypeName().size() > 0;
            if (ctx.parameterTypeNameList().restParameterTypeName() != null) {
                restParamAvail = true;
            }
        }
        if (ctx.returnParameter() != null) {
            retParamAvail = true;
        }
        this.pkgBuilder.addFunctionType(this.getCurrentPos(ctx), this.getWS(ctx), paramsAvail, restParamAvail, retParamAvail);
    }

    @Override
    public void enterAnnotationAttachment(BallerinaParser.AnnotationAttachmentContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startAnnotationAttachment(this.getCurrentPos(ctx));
    }

    @Override
    public void exitAnnotationAttachment(BallerinaParser.AnnotationAttachmentContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.setAnnotationAttachmentName(this.getWS(ctx), ctx.recordLiteral() != null, this.getCurrentPos(ctx), false);
    }

    @Override
    public void exitErrorRestBindingPattern(BallerinaParser.ErrorRestBindingPatternContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addWSForErrorRestBinding(this.getWS(ctx));
    }

    @Override
    public void exitErrorBindingPattern(BallerinaParser.ErrorBindingPatternContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        if (ctx.typeName() != null) {
            if (ctx.errorFieldBindingPatterns().errorRestBindingPattern() != null) {
                String restIdName = ctx.errorFieldBindingPatterns().errorRestBindingPattern().Identifier().getText();
                DiagnosticPos restPos = this.getCurrentPos(ctx.errorFieldBindingPatterns().errorRestBindingPattern());
                this.pkgBuilder.addErrorVariable(this.getCurrentPos(ctx), this.getWS(ctx), restIdName, restPos);
            } else {
                this.pkgBuilder.addErrorVariable(this.getCurrentPos(ctx), this.getWS(ctx), null, null);
            }
            return;
        }
        String reasonIdentifier = ctx.Identifier().getText();
        DiagnosticPos currentPos = this.getCurrentPos(ctx);
        String restIdentifier = null;
        DiagnosticPos restParamPos = null;
        if (ctx.errorRestBindingPattern() != null) {
            restIdentifier = ctx.errorRestBindingPattern().Identifier().getText();
            restParamPos = this.getCurrentPos(ctx.errorRestBindingPattern());
        }
        this.pkgBuilder.addErrorVariable(currentPos, this.getWS(ctx), reasonIdentifier, restIdentifier, false, false, restParamPos);
    }

    @Override
    public void enterErrorBindingPattern(BallerinaParser.ErrorBindingPatternContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startErrorBindingNode();
    }

    @Override
    public void exitXmlElementAccessFilter(BallerinaParser.XmlElementAccessFilterContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        List<TerminalNode> identifier = ctx.Identifier();
        String ns = "";
        String elementName = "*";
        DiagnosticPos nsPos = null;
        DiagnosticPos elemNamePos = null;
        if (identifier.size() == 1) {
            if (ctx.MUL() == null) {
                TerminalNode nameNode = identifier.get(0);
                elementName = nameNode.getText();
                elemNamePos = this.getCurrentPos(nameNode);
            } else {
                elemNamePos = this.getCurrentPos(ctx.MUL());
                ns = ctx.Identifier(0).getText();
                nsPos = this.getCurrentPos(ctx.Identifier(0));
            }
        } else if (identifier.size() > 1) {
            TerminalNode nsNode = identifier.get(0);
            ns = nsNode.getText();
            nsPos = this.getCurrentPos(nsNode);
            TerminalNode nameNode = identifier.get(1);
            elementName = nameNode.getText();
            elemNamePos = this.getCurrentPos(nameNode);
        } else {
            elemNamePos = this.getCurrentPos(ctx.MUL());
        }
        this.pkgBuilder.addXMLElementAccessFilter(this.getCurrentPos(ctx), this.getWS(ctx), ns, nsPos, elementName, elemNamePos);
    }

    @Override
    public void enterErrorMatchPattern(BallerinaParser.ErrorMatchPatternContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startErrorBindingNode();
    }

    @Override
    public void exitSimpleMatchPattern(BallerinaParser.SimpleMatchPatternContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.endSimpleMatchPattern(this.getWS(ctx));
    }

    @Override
    public void exitXmlElementFilter(BallerinaParser.XmlElementFilterContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        int filterCount = ctx.xmlElementNames().xmlElementAccessFilter().size();
        this.pkgBuilder.createXMLElementAccessNode(this.getCurrentPos(ctx), this.getWS(ctx), filterCount);
    }

    @Override
    public void exitXmlStepExpressionReference(BallerinaParser.XmlStepExpressionReferenceContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        boolean isIndexed = ctx.xmlStepExpression().index() != null;
        BallerinaParser.XmlStepExpressionContext navAccess = ctx.xmlStepExpression();
        BallerinaParser.XmlElementNamesContext filters = navAccess.xmlElementNames();
        int filterCount = filters == null ? 0 : filters.xmlElementAccessFilter().size();
        int starCount = navAccess.MUL().size();
        this.pkgBuilder.createXMLNavigationAccessNode(this.getCurrentPos(ctx), this.getWS(ctx), filterCount, starCount, isIndexed);
    }

    @Override
    public void exitRestMatchPattern(BallerinaParser.RestMatchPatternContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addWSForRestMatchPattern(this.getWS(ctx));
    }

    @Override
    public void exitErrorArgListMatchPattern(BallerinaParser.ErrorArgListMatchPatternContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        String restIdentifier = null;
        DiagnosticPos restParamPos = null;
        if (ctx.restMatchPattern() != null) {
            restIdentifier = ctx.restMatchPattern().Identifier().getText();
            restParamPos = this.getCurrentPos(ctx.restMatchPattern());
        }
        String reasonIdentifier = null;
        boolean reasonVar = false;
        boolean constReasonMatchPattern = false;
        if (ctx.simpleMatchPattern() != null) {
            boolean bl = reasonVar = ctx.simpleMatchPattern().VAR() != null;
            if (ctx.simpleMatchPattern().Identifier() != null) {
                reasonIdentifier = ctx.simpleMatchPattern().Identifier().getText();
            } else {
                reasonIdentifier = ctx.simpleMatchPattern().QuotedStringLiteral().getText();
                constReasonMatchPattern = true;
            }
        }
        this.pkgBuilder.addErrorVariable(this.getCurrentPos(ctx), this.getWS(ctx), reasonIdentifier, restIdentifier, reasonVar, constReasonMatchPattern, restParamPos);
    }

    @Override
    public void exitErrorMatchPattern(BallerinaParser.ErrorMatchPatternContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        boolean isIndirectErrorMatchPatern = ctx.typeName() != null;
        this.pkgBuilder.endErrorMatchPattern(this.getWS(ctx), isIndirectErrorMatchPatern);
    }

    @Override
    public void exitErrorDetailBindingPattern(BallerinaParser.ErrorDetailBindingPatternContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        String bindingVarName = null;
        if (ctx.bindingPattern() != null && ctx.bindingPattern().Identifier() != null) {
            bindingVarName = ctx.bindingPattern().Identifier().getText();
        }
        this.pkgBuilder.addErrorDetailBinding(this.getCurrentPos(ctx), this.getWS(ctx), ctx.Identifier().getText(), bindingVarName);
    }

    @Override
    public void exitErrorRefBindingPattern(BallerinaParser.ErrorRefBindingPatternContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        int numNamedArgs = ctx.errorNamedArgRefPattern().size();
        boolean reasonRefAvailable = ctx.variableReference() != null;
        boolean restPatternAvailable = ctx.errorRefRestPattern() != null;
        boolean indirectErrorRefPattern = ctx.typeName() != null;
        this.pkgBuilder.addErrorVariableReference(this.getCurrentPos(ctx), this.getWS(ctx), numNamedArgs, reasonRefAvailable, restPatternAvailable, indirectErrorRefPattern);
    }

    @Override
    public void exitErrorNamedArgRefPattern(BallerinaParser.ErrorNamedArgRefPatternContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addNamedArgument(this.getCurrentPos(ctx), this.getWS(ctx), ctx.Identifier().getText());
    }

    @Override
    public void exitListBindingPattern(BallerinaParser.ListBindingPatternContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        boolean restBindingAvailable = ctx.restBindingPattern() != null;
        this.pkgBuilder.addTupleVariable(this.getCurrentPos(ctx), this.getWS(ctx), ctx.bindingPattern().size(), restBindingAvailable);
    }

    @Override
    public void exitListRefBindingPattern(BallerinaParser.ListRefBindingPatternContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        boolean restPatternAvailable = ctx.listRefRestPattern() != null;
        this.pkgBuilder.addTupleVariableReference(this.getCurrentPos(ctx), this.getWS(ctx), ctx.bindingRefPattern().size(), restPatternAvailable);
    }

    @Override
    public void enterRecordBindingPattern(BallerinaParser.RecordBindingPatternContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startRecordVariableList();
    }

    @Override
    public void exitRecordBindingPattern(BallerinaParser.RecordBindingPatternContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        boolean hasRestBindingPattern = ctx.entryBindingPattern().restBindingPattern() != null;
        this.pkgBuilder.addRecordVariable(this.getCurrentPos(ctx), this.getWS(ctx), hasRestBindingPattern);
    }

    @Override
    public void enterRecordRefBindingPattern(BallerinaParser.RecordRefBindingPatternContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startRecordVariableReferenceList();
    }

    @Override
    public void exitRecordRefBindingPattern(BallerinaParser.RecordRefBindingPatternContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        boolean hasRestBindingPattern = ctx.entryRefBindingPattern().restRefBindingPattern() != null;
        this.pkgBuilder.addRecordVariableReference(this.getCurrentPos(ctx), this.getWS(ctx), hasRestBindingPattern);
    }

    @Override
    public void exitBindingPattern(BallerinaParser.BindingPatternContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        if (ctx.Identifier() != null && (ctx.parent instanceof BallerinaParser.ListBindingPatternContext || ctx.parent instanceof BallerinaParser.FieldBindingPatternContext || ctx.parent instanceof BallerinaParser.MatchPatternClauseContext)) {
            this.pkgBuilder.addBindingPatternMemberVariable(this.getCurrentPos(ctx), this.getWS(ctx), ctx.Identifier().getText(), this.getCurrentPos(ctx.Identifier()));
        } else if (ctx.Identifier() != null) {
            this.pkgBuilder.addBindingPatternNameWhitespace(this.getWS(ctx));
        }
    }

    @Override
    public void exitFieldBindingPattern(BallerinaParser.FieldBindingPatternContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addFieldBindingMemberVar(this.getCurrentPos(ctx), this.getWS(ctx), ctx.Identifier().getText(), this.getCurrentPos(ctx.Identifier()), ctx.bindingPattern() != null);
    }

    @Override
    public void exitFieldRefBindingPattern(BallerinaParser.FieldRefBindingPatternContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addFieldRefBindingMemberVar(this.getCurrentPos(ctx), this.getWS(ctx), ctx.Identifier().getText(), ctx.bindingRefPattern() != null);
    }

    @Override
    public void exitRestBindingPattern(BallerinaParser.RestBindingPatternContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        if (ctx.Identifier() != null) {
            this.pkgBuilder.addBindingPatternMemberVariable(this.getCurrentPos(ctx), this.getWS(ctx), ctx.Identifier().getText(), this.getCurrentPos(ctx.Identifier()));
        }
    }

    @Override
    public void exitVariableDefinitionStatement(BallerinaParser.VariableDefinitionStatementContext ctx) {
        boolean isExpressionAvailable;
        if (this.isInErrorState) {
            return;
        }
        boolean isFinal = ctx.FINAL() != null;
        boolean isDeclaredWithVar = ctx.VAR() != null;
        boolean bl = isExpressionAvailable = ctx.expression() != null;
        if (ctx.Identifier() != null) {
            this.pkgBuilder.addSimpleVariableDefStatement(this.getCurrentPos(ctx), this.getWS(ctx), ctx.Identifier().getText(), this.getCurrentPos(ctx.Identifier()), isFinal, isExpressionAvailable, isDeclaredWithVar);
        } else if (ctx.bindingPattern().Identifier() != null) {
            this.pkgBuilder.addSimpleVariableDefStatement(this.getCurrentPos(ctx), this.getWS(ctx), ctx.bindingPattern().Identifier().getText(), this.getCurrentPos(ctx.bindingPattern().Identifier()), isFinal, isExpressionAvailable, isDeclaredWithVar);
        } else if (ctx.bindingPattern().structuredBindingPattern().recordBindingPattern() != null) {
            this.pkgBuilder.addRecordVariableDefStatement(this.getCurrentPos(ctx), this.getWS(ctx), isFinal, isDeclaredWithVar);
        } else if (ctx.bindingPattern().structuredBindingPattern().errorBindingPattern() != null) {
            this.pkgBuilder.addErrorVariableDefStatement(this.getCurrentPos(ctx), this.getWS(ctx), isFinal, isDeclaredWithVar);
        } else if (ctx.bindingPattern().structuredBindingPattern().listBindingPattern() != null) {
            this.pkgBuilder.addTupleVariableDefStatement(this.getCurrentPos(ctx), this.getWS(ctx), isFinal, isDeclaredWithVar);
        }
    }

    @Override
    public void enterRecordLiteral(BallerinaParser.RecordLiteralContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startMapStructLiteral();
    }

    @Override
    public void exitRecordLiteral(BallerinaParser.RecordLiteralContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addMapStructLiteral(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void exitRecordField(BallerinaParser.RecordFieldContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        if (ctx.Identifier() != null) {
            DiagnosticPos pos = this.getCurrentPos(ctx);
            this.pkgBuilder.addNameReference(pos, this.getWS(ctx), null, ctx.Identifier().getText());
            this.pkgBuilder.createBLangRecordVarRefNameField(pos, this.getWS(ctx));
            this.pkgBuilder.addIdentifierRecordField();
        } else if (ctx.ELLIPSIS() != null) {
            this.pkgBuilder.addSpreadOpRecordField(this.getWS(ctx));
        } else {
            this.pkgBuilder.addKeyValueRecordField(this.getWS(ctx), ctx.recordKey().LEFT_BRACKET() != null);
        }
    }

    @Override
    public void exitRecordKey(BallerinaParser.RecordKeyContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        if (ctx.Identifier() != null) {
            DiagnosticPos pos = this.getCurrentPos(ctx);
            this.pkgBuilder.addNameReference(pos, this.getWS(ctx), null, ctx.Identifier().getText());
            this.pkgBuilder.createSimpleVariableReference(pos, this.getWS(ctx));
        } else if (ctx.LEFT_BRACKET() != null) {
            this.pkgBuilder.addRecordKeyWS(this.getWS(ctx));
        }
    }

    @Override
    public void enterTableLiteral(BallerinaParser.TableLiteralContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startTableLiteral();
    }

    @Override
    public void exitTableColumnDefinition(BallerinaParser.TableColumnDefinitionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.endTableColumnDefinition(this.getWS(ctx));
    }

    @Override
    public void exitTableColumn(BallerinaParser.TableColumnContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        int childCount = ctx.getChildCount();
        if (childCount == 2) {
            boolean keyColumn = KEYWORD_KEY.equals(ctx.getChild(0).getText());
            if (keyColumn) {
                String columnName = BLangPackageBuilder.escapeQuotedIdentifier(ctx.getChild(1).getText());
                this.pkgBuilder.addTableColumn(columnName, this.getCurrentPos(ctx), this.getWS(ctx));
                this.pkgBuilder.markPrimaryKeyColumn(columnName);
            } else {
                DiagnosticPos pos = this.getCurrentPos(ctx);
                this.dlog.error(pos, DiagnosticCode.TABLE_KEY_EXPECTED, new Object[0]);
            }
        } else {
            String columnName = BLangPackageBuilder.escapeQuotedIdentifier(ctx.getChild(0).getText());
            this.pkgBuilder.addTableColumn(columnName, this.getCurrentPos(ctx), this.getWS(ctx));
        }
    }

    @Override
    public void exitTableDataArray(BallerinaParser.TableDataArrayContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.endTableDataArray(this.getWS(ctx));
    }

    @Override
    public void exitTableDataList(BallerinaParser.TableDataListContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        if (ctx.expressionList() != null) {
            this.pkgBuilder.endTableDataRow(this.getWS(ctx));
        }
    }

    @Override
    public void exitTableData(BallerinaParser.TableDataContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.endTableDataList(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void exitTableLiteral(BallerinaParser.TableLiteralContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addTableLiteral(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void exitListConstructorExpr(BallerinaParser.ListConstructorExprContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        boolean argsAvailable = ctx.expressionList() != null;
        this.pkgBuilder.addListConstructorExpression(this.getCurrentPos(ctx), this.getWS(ctx), argsAvailable);
    }

    @Override
    public void enterLetExpr(BallerinaParser.LetExprContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startLetVarList();
    }

    @Override
    public void exitLetExpr(BallerinaParser.LetExprContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addLetExpression(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void exitLetVarDecl(BallerinaParser.LetVarDeclContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        boolean isDeclaredWithVar = ctx.VAR() != null;
        boolean isExpressionAvailable = ctx.expression() != null;
        int annotationAttachmentsSize = ctx.annotationAttachment().size();
        if (ctx.bindingPattern().Identifier() != null) {
            this.pkgBuilder.addSimpleLetVariableDefStatement(this.getCurrentPos(ctx), this.getWS(ctx), ctx.bindingPattern().Identifier().getText(), this.getCurrentPos(ctx.bindingPattern().Identifier()), isExpressionAvailable, isDeclaredWithVar, annotationAttachmentsSize);
        } else if (ctx.bindingPattern().structuredBindingPattern().recordBindingPattern() != null) {
            this.pkgBuilder.addRecordVariableLetDefStatement(this.getCurrentPos(ctx), this.getWS(ctx), isDeclaredWithVar, annotationAttachmentsSize);
        } else if (ctx.bindingPattern().structuredBindingPattern().errorBindingPattern() != null) {
            this.pkgBuilder.addErrorVariableLetDefStatement(this.getCurrentPos(ctx), this.getWS(ctx), isDeclaredWithVar, annotationAttachmentsSize);
        } else if (ctx.bindingPattern().structuredBindingPattern().listBindingPattern() != null) {
            this.pkgBuilder.addTupleVariableLetDefStatement(this.getCurrentPos(ctx), this.getWS(ctx), isDeclaredWithVar, annotationAttachmentsSize);
        }
    }

    @Override
    public void exitTypeInitExpr(BallerinaParser.TypeInitExprContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        String initName = ctx.NEW().getText();
        boolean typeAvailable = ctx.userDefineTypeName() != null || ctx.streamTypeName() != null;
        boolean argsAvailable = ctx.invocationArgList() != null;
        this.pkgBuilder.addTypeInitExpression(this.getCurrentPos(ctx), this.getWS(ctx), initName, typeAvailable, argsAvailable);
    }

    @Override
    public void exitServiceConstructorExpression(BallerinaParser.ServiceConstructorExpressionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        DiagnosticPos serviceDefPos = this.getCurrentPos(ctx);
        String serviceVarName = null;
        DiagnosticPos varPos = serviceDefPos;
        this.pkgBuilder.endServiceDef(serviceDefPos, this.getWS(ctx), serviceVarName, varPos, true, ctx.serviceConstructorExpr().annotationAttachment().size());
    }

    @Override
    public void exitAssignmentStatement(BallerinaParser.AssignmentStatementContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addAssignmentStatement(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void exitListDestructuringStatement(BallerinaParser.ListDestructuringStatementContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addTupleDestructuringStatement(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void exitRecordDestructuringStatement(BallerinaParser.RecordDestructuringStatementContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addRecordDestructuringStatement(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void exitErrorDestructuringStatement(BallerinaParser.ErrorDestructuringStatementContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addErrorDestructuringStatement(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void exitCompoundAssignmentStatement(BallerinaParser.CompoundAssignmentStatementContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        String compoundOperatorText = ctx.compoundOperator().getText();
        String operator = compoundOperatorText.substring(0, compoundOperatorText.length() - 1);
        this.pkgBuilder.addCompoundAssignmentStatement(this.getCurrentPos(ctx), this.getWS(ctx), operator);
    }

    @Override
    public void exitCompoundOperator(BallerinaParser.CompoundOperatorContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addCompoundOperator(this.getWS(ctx));
    }

    @Override
    public void enterVariableReferenceList(BallerinaParser.VariableReferenceListContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startExprNodeList();
    }

    @Override
    public void exitVariableReferenceList(BallerinaParser.VariableReferenceListContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.endExprNodeList(this.getWS(ctx), ctx.getChildCount() / 2 + 1);
    }

    @Override
    public void enterIfElseStatement(BallerinaParser.IfElseStatementContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startIfElseNode(this.getCurrentPos(ctx));
    }

    @Override
    public void exitIfElseStatement(BallerinaParser.IfElseStatementContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.endIfElseNode(this.getWS(ctx));
    }

    @Override
    public void exitIfClause(BallerinaParser.IfClauseContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addIfBlock(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void enterElseIfClause(BallerinaParser.ElseIfClauseContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startIfElseNode(this.getCurrentPos(ctx));
    }

    @Override
    public void exitElseIfClause(BallerinaParser.ElseIfClauseContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addElseIfBlock(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void enterElseClause(BallerinaParser.ElseClauseContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startBlock();
    }

    @Override
    public void exitElseClause(BallerinaParser.ElseClauseContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addElseBlock(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void enterMatchStatement(BallerinaParser.MatchStatementContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.createMatchNode(this.getCurrentPos(ctx));
    }

    @Override
    public void exitMatchStatement(BallerinaParser.MatchStatementContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.completeMatchNode(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void enterMatchPatternClause(BallerinaParser.MatchPatternClauseContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startMatchStmtPattern();
    }

    @Override
    public void exitMatchPatternClause(BallerinaParser.MatchPatternClauseContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        if (ctx.bindingPattern() != null || ctx.errorMatchPattern() != null) {
            boolean isTypeGuardPresent = ctx.IF() != null;
            this.pkgBuilder.addMatchStmtStructuredBindingPattern(this.getCurrentPos(ctx), this.getWS(ctx), isTypeGuardPresent);
            return;
        }
        this.pkgBuilder.addMatchStmtStaticBindingPattern(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void enterForeachStatement(BallerinaParser.ForeachStatementContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startForeachStatement();
    }

    @Override
    public void exitForeachStatement(BallerinaParser.ForeachStatementContext ctx) {
        boolean isDeclaredWithVar;
        if (this.isInErrorState) {
            return;
        }
        boolean bl = isDeclaredWithVar = ctx.VAR() != null;
        if (ctx.bindingPattern().Identifier() != null) {
            String identifier = ctx.bindingPattern().Identifier().getText();
            DiagnosticPos identifierPos = this.getCurrentPos(ctx.bindingPattern().Identifier());
            this.pkgBuilder.addForeachStatementWithSimpleVariableDefStatement(this.getCurrentPos(ctx), this.getWS(ctx), identifier, identifierPos, isDeclaredWithVar);
        } else if (ctx.bindingPattern().structuredBindingPattern().recordBindingPattern() != null) {
            this.pkgBuilder.addForeachStatementWithRecordVariableDefStatement(this.getCurrentPos(ctx), this.getWS(ctx), isDeclaredWithVar);
        } else if (ctx.bindingPattern().structuredBindingPattern().errorBindingPattern() != null) {
            this.pkgBuilder.addForeachStatementWithErrorVariableDefStatement(this.getCurrentPos(ctx), this.getWS(ctx), isDeclaredWithVar);
        } else {
            this.pkgBuilder.addForeachStatementWithTupleVariableDefStatement(this.getCurrentPos(ctx), this.getWS(ctx), isDeclaredWithVar);
        }
    }

    @Override
    public void exitIntRangeExpression(BallerinaParser.IntRangeExpressionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addIntRangeExpression(this.getCurrentPos(ctx), this.getWS(ctx), ctx.LEFT_PARENTHESIS() == null, ctx.RIGHT_PARENTHESIS() == null, ctx.expression(1) == null);
    }

    @Override
    public void enterWhileStatement(BallerinaParser.WhileStatementContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startWhileStmt();
    }

    @Override
    public void exitWhileStatement(BallerinaParser.WhileStatementContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addWhileStmt(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void exitContinueStatement(BallerinaParser.ContinueStatementContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addContinueStatement(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void exitBreakStatement(BallerinaParser.BreakStatementContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addBreakStatement(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void enterForkJoinStatement(BallerinaParser.ForkJoinStatementContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startForkJoinStmt();
    }

    @Override
    public void exitForkJoinStatement(BallerinaParser.ForkJoinStatementContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addForkJoinStmt(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void enterTryCatchStatement(BallerinaParser.TryCatchStatementContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startTryCatchFinallyStmt();
    }

    @Override
    public void exitTryCatchStatement(BallerinaParser.TryCatchStatementContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addTryCatchFinallyStmt(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void enterCatchClauses(BallerinaParser.CatchClausesContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addTryClause(this.getCurrentPos(ctx));
    }

    @Override
    public void enterCatchClause(BallerinaParser.CatchClauseContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startCatchClause();
    }

    @Override
    public void exitCatchClause(BallerinaParser.CatchClauseContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        String paramName = ctx.Identifier().getText();
        this.pkgBuilder.addCatchClause(this.getCurrentPos(ctx), this.getWS(ctx), paramName);
    }

    @Override
    public void enterFinallyClause(BallerinaParser.FinallyClauseContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startFinallyBlock();
    }

    @Override
    public void exitFinallyClause(BallerinaParser.FinallyClauseContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addFinallyBlock(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void exitThrowStatement(BallerinaParser.ThrowStatementContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addThrowStmt(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void exitPanicStatement(BallerinaParser.PanicStatementContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addPanicStmt(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void exitReturnStatement(BallerinaParser.ReturnStatementContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addReturnStatement(this.getCurrentPos(ctx), this.getWS(ctx), ctx.expression() != null);
    }

    @Override
    public void exitWorkerReceiveExpression(BallerinaParser.WorkerReceiveExpressionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        String workerName = ctx.peerWorker().DEFAULT() != null ? ctx.peerWorker().DEFAULT().getText() : ctx.peerWorker().workerName().getText();
        this.pkgBuilder.addWorkerReceiveExpr(this.getCurrentPos(ctx), this.getWS(ctx), workerName, ctx.expression() != null);
    }

    @Override
    public void exitFlushWorker(BallerinaParser.FlushWorkerContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        String workerName = ctx.Identifier() != null ? ctx.Identifier().getText() : null;
        this.pkgBuilder.addWorkerFlushExpr(this.getCurrentPos(ctx), this.getWS(ctx), workerName);
    }

    @Override
    public void exitWorkerSendAsyncStatement(BallerinaParser.WorkerSendAsyncStatementContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        String workerName = ctx.peerWorker().DEFAULT() != null ? ctx.peerWorker().DEFAULT().getText() : ctx.peerWorker().workerName().getText();
        this.pkgBuilder.addWorkerSendStmt(this.getCurrentPos(ctx), this.getWS(ctx), workerName, ctx.expression().size() > 1);
    }

    @Override
    public void exitWorkerSendSyncExpression(BallerinaParser.WorkerSendSyncExpressionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        String workerName = ctx.peerWorker().DEFAULT() != null ? ctx.peerWorker().DEFAULT().getText() : ctx.peerWorker().workerName().getText();
        this.pkgBuilder.addWorkerSendSyncExpr(this.getCurrentPos(ctx), this.getWS(ctx), workerName);
    }

    @Override
    public void exitWaitExpression(BallerinaParser.WaitExpressionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        if (ctx.waitForCollection() != null) {
            this.pkgBuilder.handleWaitForAll(this.getCurrentPos(ctx), this.getWS(ctx));
        } else {
            this.pkgBuilder.handleWait(this.getCurrentPos(ctx), this.getWS(ctx));
        }
    }

    @Override
    public void enterWaitForCollection(BallerinaParser.WaitForCollectionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startWaitForAll();
    }

    @Override
    public void exitWaitKeyValue(BallerinaParser.WaitKeyValueContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        boolean containsExpr = ctx.expression() != null;
        this.pkgBuilder.addKeyValueToWaitForAll(this.getCurrentPos(ctx), this.getWS(ctx), ctx.Identifier().getText(), containsExpr);
    }

    @Override
    public void exitXmlAttribVariableReference(BallerinaParser.XmlAttribVariableReferenceContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        boolean isSingleAttrRef = ctx.xmlAttrib().expression() != null;
        this.pkgBuilder.createXmlAttributesRefExpr(this.getCurrentPos(ctx), this.getWS(ctx), isSingleAttrRef);
    }

    @Override
    public void exitSimpleVariableReference(BallerinaParser.SimpleVariableReferenceContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.createSimpleVariableReference(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void exitInvocation(BallerinaParser.InvocationContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addInvocationWS(this.getWS(ctx));
    }

    @Override
    public void exitStringFunctionInvocationReference(BallerinaParser.StringFunctionInvocationReferenceContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        TerminalNode node = ctx.QuotedStringLiteral();
        DiagnosticPos pos = this.getCurrentPos(ctx);
        Set<Whitespace> ws = this.getWS(ctx);
        String actualText = node.getText();
        actualText = actualText.substring(1, actualText.length() - 1);
        actualText = StringEscapeUtils.unescapeJava((String)actualText);
        this.pkgBuilder.addLiteralValue(pos, ws, 5, actualText, node.getText());
        boolean argsAvailable = ctx.invocation().invocationArgList() != null;
        BallerinaParser.AnyIdentifierNameContext identifierContext = ctx.invocation().anyIdentifierName();
        String invocation = identifierContext.getText();
        this.pkgBuilder.createInvocationNode(this.getCurrentPos(ctx), this.getWS(ctx), invocation, argsAvailable, this.getCurrentPos(identifierContext));
    }

    @Override
    public void exitGroupStringFunctionInvocationReference(BallerinaParser.GroupStringFunctionInvocationReferenceContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        TerminalNode node = ctx.QuotedStringLiteral();
        DiagnosticPos pos = this.getCurrentPos(ctx);
        Set<Whitespace> ws = this.getWS(ctx);
        String actualText = node.getText();
        actualText = actualText.substring(1, actualText.length() - 1);
        actualText = StringEscapeUtils.unescapeJava((String)actualText);
        this.pkgBuilder.addLiteralValue(pos, ws, 5, actualText, node.getText());
        BallerinaParser.InvocationContext invocation = ctx.invocation();
        boolean argsAvailable = invocation.invocationArgList() != null;
        BallerinaParser.AnyIdentifierNameContext identifierContext = invocation.anyIdentifierName();
        String invocationText = identifierContext.getText();
        this.pkgBuilder.createInvocationNode(this.getCurrentPos(invocation), this.getWS(invocation), invocationText, argsAvailable, this.getCurrentPos(identifierContext));
        this.pkgBuilder.createGroupExpression(this.getCurrentPos(node), this.getWS(ctx));
    }

    @Override
    public void exitFunctionInvocation(BallerinaParser.FunctionInvocationContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        boolean argsAvailable = ctx.invocationArgList() != null;
        this.pkgBuilder.createFunctionInvocation(this.getCurrentPos(ctx), this.getWS(ctx), argsAvailable);
    }

    @Override
    public void exitFieldVariableReference(BallerinaParser.FieldVariableReferenceContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.createFieldBasedAccessNode(ctx, ctx.field());
    }

    @Override
    public void exitGroupFieldVariableReference(BallerinaParser.GroupFieldVariableReferenceContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        BallerinaParser.FieldContext field = ctx.field();
        BallerinaParser.VariableReferenceContext groupExpression = ctx.variableReference();
        this.createFieldBasedAccessNode(field, field);
        this.pkgBuilder.createGroupExpression(this.getCurrentPos(groupExpression), this.getWS(groupExpression));
    }

    private void createFieldBasedAccessNode(ParserRuleContext ctx, BallerinaParser.FieldContext field) {
        FieldKind fieldType;
        String fieldName;
        String nsName = null;
        DiagnosticPos nsPos = null;
        if (field.Identifier().isEmpty()) {
            fieldName = field.MUL().getText();
            fieldType = FieldKind.ALL;
        } else if (field.Identifier().size() == 1) {
            fieldName = field.Identifier(0).getText();
            fieldType = FieldKind.SINGLE;
        } else {
            nsName = field.Identifier(0).getText();
            nsPos = this.getCurrentPos(field.Identifier(0));
            fieldName = field.Identifier(1).getText();
            fieldType = FieldKind.WITH_NS;
        }
        this.pkgBuilder.createFieldBasedAccessNode(this.getCurrentPos(ctx), this.getWS(ctx), fieldName, this.getCurrentPos(field), nsName, nsPos, fieldType, field.OPTIONAL_FIELD_ACCESS() != null);
    }

    @Override
    public void exitMapArrayVariableReference(BallerinaParser.MapArrayVariableReferenceContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.createIndexBasedAccessNode(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void exitGroupMapArrayVariableReference(BallerinaParser.GroupMapArrayVariableReferenceContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        BallerinaParser.IndexContext index = ctx.index();
        BallerinaParser.VariableReferenceContext groupExpression = ctx.variableReference();
        this.pkgBuilder.createIndexBasedAccessNode(this.getCurrentPos(index), this.getWS(index));
        this.pkgBuilder.createGroupExpression(this.getCurrentPos(groupExpression), this.getWS(groupExpression));
    }

    @Override
    public void exitReservedWord(BallerinaParser.ReservedWordContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startInvocationNode(this.getWS(ctx));
    }

    @Override
    public void exitAnyIdentifierName(BallerinaParser.AnyIdentifierNameContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        if (ctx.reservedWord() == null) {
            this.pkgBuilder.startInvocationNode(this.getWS(ctx));
        }
    }

    @Override
    public void exitInvocationReference(BallerinaParser.InvocationReferenceContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        boolean argsAvailable = ctx.invocation().invocationArgList() != null;
        BallerinaParser.AnyIdentifierNameContext identifierContext = ctx.invocation().anyIdentifierName();
        String invocation = identifierContext.getText();
        this.pkgBuilder.createInvocationNode(this.getCurrentPos(ctx), this.getWS(ctx), invocation, argsAvailable, this.getCurrentPos(identifierContext));
    }

    @Override
    public void exitGroupInvocationReference(BallerinaParser.GroupInvocationReferenceContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        BallerinaParser.InvocationContext invocation = ctx.invocation();
        BallerinaParser.VariableReferenceContext groupExpression = ctx.variableReference();
        boolean argsAvailable = invocation.invocationArgList() != null;
        BallerinaParser.AnyIdentifierNameContext identifierContext = invocation.anyIdentifierName();
        String invocationText = identifierContext.getText();
        this.pkgBuilder.createGroupExpression(this.getCurrentPos(groupExpression), this.getWS(groupExpression));
        this.pkgBuilder.createInvocationNode(this.getCurrentPos(invocation), this.getWS(invocation), invocationText, argsAvailable, this.getCurrentPos(identifierContext));
    }

    @Override
    public void exitTypeDescExprInvocationReference(BallerinaParser.TypeDescExprInvocationReferenceContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        boolean argsAvailable = ctx.invocation().invocationArgList() != null;
        BallerinaParser.AnyIdentifierNameContext identifierContext = ctx.invocation().anyIdentifierName();
        String invocation = identifierContext.getText();
        this.pkgBuilder.createInvocationNode(this.getCurrentPos(ctx), this.getWS(ctx), invocation, argsAvailable, this.getCurrentPos(identifierContext));
    }

    @Override
    public void enterInvocationArgList(BallerinaParser.InvocationArgListContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startExprNodeList();
    }

    @Override
    public void exitInvocationArgList(BallerinaParser.InvocationArgListContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.endExprNodeList(this.getWS(ctx), ctx.getChildCount() / 2 + 1);
    }

    @Override
    public void enterExpressionList(BallerinaParser.ExpressionListContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startExprNodeList();
    }

    @Override
    public void exitExpressionList(BallerinaParser.ExpressionListContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.endExprNodeList(this.getWS(ctx), ctx.getChildCount() / 2 + 1);
    }

    @Override
    public void exitExpressionStmt(BallerinaParser.ExpressionStmtContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addExpressionStmt(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void enterTransactionStatement(BallerinaParser.TransactionStatementContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startTransactionStmt();
    }

    @Override
    public void exitTransactionStatement(BallerinaParser.TransactionStatementContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        DiagnosticPos pos = this.getCurrentPos(ctx);
        this.pkgBuilder.endTransactionStmt(pos, this.getWS(ctx));
    }

    @Override
    public void exitTransactionClause(BallerinaParser.TransactionClauseContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addTransactionBlock(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void exitTransactionPropertyInitStatementList(BallerinaParser.TransactionPropertyInitStatementListContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.endTransactionPropertyInitStatementList(this.getWS(ctx));
    }

    @Override
    public void enterLockStatement(BallerinaParser.LockStatementContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startLockStmt();
    }

    @Override
    public void exitLockStatement(BallerinaParser.LockStatementContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addLockStmt(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void enterOnretryClause(BallerinaParser.OnretryClauseContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startOnretryBlock();
    }

    @Override
    public void exitOnretryClause(BallerinaParser.OnretryClauseContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addOnretryBlock(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void enterCommittedClause(BallerinaParser.CommittedClauseContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startCommittedBlock();
    }

    @Override
    public void exitCommittedClause(BallerinaParser.CommittedClauseContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.endCommittedBlock(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void enterAbortedClause(BallerinaParser.AbortedClauseContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startAbortedBlock();
    }

    @Override
    public void exitAbortedClause(BallerinaParser.AbortedClauseContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.endAbortedBlock(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void exitAbortStatement(BallerinaParser.AbortStatementContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addAbortStatement(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void exitRetryStatement(BallerinaParser.RetryStatementContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addRetryStatement(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void exitRetriesStatement(BallerinaParser.RetriesStatementContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addRetryCountExpression(this.getWS(ctx));
    }

    @Override
    public void enterNamespaceDeclaration(BallerinaParser.NamespaceDeclarationContext ctx) {
    }

    @Override
    public void exitNamespaceDeclaration(BallerinaParser.NamespaceDeclarationContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        boolean isTopLevel = ctx.parent instanceof BallerinaParser.CompilationUnitContext;
        String namespaceUri = ctx.QuotedStringLiteral().getText();
        DiagnosticPos pos = this.getCurrentPos(ctx);
        namespaceUri = namespaceUri.substring(1, namespaceUri.length() - 1);
        namespaceUri = StringEscapeUtils.unescapeJava((String)namespaceUri);
        String prefix = ctx.Identifier() != null ? ctx.Identifier().getText() : null;
        DiagnosticPos prefixPos = ctx.Identifier() != null ? this.getCurrentPos(ctx.Identifier()) : null;
        this.pkgBuilder.addXMLNSDeclaration(pos, this.getWS(ctx), namespaceUri, prefix, prefixPos, isTopLevel);
    }

    @Override
    public void exitBinaryDivMulModExpression(BallerinaParser.BinaryDivMulModExpressionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.createBinaryExpr(this.getCurrentPos(ctx), this.getWS(ctx), ctx.getChild(1).getText());
    }

    @Override
    public void exitBinaryOrExpression(BallerinaParser.BinaryOrExpressionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.createBinaryExpr(this.getCurrentPos(ctx), this.getWS(ctx), ctx.getChild(1).getText());
    }

    @Override
    public void exitBinaryRefEqualExpression(BallerinaParser.BinaryRefEqualExpressionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.createBinaryExpr(this.getCurrentPos(ctx), this.getWS(ctx), ctx.getChild(1).getText());
    }

    @Override
    public void exitBinaryEqualExpression(BallerinaParser.BinaryEqualExpressionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.createBinaryExpr(this.getCurrentPos(ctx), this.getWS(ctx), ctx.getChild(1).getText());
    }

    @Override
    public void exitStaticMatchOrExpression(BallerinaParser.StaticMatchOrExpressionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.createBinaryExpr(this.getCurrentPos(ctx), this.getWS(ctx), ctx.getChild(1).getText());
    }

    @Override
    public void exitStaticMatchIdentifierLiteral(BallerinaParser.StaticMatchIdentifierLiteralContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addNameReference(this.getCurrentPos(ctx), this.getWS(ctx), null, ctx.Identifier().getText());
        this.pkgBuilder.createSimpleVariableReference(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void exitTypeDescExpr(BallerinaParser.TypeDescExprContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.createTypeAccessExpr(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void exitActionInvocation(BallerinaParser.ActionInvocationContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        int numAnnotations = ctx.annotationAttachment().size();
        this.pkgBuilder.createActionInvocationNode(this.getCurrentPos(ctx), this.getWS(ctx), ctx.START() != null, numAnnotations);
    }

    @Override
    public void exitBinaryAndExpression(BallerinaParser.BinaryAndExpressionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.createBinaryExpr(this.getCurrentPos(ctx), this.getWS(ctx), ctx.getChild(1).getText());
    }

    @Override
    public void exitBinaryAddSubExpression(BallerinaParser.BinaryAddSubExpressionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.createBinaryExpr(this.getCurrentPos(ctx), this.getWS(ctx), ctx.getChild(1).getText());
    }

    @Override
    public void exitBitwiseExpression(BallerinaParser.BitwiseExpressionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.createBinaryExpr(this.getCurrentPos(ctx), this.getWS(ctx), ctx.getChild(1).getText());
    }

    @Override
    public void exitBitwiseShiftExpression(BallerinaParser.BitwiseShiftExpressionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        StringBuilder operator = new StringBuilder();
        for (int i = 1; i < ctx.getChildCount() - 1; ++i) {
            operator.append(ctx.getChild(i).getText());
        }
        this.pkgBuilder.createBinaryExpr(this.getCurrentPos(ctx), this.getWS(ctx), operator.toString());
    }

    @Override
    public void exitTypeConversionExpression(BallerinaParser.TypeConversionExpressionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.createTypeConversionExpr(this.getCurrentPos(ctx), this.getWS(ctx), ctx.annotationAttachment().size(), ctx.typeName() != null);
    }

    @Override
    public void exitBinaryCompareExpression(BallerinaParser.BinaryCompareExpressionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.createBinaryExpr(this.getCurrentPos(ctx), this.getWS(ctx), ctx.getChild(1).getText());
    }

    @Override
    public void exitIntegerRangeExpression(BallerinaParser.IntegerRangeExpressionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.createBinaryExpr(this.getCurrentPos(ctx), this.getWS(ctx), ctx.getChild(1).getText());
    }

    @Override
    public void exitUnaryExpression(BallerinaParser.UnaryExpressionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.createUnaryExpr(this.getCurrentPos(ctx), this.getWS(ctx), ctx.getChild(0).getText());
    }

    @Override
    public void exitTypeTestExpression(BallerinaParser.TypeTestExpressionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.createTypeTestExpression(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void exitAnnotAccessExpression(BallerinaParser.AnnotAccessExpressionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.createAnnotAccessNode(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void exitGroupExpression(BallerinaParser.GroupExpressionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.createGroupExpression(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void exitTernaryExpression(BallerinaParser.TernaryExpressionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.createTernaryExpr(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void exitCheckedExpression(BallerinaParser.CheckedExpressionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.createCheckedExpr(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void exitCheckPanickedExpression(BallerinaParser.CheckPanickedExpressionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.createCheckPanickedExpr(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void enterFromClause(BallerinaParser.FromClauseContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startFromClause();
    }

    @Override
    public void exitFromClause(BallerinaParser.FromClauseContext ctx) {
        boolean isDeclaredWithVar;
        if (this.isInErrorState) {
            return;
        }
        boolean bl = isDeclaredWithVar = ctx.VAR() != null;
        if (ctx.bindingPattern().Identifier() != null) {
            String identifier = ctx.bindingPattern().Identifier().getText();
            DiagnosticPos identifierPos = this.getCurrentPos(ctx.bindingPattern().Identifier());
            this.pkgBuilder.createFromClauseWithSimpleVariableDefStatement(this.getCurrentPos(ctx), this.getWS(ctx), identifier, identifierPos, isDeclaredWithVar);
        } else if (ctx.bindingPattern().structuredBindingPattern().recordBindingPattern() != null) {
            this.pkgBuilder.createFromClauseWithRecordVariableDefStatement(this.getCurrentPos(ctx), this.getWS(ctx), isDeclaredWithVar);
        } else if (ctx.bindingPattern().structuredBindingPattern().errorBindingPattern() != null) {
            this.pkgBuilder.createFromClauseWithErrorVariableDefStatement(this.getCurrentPos(ctx), this.getWS(ctx), isDeclaredWithVar);
        } else {
            this.pkgBuilder.createFromClauseWithTupleVariableDefStatement(this.getCurrentPos(ctx), this.getWS(ctx), isDeclaredWithVar);
        }
    }

    @Override
    public void enterLetClause(BallerinaParser.LetClauseContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startLetVarList();
    }

    @Override
    public void exitLetClause(BallerinaParser.LetClauseContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addLetClause(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void exitWhereClause(BallerinaParser.WhereClauseContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.createWhereClause(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void exitSelectClause(BallerinaParser.SelectClauseContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.createSelectClause(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void exitDoClause(BallerinaParser.DoClauseContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.createDoClause(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void exitQueryExpr(BallerinaParser.QueryExprContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.createQueryExpr(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void enterQueryAction(BallerinaParser.QueryActionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startDoActionBlock();
    }

    @Override
    public void exitQueryAction(BallerinaParser.QueryActionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.createQueryActionExpr(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void exitNameReference(BallerinaParser.NameReferenceContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        if (ctx.Identifier().size() == 2) {
            String pkgName = ctx.Identifier(0).getText();
            String name = ctx.Identifier(1).getText();
            DiagnosticPos pos = this.getCurrentPos(ctx);
            if (Names.IGNORE.value.equals(pkgName)) {
                this.dlog.error(pos, DiagnosticCode.INVALID_PACKAGE_NAME_QUALIFER, pkgName);
            }
            this.pkgBuilder.addNameReference(pos, this.getWS(ctx), pkgName, name);
        } else {
            String name = ctx.Identifier(0).getText();
            this.pkgBuilder.addNameReference(this.getCurrentPos(ctx), this.getWS(ctx), null, name);
        }
    }

    @Override
    public void exitFunctionNameReference(BallerinaParser.FunctionNameReferenceContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        if (ctx.Identifier() != null) {
            String pkgName = ctx.Identifier().getText();
            String name = ctx.anyIdentifierName().getText();
            DiagnosticPos pos = this.getCurrentPos(ctx);
            if (Names.IGNORE.value.equals(pkgName)) {
                this.dlog.error(pos, DiagnosticCode.INVALID_PACKAGE_NAME_QUALIFER, pkgName);
            }
            this.pkgBuilder.addNameReference(pos, this.getWS(ctx), pkgName, name);
        } else {
            String name = ctx.anyIdentifierName().getText();
            this.pkgBuilder.addNameReference(this.getCurrentPos(ctx), this.getWS(ctx), null, name);
        }
    }

    @Override
    public void exitReturnParameter(BallerinaParser.ReturnParameterContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addReturnParam(this.getCurrentPos(ctx), this.getWS(ctx), ctx.annotationAttachment().size());
    }

    @Override
    public void enterParameterTypeNameList(BallerinaParser.ParameterTypeNameListContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startVarList();
    }

    @Override
    public void exitParameterTypeNameList(BallerinaParser.ParameterTypeNameListContext ctx) {
        boolean inFuncTypeSig;
        if (this.isInErrorState) {
            return;
        }
        ParserRuleContext parent = ctx.getParent();
        boolean bl = inFuncTypeSig = parent instanceof BallerinaParser.FunctionTypeNameContext || parent instanceof BallerinaParser.ReturnParameterContext && parent.parent instanceof BallerinaParser.FunctionTypeNameContext;
        if (inFuncTypeSig) {
            this.pkgBuilder.endFuncTypeParamList(this.getWS(ctx));
        } else {
            this.pkgBuilder.endCallableParamList(this.getWS(ctx));
        }
    }

    @Override
    public void exitParameterList(BallerinaParser.ParameterListContext ctx) {
        boolean inFuncTypeSig;
        if (this.isInErrorState) {
            return;
        }
        ParserRuleContext parent = ctx.getParent();
        boolean bl = inFuncTypeSig = parent instanceof BallerinaParser.FunctionTypeNameContext || parent instanceof BallerinaParser.ReturnParameterContext && parent.parent instanceof BallerinaParser.FunctionTypeNameContext;
        if (inFuncTypeSig) {
            this.pkgBuilder.endFuncTypeParamList(this.getWS(ctx));
        } else {
            this.pkgBuilder.endCallableParamList(this.getWS(ctx));
        }
    }

    private String fillWithZeros(String str) {
        while (str.length() < 4) {
            str = "0".concat(str);
        }
        return str;
    }

    @Override
    public void exitSimpleLiteral(BallerinaParser.SimpleLiteralContext ctx) {
        Object value;
        if (this.isInErrorState) {
            return;
        }
        DiagnosticPos pos = this.getCurrentPos(ctx);
        Set<Whitespace> ws = this.getWS(ctx);
        BallerinaParser.IntegerLiteralContext integerLiteralContext = ctx.integerLiteral();
        if (integerLiteralContext != null && (value = this.getIntegerLiteral(ctx, ctx.integerLiteral())) != null) {
            this.pkgBuilder.addLiteralValue(pos, ws, 1, value, ctx.getText());
        } else if (ctx.floatingPointLiteral() != null) {
            TerminalNode node = ctx.floatingPointLiteral().DecimalFloatingPointNumber();
            if (node != null) {
                String nodeValue = this.getNodeValue(ctx, node);
                int literalTypeTag = NumericLiteralSupport.isDecimalDiscriminated(nodeValue) ? 4 : 3;
                this.pkgBuilder.addLiteralValue(pos, ws, literalTypeTag, nodeValue, node.getText());
            } else {
                node = ctx.floatingPointLiteral().HexadecimalFloatingPointLiteral();
                if (node != null) {
                    this.pkgBuilder.addLiteralValue(pos, ws, 3, this.getHexNodeValue(ctx, node), node.getText());
                }
            }
        } else {
            TerminalNode node = ctx.BooleanLiteral();
            if (node != null) {
                this.pkgBuilder.addLiteralValue(pos, ws, 6, Boolean.parseBoolean(node.getText()), node.getText());
            } else {
                node = ctx.QuotedStringLiteral();
                if (node != null) {
                    String text = node.getText();
                    String originalText = text = text.substring(1, text.length() - 1);
                    Matcher matcher = this.pattern.matcher(text);
                    int position = 0;
                    while (matcher.find(position)) {
                        String hexStringVal = matcher.group(1);
                        int hexDecimalVal = Integer.parseInt(hexStringVal, 16);
                        if (hexDecimalVal >= 55296 && hexDecimalVal <= 57343 || hexDecimalVal > 0x10FFFF) {
                            String hexStringWithBraces = matcher.group(0);
                            int offset = originalText.indexOf(hexStringWithBraces) + 1;
                            this.dlog.error(new DiagnosticPos(this.diagnosticSrc, pos.sLine, pos.eLine, pos.sCol + offset, pos.sCol + offset + hexStringWithBraces.length()), DiagnosticCode.INVALID_UNICODE, hexStringWithBraces);
                        }
                        text = matcher.replaceFirst("\\\\u" + this.fillWithZeros(hexStringVal));
                        position = matcher.end() - 2;
                        matcher = this.pattern.matcher(text);
                    }
                    text = StringEscapeUtils.unescapeJava((String)text);
                    this.pkgBuilder.addLiteralValue(pos, ws, 5, text, node.getText());
                } else if (ctx.NullLiteral() != null) {
                    this.pkgBuilder.addLiteralValue(pos, ws, 10, null, "null");
                } else if (ctx.nilLiteral() != null) {
                    this.pkgBuilder.addLiteralValue(pos, ws, 10, null, "()");
                } else if (ctx.blobLiteral() != null) {
                    this.pkgBuilder.addLiteralValue(pos, ws, 33, ctx.blobLiteral().getText());
                }
            }
        }
    }

    @Override
    public void exitNamedArgs(BallerinaParser.NamedArgsContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addNamedArgument(this.getCurrentPos(ctx), this.getWS(ctx), ctx.Identifier().getText());
    }

    @Override
    public void exitRestArgs(BallerinaParser.RestArgsContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.addRestArgument(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void exitXmlLiteral(BallerinaParser.XmlLiteralContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.attachXmlLiteralWS(this.getWS(ctx));
    }

    @Override
    public void exitComment(BallerinaParser.CommentContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        Stack<String> stringFragments = this.getTemplateTextFragments(ctx.XMLCommentTemplateText());
        String endingString = this.getTemplateEndingStr(ctx.XMLCommentText());
        this.pkgBuilder.createXMLCommentLiteral(this.getCurrentPos(ctx), this.getWS(ctx), stringFragments, endingString);
        if (ctx.getParent() instanceof BallerinaParser.ContentContext) {
            this.pkgBuilder.addChildToXMLElement(this.getWS(ctx));
        }
    }

    @Override
    public void exitElement(BallerinaParser.ElementContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        if (ctx.getParent() instanceof BallerinaParser.ContentContext) {
            this.pkgBuilder.addChildToXMLElement(this.getWS(ctx));
        }
    }

    @Override
    public void exitStartTag(BallerinaParser.StartTagContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        boolean isRoot = ctx.parent.parent instanceof BallerinaParser.XmlItemContext;
        this.pkgBuilder.startXMLElement(this.getCurrentPos(ctx), this.getWS(ctx), isRoot);
    }

    @Override
    public void exitCloseTag(BallerinaParser.CloseTagContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.endXMLElement(this.getWS(ctx));
    }

    @Override
    public void exitEmptyTag(BallerinaParser.EmptyTagContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        boolean isRoot = ctx.parent.parent instanceof BallerinaParser.XmlItemContext;
        this.pkgBuilder.startXMLElement(this.getCurrentPos(ctx), this.getWS(ctx), isRoot);
    }

    @Override
    public void exitProcIns(BallerinaParser.ProcInsContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        String targetQName = ctx.XML_TAG_SPECIAL_OPEN().getText();
        targetQName = targetQName.substring(2, targetQName.length() - 1);
        Stack<String> textFragments = this.getTemplateTextFragments(ctx.XMLPITemplateText());
        String endingText = this.getTemplateEndingStr(ctx.XMLPIText());
        endingText = endingText.substring(0, endingText.length() - 2);
        this.pkgBuilder.createXMLPILiteral(this.getCurrentPos(ctx), this.getWS(ctx), targetQName, textFragments, endingText);
        if (ctx.getParent() instanceof BallerinaParser.ContentContext) {
            this.pkgBuilder.addChildToXMLElement(this.getWS(ctx));
        }
    }

    @Override
    public void exitAttribute(BallerinaParser.AttributeContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.createXMLAttribute(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void exitText(BallerinaParser.TextContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        Stack<String> textFragments = this.getTemplateTextFragments(ctx.XMLTemplateText());
        String endingText = this.getTemplateEndingStr(ctx.XMLText());
        if (ctx.getParent() instanceof BallerinaParser.ContentContext) {
            this.pkgBuilder.addXMLTextToElement(this.getCurrentPos(ctx), this.getWS(ctx), textFragments, endingText);
        } else {
            this.pkgBuilder.createXMLTextLiteral(this.getCurrentPos(ctx), this.getWS(ctx), textFragments, endingText);
        }
    }

    @Override
    public void exitXmlSingleQuotedString(BallerinaParser.XmlSingleQuotedStringContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        Stack<String> stringFragments = this.getTemplateTextFragments(ctx.XMLSingleQuotedTemplateString());
        String endingString = this.getTemplateEndingStr(ctx.XMLSingleQuotedString());
        this.pkgBuilder.createXMLQuotedLiteral(this.getCurrentPos(ctx), this.getWS(ctx), stringFragments, endingString, QuoteType.SINGLE_QUOTE);
    }

    @Override
    public void exitXmlDoubleQuotedString(BallerinaParser.XmlDoubleQuotedStringContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        Stack<String> stringFragments = this.getTemplateTextFragments(ctx.XMLDoubleQuotedTemplateString());
        String endingString = this.getTemplateEndingStr(ctx.XMLDoubleQuotedString());
        this.pkgBuilder.createXMLQuotedLiteral(this.getCurrentPos(ctx), this.getWS(ctx), stringFragments, endingString, QuoteType.DOUBLE_QUOTE);
    }

    @Override
    public void exitXmlQualifiedName(BallerinaParser.XmlQualifiedNameContext ctx) {
        String localname;
        if (this.isInErrorState) {
            return;
        }
        List<TerminalNode> qnames = ctx.XMLQName();
        String prefix = null;
        if (qnames.size() > 1) {
            prefix = qnames.get(0).getText();
            localname = qnames.get(1).getText();
        } else {
            localname = qnames.get(0).getText();
        }
        this.pkgBuilder.createXMLQName(this.getCurrentPos(ctx), this.getWS(ctx), localname, prefix);
    }

    @Override
    public void exitStringTemplateLiteral(BallerinaParser.StringTemplateLiteralContext ctx) {
        Stack<String> stringFragments;
        if (this.isInErrorState) {
            return;
        }
        String endingText = null;
        BallerinaParser.StringTemplateContentContext contentContext = ctx.stringTemplateContent();
        if (contentContext != null) {
            stringFragments = this.getTemplateTextFragments(contentContext.StringTemplateExpressionStart());
            endingText = this.getTemplateEndingStr(contentContext.StringTemplateText());
        } else {
            stringFragments = new Stack();
        }
        this.pkgBuilder.createStringTemplateLiteral(this.getCurrentPos(ctx), this.getWS(ctx), stringFragments, endingText);
    }

    @Override
    public void enterDocumentationString(BallerinaParser.DocumentationStringContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.startMarkdownDocumentationString(this.getCurrentPos(ctx));
    }

    @Override
    public void exitDocumentationString(BallerinaParser.DocumentationStringContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.endMarkdownDocumentationString(this.getWS(ctx));
    }

    @Override
    public void exitDocumentationLine(BallerinaParser.DocumentationLineContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.endMarkDownDocumentLine(this.getWS(ctx));
    }

    @Override
    public void exitDocumentationContent(BallerinaParser.DocumentationContentContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        String text = ctx.getText() != null ? ctx.getText() : "";
        this.pkgBuilder.endMarkdownDocumentationText(this.getCurrentPos(ctx), this.getWS(ctx), text);
    }

    @Override
    public void exitParameterDocumentationLine(BallerinaParser.ParameterDocumentationLineContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.endParameterDocumentationLine(this.getWS(ctx));
    }

    @Override
    public void exitParameterDocumentation(BallerinaParser.ParameterDocumentationContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        String parameterName = ctx.docParameterName() != null ? ctx.docParameterName().getText() : "";
        String description = ctx.documentationText() != null ? ctx.documentationText().getText() : "";
        this.pkgBuilder.endParameterDocumentation(this.getCurrentPos(ctx.docParameterName()), this.getWS(ctx), parameterName, description);
    }

    @Override
    public void exitParameterDescriptionLine(BallerinaParser.ParameterDescriptionLineContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        String description = ctx.documentationText() != null ? ctx.documentationText().getText() : "";
        this.pkgBuilder.endParameterDocumentationDescription(this.getWS(ctx), description);
    }

    @Override
    public void exitReturnParameterDocumentation(BallerinaParser.ReturnParameterDocumentationContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        String description = ctx.documentationText() != null ? ctx.documentationText().getText() : "";
        this.pkgBuilder.endReturnParameterDocumentation(this.getCurrentPos(ctx.getParent()), this.getWS(ctx), description);
    }

    @Override
    public void exitReturnParameterDescriptionLine(BallerinaParser.ReturnParameterDescriptionLineContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        String description = ctx.documentationText() != null ? ctx.documentationText().getText() : "";
        this.pkgBuilder.endReturnParameterDocumentationDescription(this.getWS(ctx), description);
    }

    @Override
    public void exitDeprecatedAnnotationDocumentation(BallerinaParser.DeprecatedAnnotationDocumentationContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        String str = ctx.DeprecatedDocumentation() != null ? ctx.DeprecatedDocumentation().getText() : "";
        this.pkgBuilder.endDeprecationAnnotationDocumentation(this.getCurrentPos(ctx.getParent()), this.getWS(ctx), str);
    }

    @Override
    public void exitDeprecateAnnotationDescriptionLine(BallerinaParser.DeprecateAnnotationDescriptionLineContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        String description = ctx.documentationText() != null ? ctx.documentationText().getText() : "";
        this.pkgBuilder.endDeprecateAnnotationDocumentationDescription(this.getWS(ctx), description);
    }

    @Override
    public void exitDeprecatedParametersDocumentation(BallerinaParser.DeprecatedParametersDocumentationContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.endDeprecatedParametersDocumentation(this.getCurrentPos(ctx.getParent()), this.getWS(ctx));
    }

    @Override
    public void exitTrapExpression(BallerinaParser.TrapExpressionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.createTrapExpr(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    @Override
    public void exitVariableReferenceExpression(BallerinaParser.VariableReferenceExpressionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        if (ctx.START() != null) {
            int numAnnotations = ctx.annotationAttachment().size();
            this.pkgBuilder.markLastInvocationAsAsync(this.getCurrentPos(ctx), numAnnotations);
        }
    }

    @Override
    public void exitDocumentationReference(BallerinaParser.DocumentationReferenceContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        BallerinaParser.ReferenceTypeContext referenceType = ctx.referenceType();
        BallerinaParser.SingleBacktickedContentContext backtickedContent = ctx.singleBacktickedContent();
        this.pkgBuilder.endDocumentationReference(this.getCurrentPos(ctx), referenceType.getText(), backtickedContent.getText());
    }

    @Override
    public void exitSingleBacktickedBlock(BallerinaParser.SingleBacktickedBlockContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        BallerinaParser.SingleBacktickedContentContext backtickedContent = ctx.singleBacktickedContent();
        this.pkgBuilder.endSingleBacktickedBlock(this.getCurrentPos(ctx), backtickedContent.getText());
    }

    @Override
    public void exitElvisExpression(BallerinaParser.ElvisExpressionContext ctx) {
        if (this.isInErrorState) {
            return;
        }
        this.pkgBuilder.createElvisExpr(this.getCurrentPos(ctx), this.getWS(ctx));
    }

    private DiagnosticPos getCurrentPos(ParserRuleContext ctx) {
        int startLine = ctx.getStart().getLine();
        int startCol = ctx.getStart().getCharPositionInLine() + 1;
        int endLine = -1;
        int endCol = -1;
        Token stop = ctx.getStop();
        if (stop != null) {
            endLine = stop.getLine();
            endCol = stop.getCharPositionInLine() + (stop.getStopIndex() - stop.getStartIndex() + 1) + 1;
        }
        return new DiagnosticPos(this.diagnosticSrc, startLine, endLine, startCol, endCol);
    }

    private DiagnosticPos getCurrentPos(TerminalNode node) {
        Token symbol = node.getSymbol();
        int startLine = symbol.getLine();
        int startCol = symbol.getCharPositionInLine() + 1;
        int endLine = startLine;
        int endCol = startCol + symbol.getText().length();
        return new DiagnosticPos(this.diagnosticSrc, startLine, endLine, startCol, endCol);
    }

    protected Set<Whitespace> getWS(ParserRuleContext ctx) {
        return null;
    }

    private Stack<String> getTemplateTextFragments(List<TerminalNode> nodes) {
        Stack<String> templateStrFragments = new Stack<String>();
        nodes.forEach(node -> {
            if (node == null) {
                templateStrFragments.push(null);
            } else {
                String str = node.getText();
                templateStrFragments.push(str.substring(0, str.length() - 2));
            }
        });
        return templateStrFragments;
    }

    private String getTemplateEndingStr(TerminalNode node) {
        return node == null ? null : node.getText();
    }

    private String getTemplateEndingStr(List<TerminalNode> nodes) {
        StringJoiner joiner = new StringJoiner("");
        nodes.forEach(node -> joiner.add(node.getText()));
        return joiner.toString();
    }

    private String getNodeValue(ParserRuleContext ctx, TerminalNode node) {
        String op = ctx.getChild(0).getText();
        String value = node.getText();
        if (op != null && "-".equals(op)) {
            value = "-" + value;
        }
        return value;
    }

    private String getHexNodeValue(ParserRuleContext ctx, TerminalNode node) {
        String value = this.getNodeValue(ctx, node);
        if (!value.contains("p") && !value.contains("P")) {
            value = value + "p0";
        }
        return value;
    }

    private Object getIntegerLiteral(ParserRuleContext simpleLiteralContext, BallerinaParser.IntegerLiteralContext integerLiteralContext) {
        if (integerLiteralContext.DecimalIntegerLiteral() != null) {
            String nodeValue = this.getNodeValue(simpleLiteralContext, integerLiteralContext.DecimalIntegerLiteral());
            return this.parseLong(simpleLiteralContext, nodeValue, nodeValue, 10, DiagnosticCode.INTEGER_TOO_SMALL, DiagnosticCode.INTEGER_TOO_LARGE);
        }
        if (integerLiteralContext.HexIntegerLiteral() != null) {
            String nodeValue = this.getNodeValue(simpleLiteralContext, integerLiteralContext.HexIntegerLiteral());
            String processedNodeValue = nodeValue.toLowerCase().replace("0x", "");
            return this.parseLong(simpleLiteralContext, nodeValue, processedNodeValue, 16, DiagnosticCode.HEXADECIMAL_TOO_SMALL, DiagnosticCode.HEXADECIMAL_TOO_LARGE);
        }
        return null;
    }

    private Object parseLong(ParserRuleContext context, String originalNodeValue, String processedNodeValue, int radix, DiagnosticCode code1, DiagnosticCode code2) {
        try {
            return Long.parseLong(processedNodeValue, radix);
        }
        catch (Exception e) {
            DiagnosticPos pos = this.getCurrentPos(context);
            Set<Whitespace> ws = this.getWS(context);
            if (originalNodeValue.startsWith("-")) {
                this.dlog.error(pos, code1, originalNodeValue);
            } else {
                this.dlog.error(pos, code2, originalNodeValue);
            }
            return originalNodeValue;
        }
    }

    public void setErrorState() {
        this.isInErrorState = true;
    }

    public void unsetErrorState() {
        this.isInErrorState = false;
    }

    boolean isInErrorState() {
        return this.isInErrorState;
    }
}

