/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.tree.CompilationUnitNode;
import org.ballerinalang.repository.CompilerInput;
import org.ballerinalang.repository.PackageSource;
import org.wso2.ballerinalang.compiler.PackageCache;
import org.wso2.ballerinalang.compiler.packaging.converters.FileSystemSourceInput;
import org.wso2.ballerinalang.compiler.parser.BLangParserListener;
import org.wso2.ballerinalang.compiler.parser.BLangWSPreservingParserListener;
import org.wso2.ballerinalang.compiler.parser.NodeCloner;
import org.wso2.ballerinalang.compiler.parser.ParserCache;
import org.wso2.ballerinalang.compiler.parser.antlr4.BallerinaLexer;
import org.wso2.ballerinalang.compiler.parser.antlr4.BallerinaParser;
import org.wso2.ballerinalang.compiler.parser.antlr4.BallerinaParserErrorListener;
import org.wso2.ballerinalang.compiler.parser.antlr4.BallerinaParserErrorStrategy;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangTestablePackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;
import org.wso2.ballerinalang.compiler.util.ProjectDirs;
import org.wso2.ballerinalang.compiler.util.diagnotic.BDiagnosticSource;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class Parser {
    private static final CompilerContext.Key<Parser> PARSER_KEY = new CompilerContext.Key();
    private final boolean preserveWhitespace;
    private CompilerContext context;
    private PackageCache pkgCache;
    private ParserCache parserCache;
    private NodeCloner nodeCloner;

    public static Parser getInstance(CompilerContext context) {
        Parser parser = context.get(PARSER_KEY);
        if (parser == null) {
            parser = new Parser(context);
        }
        return parser;
    }

    public Parser(CompilerContext context) {
        this.context = context;
        this.context.put(PARSER_KEY, this);
        CompilerOptions options = CompilerOptions.getInstance(context);
        this.preserveWhitespace = Boolean.parseBoolean(options.get(CompilerOptionName.PRESERVE_WHITESPACE));
        this.pkgCache = PackageCache.getInstance(context);
        this.parserCache = ParserCache.getInstance(context);
        this.nodeCloner = NodeCloner.getInstance(context);
    }

    public BLangPackage parse(PackageSource pkgSource, Path sourceRootPath) {
        PackageID pkgId = pkgSource.getPackageId();
        BLangPackage pkgNode = (BLangPackage)TreeBuilder.createPackageNode();
        this.pkgCache.put(pkgId, pkgNode);
        for (CompilerInput sourceInput : pkgSource.getPackageSourceEntries()) {
            if (ProjectDirs.isTestSource(((FileSystemSourceInput)sourceInput).getPath(), sourceRootPath, pkgId.getName().value)) {
                if (!pkgNode.containsTestablePkg()) {
                    BLangTestablePackage testablePkg = TreeBuilder.createTestablePackageNode();
                    testablePkg.flagSet.add(Flag.TESTABLE);
                    testablePkg.pos = new DiagnosticPos(new BDiagnosticSource(pkgId, pkgSource.getName()), 1, 1, 1, 1);
                    pkgNode.addTestablePkg(testablePkg);
                }
                pkgNode.getTestablePkg().addCompilationUnit(this.generateCompilationUnit(sourceInput, pkgId));
                continue;
            }
            pkgNode.addCompilationUnit(this.generateCompilationUnit(sourceInput, pkgId));
        }
        pkgNode.pos = new DiagnosticPos(new BDiagnosticSource(pkgId, pkgSource.getName()), 1, 1, 1, 1);
        pkgNode.repos = pkgSource.getRepoHierarchy();
        return pkgNode;
    }

    private CompilationUnitNode generateCompilationUnit(CompilerInput sourceEntry, PackageID packageID) {
        try {
            boolean inError;
            byte[] code = sourceEntry.getCode();
            String entryName = sourceEntry.getEntryName();
            int hash = Parser.getHash(code);
            int length = code.length;
            BLangCompilationUnit compilationUnit = this.parserCache.get(packageID, entryName, hash, length);
            if (compilationUnit == null && !(inError = this.populateCompilationUnit(compilationUnit = this.createCompilationUnit(sourceEntry, packageID), entryName, code))) {
                this.parserCache.put(packageID, entryName, hash, length, compilationUnit);
                compilationUnit = this.nodeCloner.cloneCUnit(compilationUnit);
            }
            return compilationUnit;
        }
        catch (IOException e) {
            throw new RuntimeException("error reading module: " + e.getMessage(), e);
        }
    }

    private BLangCompilationUnit createCompilationUnit(CompilerInput sourceEntry, PackageID packageID) {
        BDiagnosticSource diagnosticSrc = this.getDiagnosticSource(sourceEntry, packageID);
        BLangCompilationUnit compUnit = (BLangCompilationUnit)TreeBuilder.createCompilationUnit();
        compUnit.setName(sourceEntry.getEntryName());
        compUnit.pos = new DiagnosticPos(diagnosticSrc, 1, 1, 1, 1);
        return compUnit;
    }

    private boolean populateCompilationUnit(BLangCompilationUnit compUnit, String entryName, byte[] code) throws IOException {
        BDiagnosticSource diagnosticSrc = compUnit.pos.getSource();
        CommonTokenStream tokenStream = this.createTokenStream(entryName, code, diagnosticSrc);
        BallerinaParser parser = new BallerinaParser((TokenStream)tokenStream);
        parser.setErrorHandler((ANTLRErrorStrategy)this.getErrorStrategy(diagnosticSrc));
        BLangParserListener parserListener = this.newListener(tokenStream, compUnit, diagnosticSrc);
        parser.addParseListener(parserListener);
        parser.compilationUnit();
        return parserListener.isInErrorState();
    }

    private CommonTokenStream createTokenStream(String entryName, byte[] code, BDiagnosticSource diagnosticSrc) throws IOException {
        ANTLRInputStream ais = new ANTLRInputStream((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(code), StandardCharsets.UTF_8));
        ais.name = entryName;
        BallerinaLexer lexer = new BallerinaLexer((CharStream)ais);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)new BallerinaParserErrorListener(this.context, diagnosticSrc));
        return new CommonTokenStream((TokenSource)lexer);
    }

    private BLangParserListener newListener(CommonTokenStream tokenStream, CompilationUnitNode compUnit, BDiagnosticSource diagnosticSrc) {
        if (this.preserveWhitespace) {
            return new BLangWSPreservingParserListener(this.context, tokenStream, compUnit, diagnosticSrc);
        }
        return new BLangParserListener(this.context, compUnit, diagnosticSrc);
    }

    private BDiagnosticSource getDiagnosticSource(CompilerInput sourceEntry, PackageID packageID) {
        String entryName = sourceEntry.getEntryName();
        return new BDiagnosticSource(packageID, entryName);
    }

    private DefaultErrorStrategy getErrorStrategy(BDiagnosticSource diagnosticSrc) {
        DefaultErrorStrategy customErrorStrategy = this.context.get(DefaultErrorStrategy.class);
        if (customErrorStrategy == null) {
            customErrorStrategy = new BallerinaParserErrorStrategy(this.context, diagnosticSrc);
        } else {
            ((BallerinaParserErrorStrategy)customErrorStrategy).setDiagnosticSrc(diagnosticSrc);
        }
        return customErrorStrategy;
    }

    private static int getHash(byte[] code) {
        return Arrays.hashCode(code);
    }
}

