/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.IntStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.tree.DocReferenceErrorType;
import org.ballerinalang.model.tree.DocumentableNode;
import org.ballerinalang.model.tree.DocumentationReferenceType;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.SimpleVariableNode;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.util.diagnostic.DiagnosticCode;
import org.wso2.ballerinalang.compiler.parser.BLangReferenceParserListener;
import org.wso2.ballerinalang.compiler.parser.antlr4.BallerinaLexer;
import org.wso2.ballerinalang.compiler.parser.antlr4.BallerinaParser;
import org.wso2.ballerinalang.compiler.parser.antlr4.ReferenceParserErrorListener;
import org.wso2.ballerinalang.compiler.parser.antlr4.SilentParserErrorStrategy;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotation;
import org.wso2.ballerinalang.compiler.tree.BLangEndpoint;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangMarkdownDocumentation;
import org.wso2.ballerinalang.compiler.tree.BLangMarkdownReferenceDocumentation;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangResource;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangXMLNS;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLetExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkDownDeprecatedParametersDocumentation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkDownDeprecationDocumentation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkdownParameterDocumentation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkdownReturnParameterDocumentation;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.diagnotic.BLangDiagnosticLogHelper;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class DocumentationAnalyzer
extends BLangNodeVisitor {
    private static final CompilerContext.Key<DocumentationAnalyzer> DOCUMENTATION_ANALYZER_KEY = new CompilerContext.Key();
    private BLangDiagnosticLogHelper dlog;
    private final SymbolResolver symResolver;
    private final SymbolTable symTable;
    private SymbolEnv env;
    private Names names;
    private BLangReferenceParserListener listener;
    private BallerinaParser parser;

    public static DocumentationAnalyzer getInstance(CompilerContext context) {
        DocumentationAnalyzer documentationAnalyzer = context.get(DOCUMENTATION_ANALYZER_KEY);
        if (documentationAnalyzer == null) {
            documentationAnalyzer = new DocumentationAnalyzer(context);
        }
        return documentationAnalyzer;
    }

    private DocumentationAnalyzer(CompilerContext context) {
        context.put(DOCUMENTATION_ANALYZER_KEY, this);
        this.symResolver = SymbolResolver.getInstance(context);
        this.dlog = BLangDiagnosticLogHelper.getInstance(context);
        this.names = Names.getInstance(context);
        this.symTable = SymbolTable.getInstance(context);
        this.setupReferenceParser();
    }

    private void setupReferenceParser() {
        ANTLRInputStream ais = new ANTLRInputStream();
        BallerinaLexer lexer = new BallerinaLexer((CharStream)ais);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)new ReferenceParserErrorListener());
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        SilentParserErrorStrategy errorStrategy = new SilentParserErrorStrategy();
        this.parser = new BallerinaParser((TokenStream)tokenStream);
        this.listener = new BLangReferenceParserListener();
        this.parser.addParseListener(this.listener);
        this.parser.setErrorHandler((ANTLRErrorStrategy)errorStrategy);
    }

    public BLangPackage analyze(BLangPackage pkgNode) {
        this.env = this.symTable.pkgEnvMap.get(pkgNode.symbol);
        pkgNode.topLevelNodes.forEach(topLevelNode -> this.analyzeNode((BLangNode)((Object)topLevelNode)));
        pkgNode.completedPhases.add(CompilerPhase.CODE_ANALYZE);
        pkgNode.getTestablePkgs().forEach(this::analyze);
        return pkgNode;
    }

    private void analyzeNode(BLangNode node) {
        node.accept(this);
    }

    @Override
    public void visit(BLangImportPackage importPkgNode) {
    }

    @Override
    public void visit(BLangAnnotation annotationNode) {
    }

    @Override
    public void visit(BLangEndpoint endpointNode) {
    }

    @Override
    public void visit(BLangLetExpression letExpression) {
    }

    @Override
    public void visit(BLangConstant constant) {
        this.validateNoParameters(constant);
        this.validateReturnParameter(constant, null, false);
        this.validateReferences(constant);
        this.validateDeprecationDocumentation(constant.markdownDocumentationAttachment, Symbols.isFlagOn(constant.symbol.flags, 16), constant.pos);
        this.validateDeprecatedParametersDocumentation(constant.markdownDocumentationAttachment, constant.pos);
    }

    @Override
    public void visit(BLangSimpleVariable varNode) {
        this.validateNoParameters(varNode);
        this.validateReturnParameter(varNode, null, false);
        this.validateReferences(varNode);
        this.validateDeprecationDocumentation(varNode.markdownDocumentationAttachment, false, varNode.pos);
        this.validateDeprecatedParametersDocumentation(varNode.markdownDocumentationAttachment, varNode.pos);
    }

    @Override
    public void visit(BLangFunction funcNode) {
        this.validateParameters(funcNode, funcNode.getParameters(), funcNode.restParam, DiagnosticCode.UNDOCUMENTED_PARAMETER, DiagnosticCode.NO_SUCH_DOCUMENTABLE_PARAMETER, DiagnosticCode.PARAMETER_ALREADY_DOCUMENTED);
        this.validateDeprecatedParameters(funcNode, funcNode.getParameters(), funcNode.restParam, DiagnosticCode.PARAMETER_ALREADY_DOCUMENTED, DiagnosticCode.NO_SUCH_DOCUMENTABLE_PARAMETER);
        this.validateReferences(funcNode);
        boolean hasReturn = true;
        if (funcNode.returnTypeNode.getKind() == NodeKind.VALUE_TYPE) {
            hasReturn = ((BLangValueType)funcNode.returnTypeNode).typeKind != TypeKind.NIL;
        }
        this.validateReturnParameter(funcNode, funcNode, hasReturn);
        this.validateDeprecationDocumentation(funcNode.markdownDocumentationAttachment, Symbols.isFlagOn(funcNode.symbol.flags, 16), funcNode.pos);
    }

    @Override
    public void visit(BLangXMLNS xmlnsNode) {
    }

    @Override
    public void visit(BLangService serviceNode) {
        this.validateNoParameters(serviceNode);
        this.validateReturnParameter(serviceNode, null, false);
        this.validateReferences(serviceNode);
        this.validateDeprecationDocumentation(serviceNode.markdownDocumentationAttachment, false, serviceNode.pos);
        this.validateDeprecatedParametersDocumentation(serviceNode.markdownDocumentationAttachment, serviceNode.pos);
    }

    @Override
    public void visit(BLangTypeDefinition typeDefinition) {
        BLangType typeNode = typeDefinition.getTypeNode();
        if (typeDefinition.typeNode.getKind() == NodeKind.OBJECT_TYPE) {
            List fields = ((BLangObjectTypeNode)typeNode).fields;
            this.validateParameters(typeDefinition, fields, null, DiagnosticCode.UNDOCUMENTED_FIELD, DiagnosticCode.NO_SUCH_DOCUMENTABLE_FIELD, DiagnosticCode.FIELD_ALREADY_DOCUMENTED);
            this.validateReturnParameter(typeDefinition, null, false);
            this.validateReferences(typeDefinition);
            for (SimpleVariableNode field : fields) {
                this.validateReferences(field);
                this.validateDeprecationDocumentation(field.getMarkdownDocumentationAttachment(), Symbols.isFlagOn(((BLangSimpleVariable)field).symbol.flags, 16), (DiagnosticPos)field.getPosition());
            }
            ((BLangObjectTypeNode)typeDefinition.getTypeNode()).getFunctions().forEach(this::analyzeNode);
        } else if (typeDefinition.typeNode.getKind() == NodeKind.RECORD_TYPE) {
            List fields = ((BLangRecordTypeNode)typeNode).fields;
            this.validateParameters(typeDefinition, fields, null, DiagnosticCode.UNDOCUMENTED_FIELD, DiagnosticCode.NO_SUCH_DOCUMENTABLE_FIELD, DiagnosticCode.FIELD_ALREADY_DOCUMENTED);
            this.validateReturnParameter(typeDefinition, null, false);
            this.validateReferences(typeDefinition);
            for (SimpleVariableNode field : fields) {
                this.validateReferences(field);
            }
        }
        this.validateDeprecationDocumentation(typeDefinition.markdownDocumentationAttachment, Symbols.isFlagOn(typeDefinition.symbol.flags, 16), typeDefinition.pos);
        this.validateDeprecatedParametersDocumentation(typeDefinition.markdownDocumentationAttachment, typeDefinition.pos);
    }

    @Override
    public void visit(BLangResource resourceNode) {
        this.validateParameters(resourceNode, resourceNode.getParameters(), resourceNode.restParam, DiagnosticCode.UNDOCUMENTED_PARAMETER, DiagnosticCode.NO_SUCH_DOCUMENTABLE_PARAMETER, DiagnosticCode.PARAMETER_ALREADY_DOCUMENTED);
        this.validateReturnParameter(resourceNode, null, false);
        this.validateReferences(resourceNode);
    }

    private void validateDeprecationDocumentation(BLangMarkdownDocumentation documentation, boolean isDeprecationAnnotationAvailable, DiagnosticPos pos) {
        if (documentation == null) {
            return;
        }
        BLangMarkDownDeprecationDocumentation deprecationDocumentation = documentation.getDeprecationDocumentation();
        boolean isDeprecationDocumentationAvailable = false;
        if (deprecationDocumentation != null && deprecationDocumentation.isCorrectDeprecationLine) {
            isDeprecationDocumentationAvailable = true;
        }
        if (isDeprecationDocumentationAvailable && !isDeprecationAnnotationAvailable) {
            this.dlog.error(pos, DiagnosticCode.INVALID_DEPRECATION_DOCUMENTATION, new Object[0]);
        } else if (!isDeprecationDocumentationAvailable && isDeprecationAnnotationAvailable) {
            this.dlog.error(pos, DiagnosticCode.DEPRECATION_DOCUMENTATION_SHOULD_BE_AVAILABLE, new Object[0]);
        }
    }

    public void validateDeprecatedParametersDocumentation(BLangMarkdownDocumentation documentation, DiagnosticPos pos) {
        if (documentation == null) {
            return;
        }
        BLangMarkDownDeprecatedParametersDocumentation deprecatedParametersDocumentation = documentation.getDeprecatedParametersDocumentation();
        if (deprecatedParametersDocumentation != null) {
            this.dlog.error(pos, DiagnosticCode.DEPRECATED_PARAMETERS_DOCUMENTATION_NOT_ALLOWED, new Object[0]);
        }
    }

    private void validateReferences(DocumentableNode documentableNode) {
        BLangMarkdownDocumentation documentation = documentableNode.getMarkdownDocumentationAttachment();
        if (documentation == null) {
            return;
        }
        List references = documentation.getReferences();
        for (BLangMarkdownReferenceDocumentation reference : references) {
            DocReferenceErrorType status = this.invokeDocumentationReferenceParser(reference);
            if (status != DocReferenceErrorType.NO_ERROR) {
                if (status == DocReferenceErrorType.BACKTICK_IDENTIFIER_ERROR) continue;
                this.dlog.warning(reference.pos, DiagnosticCode.INVALID_DOCUMENTATION_IDENTIFIER, reference.referenceName);
                continue;
            }
            status = this.validateIdentifier(reference, documentableNode);
            if (status == DocReferenceErrorType.NO_ERROR) continue;
            if (status == DocReferenceErrorType.REFERENCE_ERROR) {
                this.dlog.warning(reference.pos, DiagnosticCode.INVALID_DOCUMENTATION_REFERENCE, reference.referenceName, reference.getType().getValue());
                continue;
            }
            this.dlog.warning(reference.pos, DiagnosticCode.INVALID_USAGE_OF_PARAMETER_REFERENCE, reference.referenceName);
        }
    }

    private DocReferenceErrorType validateIdentifier(BLangMarkdownReferenceDocumentation reference, DocumentableNode documentableNode) {
        int tag = -1;
        SymbolEnv env = this.env;
        switch (reference.getType()) {
            case PARAMETER: {
                if (documentableNode.getKind() == NodeKind.FUNCTION) {
                    BLangFunction funcNode = (BLangFunction)documentableNode;
                    env = SymbolEnv.createFunctionEnv(funcNode, funcNode.symbol.scope, this.env);
                    tag = 52;
                    break;
                }
                return DocReferenceErrorType.PARAMETER_REFERENCE_ERROR;
            }
            case SERVICE: {
                tag = 132;
                break;
            }
            case TYPE: {
                tag = 12;
                break;
            }
            case VARIABLE: 
            case VAR: {
                tag = 52;
                break;
            }
            case ANNOTATION: {
                tag = 2;
                break;
            }
            case MODULE: {
                tag = 1;
                break;
            }
            case CONST: {
                tag = 0x100001C;
                break;
            }
            case BACKTICK_CONTENT: 
            case FUNCTION: {
                tag = 820;
            }
        }
        BSymbol symbol = this.resolveFullyQualifiedSymbol(reference.pos, env, reference.qualifier, reference.typeName, reference.identifier, tag);
        return symbol != this.symTable.notFoundSymbol ? DocReferenceErrorType.NO_ERROR : DocReferenceErrorType.REFERENCE_ERROR;
    }

    private BSymbol resolveFullyQualifiedSymbol(DiagnosticPos pos, SymbolEnv env, String packageId, String type, String identifier, int tag) {
        BSymbol typeSymbol;
        Name identifierName = this.names.fromString(identifier);
        Name pkgName = this.names.fromString(packageId);
        Name typeName = this.names.fromString(type);
        SymbolEnv pkgEnv = env;
        if (pkgName != Names.EMPTY) {
            BSymbol pkgSymbol = this.symResolver.resolvePrefixSymbol(env, pkgName, this.names.fromString(pos.getSource().getCompilationUnitName()));
            if (pkgSymbol == this.symTable.notFoundSymbol) {
                return this.symTable.notFoundSymbol;
            }
            if (pkgSymbol.tag == 4097) {
                BPackageSymbol symbol = (BPackageSymbol)pkgSymbol;
                pkgEnv = this.symTable.pkgEnvMap.get(symbol);
            }
        }
        if (typeName == Names.EMPTY) {
            if ((tag & 1) == 1) {
                return this.symResolver.lookupPrefixSpaceSymbolInPackage(pos, env, pkgName, identifierName);
            }
            if ((tag & 2) == 2) {
                return this.symResolver.lookupAnnotationSpaceSymbolInPackage(pos, env, pkgName, identifierName);
            }
            if ((tag & 4) == 4) {
                return this.symResolver.lookupMainSpaceSymbolInPackage(pos, env, pkgName, identifierName);
            }
        }
        if ((typeSymbol = this.symResolver.lookupMainSpaceSymbolInPackage(pos, env, pkgName, typeName)) == this.symTable.notFoundSymbol) {
            return this.symTable.notFoundSymbol;
        }
        if (typeSymbol.tag == 196700) {
            BObjectTypeSymbol objectTypeSymbol = (BObjectTypeSymbol)typeSymbol;
            String functionID = typeName + "." + identifierName;
            Name functionName = this.names.fromString(functionID);
            return this.symResolver.lookupMemberSymbol(pos, objectTypeSymbol.methodScope, pkgEnv, functionName, tag);
        }
        return this.symTable.notFoundSymbol;
    }

    private DocReferenceErrorType invokeDocumentationReferenceParser(BLangMarkdownReferenceDocumentation reference) {
        ANTLRInputStream ais = new ANTLRInputStream(reference.referenceName);
        BallerinaLexer lexer = new BallerinaLexer((CharStream)ais);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)new ReferenceParserErrorListener());
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        this.listener.reset();
        this.parser.setInputStream((IntStream)tokenStream);
        if (reference.getType() == DocumentationReferenceType.BACKTICK_CONTENT) {
            this.parser.documentationFullyqualifiedFunctionIdentifier();
            if (this.listener.getState()) {
                return DocReferenceErrorType.BACKTICK_IDENTIFIER_ERROR;
            }
        } else {
            this.parser.documentationFullyqualifiedIdentifier();
            if (this.listener.getState()) {
                return DocReferenceErrorType.IDENTIFIER_ERROR;
            }
        }
        if (reference.getType() != DocumentationReferenceType.FUNCTION && this.listener.hasBrackets()) {
            return DocReferenceErrorType.IDENTIFIER_ERROR;
        }
        reference.qualifier = this.listener.getPkgName();
        reference.typeName = this.listener.getTypeName();
        reference.identifier = this.listener.getIdentifier();
        return DocReferenceErrorType.NO_ERROR;
    }

    private void validateParameters(DocumentableNode documentableNode, List<BLangSimpleVariable> actualParameters, BLangSimpleVariable restParam, DiagnosticCode undocumentedParameter, DiagnosticCode noSuchParameter, DiagnosticCode parameterAlreadyDefined) {
        BLangMarkdownDocumentation documentation = documentableNode.getMarkdownDocumentationAttachment();
        if (documentation == null) {
            return;
        }
        List<String> fieldsDocumentedAtFieldLevel = this.getDocumentedFields(actualParameters);
        Map<String, BLangMarkdownParameterDocumentation> documentedParameterMap = this.getDocumentedParameters(documentation.parameters, fieldsDocumentedAtFieldLevel, parameterAlreadyDefined);
        actualParameters.forEach(parameter -> {
            String name = parameter.getName().getValue();
            BLangMarkdownParameterDocumentation param = (BLangMarkdownParameterDocumentation)documentedParameterMap.get(name);
            if (param != null) {
                param.setSymbol(parameter.symbol);
                documentedParameterMap.remove(name);
            } else {
                if (Symbols.isFlagOn(parameter.symbol.flags, 1) && parameter.markdownDocumentationAttachment == null) {
                    this.dlog.warning(parameter.pos, undocumentedParameter, name);
                }
                if (documentableNode.getKind() == NodeKind.FUNCTION) {
                    BLangFunction function = (BLangFunction)documentableNode;
                    if (function.flagSet.contains((Object)Flag.PUBLIC)) {
                        this.dlog.warning(parameter.pos, undocumentedParameter, name);
                    }
                }
            }
        });
        if (restParam != null) {
            String name2 = restParam.getName().value;
            BLangMarkdownParameterDocumentation param = documentedParameterMap.get(name2);
            if (param != null) {
                param.setSymbol(restParam.symbol);
                documentedParameterMap.remove(name2);
            } else {
                this.dlog.warning(restParam.pos, undocumentedParameter, name2);
            }
        }
        documentedParameterMap.forEach((name, node) -> this.dlog.warning(node.pos, noSuchParameter, name));
    }

    private void validateNoParameters(DocumentableNode documentableNode) {
        BLangMarkdownDocumentation documentation = documentableNode.getMarkdownDocumentationAttachment();
        if (documentation == null) {
            return;
        }
        Map<String, BLangMarkdownParameterDocumentation> parameterDocumentations = documentation.getParameterDocumentations();
        if (parameterDocumentations.isEmpty()) {
            return;
        }
        parameterDocumentations.forEach((parameter, parameterDocumentation) -> this.dlog.warning(parameterDocumentation.pos, DiagnosticCode.NO_SUCH_DOCUMENTABLE_PARAMETER, parameter));
    }

    private void validateReturnParameter(DocumentableNode documentableNode, BLangNode node, boolean isExpected) {
        BLangMarkdownDocumentation documentationAttachment = documentableNode.getMarkdownDocumentationAttachment();
        if (documentationAttachment == null) {
            return;
        }
        BLangMarkdownReturnParameterDocumentation returnParameter = documentationAttachment.getReturnParameter();
        if (returnParameter == null && isExpected) {
            this.dlog.warning(node.pos, DiagnosticCode.UNDOCUMENTED_RETURN_PARAMETER, new Object[0]);
        } else if (returnParameter != null && !isExpected) {
            this.dlog.warning(returnParameter.pos, DiagnosticCode.NO_DOCUMENTABLE_RETURN_PARAMETER, new Object[0]);
        } else if (returnParameter != null) {
            returnParameter.setReturnType(((BLangFunction)node).getReturnTypeNode().type);
        }
    }

    private List<String> getDocumentedFields(List<? extends SimpleVariableNode> actualParameters) {
        ArrayList<String> fieldsDocumentedAtFieldLevel = new ArrayList<String>();
        for (SimpleVariableNode simpleVariableNode : actualParameters) {
            if (simpleVariableNode.getMarkdownDocumentationAttachment() == null) continue;
            fieldsDocumentedAtFieldLevel.add(simpleVariableNode.getName().getValue());
        }
        return fieldsDocumentedAtFieldLevel;
    }

    private Map<String, BLangMarkdownParameterDocumentation> getDocumentedParameters(LinkedList<BLangMarkdownParameterDocumentation> deprecatedParameters, List<String> fieldsDocumentedFields, DiagnosticCode parameterAlreadyDefined) {
        HashMap<String, BLangMarkdownParameterDocumentation> documentedDeprecatedParameterMap = new HashMap<String, BLangMarkdownParameterDocumentation>();
        for (BLangMarkdownParameterDocumentation parameter : deprecatedParameters) {
            String parameterName = parameter.getParameterName().getValue();
            if (documentedDeprecatedParameterMap.containsKey(parameterName) || fieldsDocumentedFields.contains(parameterName)) {
                this.dlog.warning(parameter.pos, parameterAlreadyDefined, parameterName);
                continue;
            }
            documentedDeprecatedParameterMap.put(parameterName, parameter);
        }
        return documentedDeprecatedParameterMap;
    }

    private void validateDeprecatedParameters(DocumentableNode documentableNode, List<BLangSimpleVariable> actualParameters, BLangSimpleVariable restParam, DiagnosticCode parameterAlreadyDefined, DiagnosticCode noSuchParameter) {
        BLangMarkdownDocumentation documentation = documentableNode.getMarkdownDocumentationAttachment();
        if (documentation == null) {
            return;
        }
        HashMap<String, BLangMarkdownParameterDocumentation> documentedDeprecatedParameterMap = new HashMap<String, BLangMarkdownParameterDocumentation>();
        if (documentation.deprecatedParametersDocumentation != null) {
            documentedDeprecatedParameterMap = this.getDocumentedParameters(documentation.deprecatedParametersDocumentation.parameters, new ArrayList<String>(), parameterAlreadyDefined);
        }
        for (BLangSimpleVariable parameter : actualParameters) {
            this.validateDeprecatedParameter(documentedDeprecatedParameterMap, parameter);
        }
        if (restParam != null) {
            this.validateDeprecatedParameter(documentedDeprecatedParameterMap, restParam);
        }
        documentedDeprecatedParameterMap.forEach((name, node) -> this.dlog.warning(node.pos, noSuchParameter, name));
    }

    private void validateDeprecatedParameter(Map<String, BLangMarkdownParameterDocumentation> documentedDeprecatedParameterMap, BLangSimpleVariable parameter) {
        String name = parameter.getName().value;
        if (!documentedDeprecatedParameterMap.containsKey(name)) {
            if (Symbols.isFlagOn(parameter.symbol.flags, 16)) {
                this.dlog.error(parameter.pos, DiagnosticCode.DEPRECATION_DOCUMENTATION_SHOULD_BE_AVAILABLE, new Object[0]);
            }
        } else {
            if (!Symbols.isFlagOn(parameter.symbol.flags, 16)) {
                this.dlog.error(documentedDeprecatedParameterMap.get((Object)name).pos, DiagnosticCode.INVALID_DEPRECATION_DOCUMENTATION, new Object[0]);
            }
            documentedDeprecatedParameterMap.remove(name);
        }
    }
}

