/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer.cyclefind;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.tree.Node;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.TopLevelNode;
import org.ballerinalang.util.diagnostic.DiagnosticCode;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.diagnotic.BLangDiagnosticLogHelper;

public class GlobalVariableRefAnalyzer {
    private static final CompilerContext.Key<GlobalVariableRefAnalyzer> REF_ANALYZER_KEY = new CompilerContext.Key();
    private final BLangDiagnosticLogHelper dlog;
    private BLangPackage pkgNode;
    private Map<BSymbol, Set<BSymbol>> globalNodeDependsOn;
    private final Map<BSymbol, NodeInfo> dependencyNodes;
    private final Deque<NodeInfo> nodeInfoStack;
    private final List<List<NodeInfo>> cycles;
    private final List<NodeInfo> dependencyOrder;
    private int curNodeId;

    public static GlobalVariableRefAnalyzer getInstance(CompilerContext context) {
        GlobalVariableRefAnalyzer refAnalyzer = context.get(REF_ANALYZER_KEY);
        if (refAnalyzer == null) {
            refAnalyzer = new GlobalVariableRefAnalyzer(context);
        }
        return refAnalyzer;
    }

    private GlobalVariableRefAnalyzer(CompilerContext context) {
        context.put(REF_ANALYZER_KEY, this);
        this.dlog = BLangDiagnosticLogHelper.getInstance(context);
        this.dependencyNodes = new HashMap<BSymbol, NodeInfo>();
        this.cycles = new ArrayList<List<NodeInfo>>();
        this.nodeInfoStack = new ArrayDeque<NodeInfo>();
        this.dependencyOrder = new ArrayList<NodeInfo>();
    }

    public void analyzeAndReOrder(BLangPackage pkgNode, Map<BSymbol, Set<BSymbol>> globalNodeDependsOn) {
        this.pkgNode = pkgNode;
        this.globalNodeDependsOn = globalNodeDependsOn;
        this.resetAnalyzer();
        List<BSymbol> globalVarsAndDependentFuncs = this.getGlobalVariablesAndDependentFunctions();
        this.pruneDependencyRelations();
        LinkedHashSet<BSymbol> sorted = new LinkedHashSet<BSymbol>();
        LinkedList<BSymbol> dependencies = new LinkedList<BSymbol>();
        for (BSymbol symbol : globalVarsAndDependentFuncs) {
            boolean notInSortedList;
            List<BSymbol> dependencyTrain = this.analyzeDependenciesStartingFrom(symbol);
            dependencies.addAll(dependencyTrain);
            Set<BSymbol> symbolsProviders = globalNodeDependsOn.get(symbol);
            boolean symbolHasProviders = symbolsProviders != null && !symbolsProviders.isEmpty();
            boolean bl = notInSortedList = !sorted.contains(symbol);
            if (notInSortedList && !symbolHasProviders) {
                this.moveAndAppendToSortedList(symbol, dependencies, sorted);
            }
            if (notInSortedList && symbolHasProviders && sorted.containsAll(symbolsProviders)) {
                this.moveAndAppendToSortedList(symbol, dependencies, sorted);
            }
            this.addDependenciesDependencies(dependencies, sorted);
        }
        sorted.addAll(dependencies);
        if (this.cycles.stream().anyMatch(cycle -> cycle.size() > 1)) {
            return;
        }
        this.sortConstants(sorted);
        this.projectSortToGlobalVarsList(sorted);
        this.projectSortToTopLevelNodesList();
    }

    private List<BSymbol> analyzeDependenciesStartingFrom(BSymbol symbol) {
        if (!this.dependencyNodes.containsKey(symbol)) {
            NodeInfo node = new NodeInfo(this.curNodeId++, symbol);
            this.dependencyNodes.put(symbol, node);
            this.analyzeProvidersRecursively(node);
        }
        if (!this.dependencyOrder.isEmpty()) {
            List<BSymbol> symbolsProvidersOrdered = this.dependencyOrder.stream().map(nodeInfo -> nodeInfo.symbol).collect(Collectors.toList());
            this.dependencyOrder.clear();
            return symbolsProvidersOrdered;
        }
        return new ArrayList<BSymbol>();
    }

    private void resetAnalyzer() {
        this.dependencyNodes.clear();
        this.cycles.clear();
        this.nodeInfoStack.clear();
        this.dependencyOrder.clear();
    }

    private void pruneDependencyRelations() {
        ArrayList<BSymbol> dependents = new ArrayList<BSymbol>(this.globalNodeDependsOn.keySet());
        HashSet<BSymbol> visited = new HashSet<BSymbol>();
        for (BSymbol dependent : dependents) {
            ArrayList providers = new ArrayList(this.globalNodeDependsOn.get(dependent));
            for (BSymbol provider : providers) {
                this.pruneFunctions(dependent, provider, this.globalNodeDependsOn, visited);
            }
        }
    }

    private void pruneFunctions(BSymbol dependent, BSymbol provider, Map<BSymbol, Set<BSymbol>> globalNodeDependsOn, Set<BSymbol> visited) {
        if (visited.contains(provider)) {
            return;
        }
        visited.add(provider);
        if (provider.kind != SymbolKind.FUNCTION) {
            return;
        }
        if (!globalNodeDependsOn.containsKey(provider) || globalNodeDependsOn.get(provider).isEmpty()) {
            globalNodeDependsOn.get(dependent).remove(provider);
            return;
        }
        ArrayList providersProviders = new ArrayList(globalNodeDependsOn.get(provider));
        for (BSymbol prov : providersProviders) {
            this.pruneFunctions(provider, prov, globalNodeDependsOn, visited);
        }
    }

    private void addDependenciesDependencies(LinkedList<BSymbol> dependencies, Set<BSymbol> sorted) {
        ArrayList<BSymbol> depCopy = new ArrayList<BSymbol>(dependencies);
        for (BSymbol dep : depCopy) {
            Set depsDependencies = this.globalNodeDependsOn.getOrDefault(dep, new LinkedHashSet());
            if (depsDependencies.isEmpty() || !sorted.containsAll(depsDependencies)) continue;
            this.moveAndAppendToSortedList(dep, dependencies, sorted);
        }
    }

    private void projectSortToTopLevelNodesList() {
        Integer targetIndex;
        ArrayList<Integer> topLevelPositions = new ArrayList<Integer>();
        for (BLangSimpleVariable globalVar : this.pkgNode.globalVars) {
            topLevelPositions.add(this.pkgNode.topLevelNodes.indexOf(globalVar));
        }
        topLevelPositions.sort(Comparator.comparingInt(i -> i));
        for (int i2 = 0; i2 < topLevelPositions.size(); ++i2) {
            targetIndex = (Integer)topLevelPositions.get(i2);
            this.pkgNode.topLevelNodes.set(targetIndex, this.pkgNode.globalVars.get(i2));
        }
        topLevelPositions = new ArrayList();
        for (BLangConstant constant : this.pkgNode.constants) {
            topLevelPositions.add(this.pkgNode.topLevelNodes.indexOf(constant));
        }
        topLevelPositions.sort(Comparator.comparingInt(i -> i));
        for (int i3 = 0; i3 < topLevelPositions.size(); ++i3) {
            targetIndex = (Integer)topLevelPositions.get(i3);
            this.pkgNode.topLevelNodes.set(targetIndex, this.pkgNode.constants.get(i3));
        }
    }

    private void projectSortToGlobalVarsList(Set<BSymbol> sorted) {
        Map<BSymbol, BLangSimpleVariable> varMap = this.pkgNode.globalVars.stream().collect(Collectors.toMap(k -> k.symbol, k -> k));
        List sortedGlobalVars = sorted.stream().filter(varMap::containsKey).map(varMap::get).collect(Collectors.toList());
        if (sortedGlobalVars.size() != this.pkgNode.globalVars.size()) {
            List symbolLessGlobalVars = this.pkgNode.globalVars.stream().filter(g -> g.symbol == null).collect(Collectors.toList());
            sortedGlobalVars.addAll(symbolLessGlobalVars);
        }
        this.pkgNode.globalVars.clear();
        this.pkgNode.globalVars.addAll(sortedGlobalVars);
    }

    private void sortConstants(Set<BSymbol> sorted) {
        Map<BSymbol, BLangConstant> varMap = this.pkgNode.constants.stream().collect(Collectors.toMap(k -> k.symbol, k -> k));
        List sortedConstants = sorted.stream().filter(varMap::containsKey).map(varMap::get).collect(Collectors.toList());
        if (sortedConstants.size() != this.pkgNode.constants.size()) {
            List symbolLessGlobalVars = this.pkgNode.constants.stream().filter(c -> !sortedConstants.contains(c)).collect(Collectors.toList());
            sortedConstants.addAll(symbolLessGlobalVars);
        }
        this.pkgNode.constants.clear();
        this.pkgNode.constants.addAll(sortedConstants);
    }

    private List<BSymbol> getGlobalVariablesAndDependentFunctions() {
        ArrayList<BSymbol> dependents = new ArrayList<BSymbol>();
        for (BSymbol s : this.globalNodeDependsOn.keySet()) {
            if ((s.tag & 0x334) != 820) continue;
            dependents.add(s);
        }
        for (BLangSimpleVariable var : this.pkgNode.globalVars) {
            if (var.symbol == null) continue;
            dependents.add(var.symbol);
        }
        for (BLangConstant constant : this.pkgNode.constants) {
            if (constant.symbol == null) continue;
            dependents.add(constant.symbol);
        }
        return dependents;
    }

    private void moveAndAppendToSortedList(BSymbol symbol, List<BSymbol> moveFrom, Set<BSymbol> sorted) {
        sorted.add(symbol);
        moveFrom.remove(symbol);
    }

    private int analyzeProvidersRecursively(NodeInfo node) {
        if (node.visited) {
            return node.lowLink;
        }
        node.visited = true;
        node.lowLink = node.id;
        node.onStack = true;
        this.nodeInfoStack.push(node);
        Set providers = this.globalNodeDependsOn.getOrDefault(node.symbol, new LinkedHashSet());
        for (BSymbol providerSym : providers) {
            NodeInfo providerNode = this.dependencyNodes.computeIfAbsent(providerSym, s -> new NodeInfo(this.curNodeId++, providerSym));
            int lastLowLink = this.analyzeProvidersRecursively(providerNode);
            if (!providerNode.onStack) continue;
            node.lowLink = Math.min(node.lowLink, lastLowLink);
        }
        if (node.id == node.lowLink) {
            this.handleCyclicReferenceError(node);
        }
        this.dependencyOrder.add(node);
        return node.lowLink;
    }

    private void handleCyclicReferenceError(NodeInfo node) {
        ArrayList<NodeInfo> cycle = new ArrayList<NodeInfo>();
        while (!this.nodeInfoStack.isEmpty()) {
            NodeInfo cNode = this.nodeInfoStack.pop();
            cNode.onStack = false;
            cNode.lowLink = node.id;
            cycle.add(cNode);
            if (cNode.id != node.id) continue;
            break;
        }
        this.cycles.add(cycle);
        if (cycle.size() > 1) {
            cycle = new ArrayList(cycle);
            Collections.reverse(cycle);
            List<BSymbol> symbolsOfCycle = cycle.stream().map(n -> n.symbol).collect(Collectors.toList());
            if (this.doesContainAGlobalVar(symbolsOfCycle)) {
                this.emitErrorMessage(symbolsOfCycle);
            }
        }
    }

    private void emitErrorMessage(List<BSymbol> symbolsOfCycle) {
        Optional<BSymbol> firstGlobalVar = symbolsOfCycle.stream().filter(s -> s.kind != SymbolKind.FUNCTION).findAny();
        if (!firstGlobalVar.isPresent()) {
            return;
        }
        BSymbol firstNodeSymbol = firstGlobalVar.get();
        Optional<BLangNode> firstNode = this.pkgNode.topLevelNodes.stream().filter(t -> (t.getKind() == NodeKind.VARIABLE || t.getKind() == NodeKind.FUNCTION) && this.getSymbol((Node)t) == firstNodeSymbol).map(t -> (BLangNode)((Object)t)).findAny();
        int splitFrom = symbolsOfCycle.indexOf(firstNodeSymbol);
        int len = symbolsOfCycle.size();
        ArrayList<BSymbol> firstSubList = new ArrayList<BSymbol>(symbolsOfCycle.subList(0, splitFrom));
        ArrayList<BSymbol> secondSubList = new ArrayList<BSymbol>(symbolsOfCycle.subList(splitFrom, len));
        secondSubList.addAll(firstSubList);
        if (firstNode.isPresent()) {
            List names = secondSubList.stream().map(this::getNodeName).collect(Collectors.toList());
            this.dlog.error(firstNode.get().pos, DiagnosticCode.GLOBAL_VARIABLE_CYCLIC_DEFINITION, names);
        }
    }

    private boolean doesContainAGlobalVar(List<BSymbol> symbolsOfCycle) {
        return this.pkgNode.globalVars.stream().map(v -> v.symbol).anyMatch(symbolsOfCycle::contains);
    }

    private BLangIdentifier getNodeName(BSymbol symbol) {
        for (TopLevelNode node : this.pkgNode.topLevelNodes) {
            if (this.getSymbol(node) != symbol) continue;
            if (node.getKind() == NodeKind.VARIABLE) {
                return ((BLangSimpleVariable)node).name;
            }
            if (node.getKind() == NodeKind.FUNCTION) {
                return ((BLangFunction)node).name;
            }
            if (node.getKind() != NodeKind.TYPE_DEFINITION || ((BLangTypeDefinition)node).typeNode.getKind() != NodeKind.OBJECT_TYPE) continue;
            return ((BLangTypeDefinition)node).name;
        }
        throw new IllegalArgumentException("Cannot find topLevelNode: " + symbol);
    }

    private BSymbol getSymbol(Node node) {
        if (node.getKind() == NodeKind.VARIABLE) {
            return ((BLangVariable)node).symbol;
        }
        if (node.getKind() == NodeKind.FUNCTION) {
            return ((BLangFunction)node).symbol;
        }
        if (node.getKind() == NodeKind.TYPE_DEFINITION && ((BLangTypeDefinition)node).typeNode.getKind() == NodeKind.OBJECT_TYPE) {
            return ((BLangObjectTypeNode)((BLangTypeDefinition)node).typeNode).symbol;
        }
        return null;
    }

    private static class NodeInfo {
        final int id;
        final BSymbol symbol;
        int lowLink;
        boolean visited;
        boolean onStack;

        NodeInfo(int id, BSymbol symbol) {
            this.id = id;
            this.symbol = symbol;
        }

        public String toString() {
            return "NodeInfo{id=" + this.id + ", lowLink=" + this.lowLink + ", visited=" + this.visited + ", onStack=" + this.onStack + ", symbol=" + this.symbol + '}';
        }
    }
}

