/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.types;

import org.ballerinalang.model.types.ArrayType;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.semantics.model.TypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeVisitor;
import org.wso2.ballerinalang.compiler.util.BArrayState;

public class BArrayType
extends BType
implements ArrayType {
    private static final String SEMI_COLON = ";";
    public BType eType;
    public int size = -1;
    public BArrayState state = BArrayState.UNSEALED;

    public BArrayType(BType elementType) {
        super(19, null);
        this.eType = elementType;
    }

    public BArrayType(BType elementType, BTypeSymbol tsymbol) {
        super(19, tsymbol);
        this.eType = elementType;
    }

    public BArrayType(BType elementType, BTypeSymbol tsymbol, int size, BArrayState state) {
        super(19, tsymbol);
        this.eType = elementType;
        this.size = size;
        this.state = state;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public BType getElementType() {
        return this.eType;
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.ARRAY;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T, R> R accept(BTypeVisitor<T, R> visitor, T t) {
        return visitor.visit(this, t);
    }

    @Override
    public String toString() {
        String tempSize;
        StringBuilder sb = new StringBuilder(this.eType.toString());
        String string = tempSize = this.state == BArrayState.OPEN_SEALED ? "*" : String.valueOf(this.size);
        if (this.eType.tag == 19) {
            return this.state != BArrayState.UNSEALED ? sb.insert(sb.indexOf("["), "[" + tempSize + "]").toString() : sb.insert(sb.indexOf("["), "[]").toString();
        }
        return this.state != BArrayState.UNSEALED ? sb.append("[").append(tempSize).append("]").toString() : sb.append("[]").toString();
    }

    @Override
    public final boolean isAnydata() {
        return this.eType.isPureType();
    }
}

