/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree.expressions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.expressions.ListConstructorExprNode;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class BLangListConstructorExpr
extends BLangExpression
implements ListConstructorExprNode {
    public List<BLangExpression> exprs;
    public boolean isTypedescExpr = false;
    public BType typedescType = null;

    @Override
    public NodeKind getKind() {
        return NodeKind.LIST_CONSTRUCTOR_EXPR;
    }

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    public List<BLangExpression> getExpressions() {
        return this.exprs;
    }

    public String toString() {
        return Arrays.toString(this.exprs.toArray());
    }

    public static class BLangJSONArrayLiteral
    extends BLangArrayLiteral {
        public BLangJSONArrayLiteral(List<BLangExpression> exprs, BType jsonType) {
            this.exprs = exprs;
            this.type = jsonType;
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BLangTupleLiteral
    extends BLangListConstructorExpr {
        public BLangTupleLiteral() {
            this.exprs = new ArrayList();
        }

        public BLangTupleLiteral(DiagnosticPos pos, List<BLangExpression> exprs, BType tupleType) {
            this.pos = pos;
            this.exprs = exprs;
            this.type = tupleType;
        }

        @Override
        public NodeKind getKind() {
            return NodeKind.TUPLE_LITERAL_EXPR;
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BLangArrayLiteral
    extends BLangListConstructorExpr {
        public BLangArrayLiteral() {
            this.exprs = new ArrayList();
        }

        public BLangArrayLiteral(DiagnosticPos pos, List<BLangExpression> exprs, BType tupleType) {
            this.pos = pos;
            this.exprs = exprs;
            this.type = tupleType;
        }

        @Override
        public NodeKind getKind() {
            return NodeKind.ARRAY_LITERAL_EXPR;
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }
    }
}

