/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree.expressions;

import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.expressions.SimpleVariableReferenceNode;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangVariableReference;

public class BLangSimpleVarRef
extends BLangVariableReference
implements SimpleVariableReferenceNode {
    public BSymbol varSymbol;
    public BLangIdentifier pkgAlias;
    public BLangIdentifier variableName;

    @Override
    public BLangIdentifier getPackageAlias() {
        return this.pkgAlias;
    }

    @Override
    public BLangIdentifier getVariableName() {
        return this.variableName;
    }

    public String toString() {
        StringBuilder br = new StringBuilder();
        if (this.pkgAlias != null && !this.pkgAlias.getValue().isEmpty()) {
            br.append(String.valueOf(this.pkgAlias)).append(":");
        }
        br.append(this.variableName == null ? String.valueOf(this.varSymbol.name) : String.valueOf(this.variableName));
        return br.toString();
    }

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.SIMPLE_VARIABLE_REF;
    }

    public static class BLangTypeLoad
    extends BLangSimpleVarRef {
        public BLangTypeLoad(BSymbol varSymbol) {
            this.symbol = varSymbol;
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BLangFunctionVarRef
    extends BLangSimpleVarRef {
        public BLangFunctionVarRef(BVarSymbol varSymbol) {
            this.symbol = varSymbol;
            this.varSymbol = varSymbol;
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BLangPackageVarRef
    extends BLangSimpleVarRef {
        public BLangPackageVarRef(BVarSymbol varSymbol) {
            this.symbol = varSymbol;
            this.varSymbol = varSymbol;
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BLangFieldVarRef
    extends BLangSimpleVarRef {
        public BLangFieldVarRef(BVarSymbol varSymbol) {
            this.symbol = varSymbol;
            this.varSymbol = varSymbol;
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BLangLocalVarRef
    extends BLangSimpleVarRef {
        public boolean closureDesugared = false;

        public BLangLocalVarRef(BVarSymbol varSymbol) {
            this.symbol = varSymbol;
            this.varSymbol = varSymbol;
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String toString() {
            return this.symbol.name.value;
        }
    }
}

