/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree.statements;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.statements.MatchNode;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;

public class BLangMatch
extends BLangStatement
implements MatchNode {
    public BLangExpression expr;
    public List<BLangMatchBindingPatternClause> patternClauses = new ArrayList<BLangMatchBindingPatternClause>();
    public List<BType> exprTypes = new ArrayList<BType>();

    @Override
    public NodeKind getKind() {
        return NodeKind.MATCH;
    }

    @Override
    public BLangExpression getExpression() {
        return this.expr;
    }

    public List<BLangMatchBindingPatternClause> getPatternClauses() {
        return this.patternClauses;
    }

    public List<BLangMatchStaticBindingPatternClause> getStaticPatternClauses() {
        return this.patternClauses.stream().filter(pattern -> NodeKind.MATCH_STATIC_PATTERN_CLAUSE == pattern.getKind()).map(BLangMatchStaticBindingPatternClause.class::cast).collect(Collectors.toList());
    }

    public List<BLangMatchStructuredBindingPatternClause> getStructuredPatternClauses() {
        return this.patternClauses.stream().filter(pattern -> NodeKind.MATCH_STRUCTURED_PATTERN_CLAUSE == pattern.getKind()).map(BLangMatchStructuredBindingPatternClause.class::cast).collect(Collectors.toList());
    }

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(";");
        this.patternClauses.forEach(pattern -> sj.add(pattern.toString()));
        return String.valueOf(this.expr) + " match {" + String.valueOf(sj) + "}";
    }

    public static class BLangMatchStructuredBindingPatternClause
    extends BLangMatchBindingPatternClause
    implements MatchNode.MatchStructuredBindingPatternNode {
        public BLangVariable bindingPatternVariable;
        public BLangExpression typeGuardExpr;

        @Override
        public NodeKind getKind() {
            return NodeKind.MATCH_STRUCTURED_PATTERN_CLAUSE;
        }

        @Override
        public BLangVariable getVariableNode() {
            return this.bindingPatternVariable;
        }

        @Override
        public BLangExpression getTypeGuardExpr() {
            return this.typeGuardExpr;
        }

        @Override
        public BLangStatement getStatement() {
            return this.body;
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }

        public String toString() {
            return String.valueOf(this.bindingPatternVariable) + " => " + String.valueOf(this.body);
        }
    }

    public static class BLangMatchStaticBindingPatternClause
    extends BLangMatchBindingPatternClause
    implements MatchNode.MatchStaticBindingPatternNode {
        public BLangExpression literal;

        @Override
        public NodeKind getKind() {
            return NodeKind.MATCH_STATIC_PATTERN_CLAUSE;
        }

        @Override
        public BLangExpression getLiteral() {
            return this.literal;
        }

        @Override
        public BLangStatement getStatement() {
            return this.body;
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }

        public String toString() {
            return String.valueOf(this.literal) + " => " + String.valueOf(this.body);
        }
    }

    public static class BLangMatchTypedBindingPatternClause
    extends BLangMatchBindingPatternClause
    implements MatchNode.MatchTypedBindingPatternNode {
        public BLangSimpleVariable variable;

        @Override
        public NodeKind getKind() {
            return NodeKind.MATCH_TYPED_PATTERN_CLAUSE;
        }

        @Override
        public BLangSimpleVariable getVariableNode() {
            return this.variable;
        }

        @Override
        public BLangStatement getStatement() {
            return this.body;
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }

        public String toString() {
            return String.valueOf(this.variable) + " => " + String.valueOf(this.body);
        }
    }

    public static abstract class BLangMatchBindingPatternClause
    extends BLangNode
    implements MatchNode.MatchBindingPatternNode {
        public BLangBlockStmt body;
        public BLangExpression matchExpr;
        public boolean isLastPattern;
    }
}

